/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class QueryBuilder {
    private final String quote;

    public QueryBuilder(String quote) {
        this.quote = Objects.requireNonNull(quote, "quote is null");
    }

    public PreparedStatement buildSql(JdbcClient client, Connection connection, String catalog, String schema, String table, List<JdbcColumnHandle> columns, TupleDomain<ColumnHandle> tupleDomain) throws SQLException {
        StringBuilder sql = new StringBuilder();
        String columnNames = columns.stream().map(JdbcColumnHandle::getColumnName).map(this::quote).collect(Collectors.joining(", "));
        sql.append("SELECT ");
        sql.append(columnNames);
        if (columns.isEmpty()) {
            sql.append("null");
        }
        sql.append(" FROM ");
        if (!Strings.isNullOrEmpty((String)catalog)) {
            sql.append(this.quote(catalog)).append('.');
        }
        if (!Strings.isNullOrEmpty((String)schema)) {
            sql.append(this.quote(schema)).append('.');
        }
        sql.append(this.quote(table));
        ArrayList<TypeAndValue> accumulator = new ArrayList<TypeAndValue>();
        List<String> clauses = this.toConjuncts(columns, tupleDomain, accumulator);
        if (!clauses.isEmpty()) {
            sql.append(" WHERE ").append(Joiner.on((String)" AND ").join(clauses));
        }
        PreparedStatement statement = client.getPreparedStatement(connection, sql.toString());
        for (int i = 0; i < accumulator.size(); ++i) {
            TypeAndValue typeAndValue = (TypeAndValue)accumulator.get(i);
            if (typeAndValue.getType().equals(BigintType.BIGINT)) {
                statement.setLong(i + 1, (Long)typeAndValue.getValue());
                continue;
            }
            if (typeAndValue.getType().equals(DoubleType.DOUBLE)) {
                statement.setDouble(i + 1, (Double)typeAndValue.getValue());
                continue;
            }
            if (typeAndValue.getType().equals(BooleanType.BOOLEAN)) {
                statement.setBoolean(i + 1, (Boolean)typeAndValue.getValue());
                continue;
            }
            throw new UnsupportedOperationException("Can't handle type: " + typeAndValue.getType());
        }
        return statement;
    }

    private static boolean isAcceptedType(Type type) {
        Type validType = Objects.requireNonNull(type, "type is null");
        return validType.equals(BigintType.BIGINT) || validType.equals(DoubleType.DOUBLE) || validType.equals(BooleanType.BOOLEAN);
    }

    private List<String> toConjuncts(List<JdbcColumnHandle> columns, TupleDomain<ColumnHandle> tupleDomain, List<TypeAndValue> accumulator) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JdbcColumnHandle column : columns) {
            Domain domain;
            Type type = column.getColumnType();
            if (!QueryBuilder.isAcceptedType(type) || (domain = (Domain)((Map)tupleDomain.getDomains().get()).get(column)) == null) continue;
            builder.add((Object)this.toPredicate(column.getColumnName(), domain, type, accumulator));
        }
        return builder.build();
    }

    private String toPredicate(String columnName, Domain domain, Type type, List<TypeAndValue> accumulator) {
        Preconditions.checkArgument((boolean)domain.getType().isOrderable(), (Object)"Domain type must be orderable");
        if (domain.getValues().isNone()) {
            return domain.isNullAllowed() ? this.quote(columnName) + " IS NULL" : "FALSE";
        }
        if (domain.getValues().isAll()) {
            return domain.isNullAllowed() ? "TRUE" : this.quote(columnName) + " IS NOT NULL";
        }
        ArrayList<String> disjuncts = new ArrayList<String>();
        ArrayList<Object> singleValues = new ArrayList<Object>();
        for (Range range : domain.getValues().getRanges().getOrderedRanges()) {
            Preconditions.checkState((!range.isAll() ? 1 : 0) != 0);
            if (range.isSingleValue()) {
                singleValues.add(range.getLow().getValue());
                continue;
            }
            ArrayList<String> rangeConjuncts = new ArrayList<String>();
            if (!range.getLow().isLowerUnbounded()) {
                switch (range.getLow().getBound()) {
                    case ABOVE: {
                        rangeConjuncts.add(this.toPredicate(columnName, ">", range.getLow().getValue(), type, accumulator));
                        break;
                    }
                    case EXACTLY: {
                        rangeConjuncts.add(this.toPredicate(columnName, ">=", range.getLow().getValue(), type, accumulator));
                        break;
                    }
                    case BELOW: {
                        throw new IllegalArgumentException("Low marker should never use BELOW bound");
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled bound: " + range.getLow().getBound()));
                    }
                }
            }
            if (!range.getHigh().isUpperUnbounded()) {
                switch (range.getHigh().getBound()) {
                    case ABOVE: {
                        throw new IllegalArgumentException("High marker should never use ABOVE bound");
                    }
                    case EXACTLY: {
                        rangeConjuncts.add(this.toPredicate(columnName, "<=", range.getHigh().getValue(), type, accumulator));
                        break;
                    }
                    case BELOW: {
                        rangeConjuncts.add(this.toPredicate(columnName, "<", range.getHigh().getValue(), type, accumulator));
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled bound: " + range.getHigh().getBound()));
                    }
                }
            }
            Preconditions.checkState((!rangeConjuncts.isEmpty() ? 1 : 0) != 0);
            disjuncts.add("(" + Joiner.on((String)" AND ").join(rangeConjuncts) + ")");
        }
        if (singleValues.size() == 1) {
            disjuncts.add(this.toPredicate(columnName, "=", Iterables.getOnlyElement(singleValues), type, accumulator));
        } else if (singleValues.size() > 1) {
            for (Object e : singleValues) {
                QueryBuilder.bindValue(e, type, accumulator);
            }
            String values = Joiner.on((String)",").join(Collections.nCopies(singleValues.size(), "?"));
            disjuncts.add(this.quote(columnName) + " IN (" + values + ")");
        }
        Preconditions.checkState((!disjuncts.isEmpty() ? 1 : 0) != 0);
        if (domain.isNullAllowed()) {
            disjuncts.add(this.quote(columnName) + " IS NULL");
        }
        return "(" + Joiner.on((String)" OR ").join(disjuncts) + ")";
    }

    private String toPredicate(String columnName, String operator, Object value, Type type, List<TypeAndValue> accumulator) {
        QueryBuilder.bindValue(value, type, accumulator);
        return this.quote(columnName) + " " + operator + " ?";
    }

    private String quote(String name) {
        name = name.replace(this.quote, this.quote + this.quote);
        return this.quote + name + this.quote;
    }

    private static void bindValue(Object value, Type type, List<TypeAndValue> accumulator) {
        Preconditions.checkArgument((boolean)QueryBuilder.isAcceptedType(type), (String)"Can't handle type: %s", (Object[])new Object[]{type});
        accumulator.add(new TypeAndValue(type, value));
    }

    private static class TypeAndValue {
        private final Type type;
        private final Object value;

        public TypeAndValue(Type type, Object value) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.value = Objects.requireNonNull(value, "value is null");
        }

        public Type getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

