/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.JdbcOutputTableHandle;
import com.facebook.presto.plugin.jdbc.JdbcRecordSink;
import com.facebook.presto.plugin.jdbc.Types;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.RecordSink;
import java.util.Objects;
import javax.inject.Inject;

public class JdbcRecordSinkProvider
implements ConnectorRecordSinkProvider {
    private final JdbcClient jdbcClient;

    @Inject
    public JdbcRecordSinkProvider(JdbcClient jdbcClient) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
    }

    public RecordSink getRecordSink(ConnectorSession session, ConnectorOutputTableHandle tableHandle) {
        return new JdbcRecordSink(Types.checkType(tableHandle, JdbcOutputTableHandle.class, "tableHandle"), this.jdbcClient);
    }

    public RecordSink getRecordSink(ConnectorSession session, ConnectorInsertTableHandle tableHandle) {
        throw new UnsupportedOperationException();
    }
}

