/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcMetadata;
import com.facebook.presto.plugin.jdbc.JdbcRecordSetProvider;
import com.facebook.presto.plugin.jdbc.JdbcRecordSinkProvider;
import com.facebook.presto.plugin.jdbc.JdbcSplitManager;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.ConnectorSplitManager;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.log.Logger;
import java.util.Objects;
import javax.inject.Inject;

public class JdbcConnector
implements Connector {
    private static final Logger log = Logger.get(JdbcConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final JdbcMetadata jdbcMetadata;
    private final JdbcSplitManager jdbcSplitManager;
    private final JdbcRecordSetProvider jdbcRecordSetProvider;
    private final JdbcRecordSinkProvider jdbcRecordSinkProvider;

    @Inject
    public JdbcConnector(LifeCycleManager lifeCycleManager, JdbcMetadata jdbcMetadata, JdbcSplitManager jdbcSplitManager, JdbcRecordSetProvider jdbcRecordSetProvider, JdbcRecordSinkProvider jdbcRecordSinkProvider) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.jdbcMetadata = Objects.requireNonNull(jdbcMetadata, "jdbcMetadata is null");
        this.jdbcSplitManager = Objects.requireNonNull(jdbcSplitManager, "jdbcSplitManager is null");
        this.jdbcRecordSetProvider = Objects.requireNonNull(jdbcRecordSetProvider, "jdbcRecordSetProvider is null");
        this.jdbcRecordSinkProvider = Objects.requireNonNull(jdbcRecordSinkProvider, "jdbcRecordSinkProvider is null");
    }

    public ConnectorMetadata getMetadata() {
        return this.jdbcMetadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.jdbcSplitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.jdbcRecordSetProvider;
    }

    public ConnectorRecordSinkProvider getRecordSinkProvider() {
        return this.jdbcRecordSinkProvider;
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }
}

