/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.JdbcConnectorId;
import com.facebook.presto.plugin.jdbc.JdbcPartition;
import com.facebook.presto.plugin.jdbc.JdbcTableHandle;
import com.facebook.presto.plugin.jdbc.Types;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPartition;
import com.facebook.presto.spi.ConnectorPartitionResult;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class JdbcSplitManager
implements ConnectorSplitManager {
    private final String connectorId;
    private final JdbcClient jdbcClient;

    @Inject
    public JdbcSplitManager(JdbcConnectorId connectorId, JdbcClient jdbcClient) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "client is null");
    }

    public ConnectorPartitionResult getPartitions(ConnectorSession session, ConnectorTableHandle tableHandle, TupleDomain<ColumnHandle> tupleDomain) {
        JdbcTableHandle handle = Types.checkType(tableHandle, JdbcTableHandle.class, "tableHandle");
        return this.jdbcClient.getPartitions(handle, tupleDomain);
    }

    public ConnectorSplitSource getPartitionSplits(ConnectorSession session, ConnectorTableHandle tableHandle, List<ConnectorPartition> partitions) {
        if (partitions.isEmpty()) {
            return new FixedSplitSource(this.connectorId, (Iterable)ImmutableList.of());
        }
        Preconditions.checkArgument((partitions.size() == 1 ? 1 : 0) != 0, (String)"Expected one partition but got %s", (Object[])new Object[]{partitions.size()});
        JdbcPartition partition = Types.checkType(partitions.get(0), JdbcPartition.class, "partition");
        return this.jdbcClient.getPartitionSplits(partition);
    }
}

