/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcConnectorId;
import com.facebook.presto.plugin.jdbc.JdbcMetadataConfig;
import com.facebook.presto.plugin.jdbc.JdbcOutputTableHandle;
import com.facebook.presto.plugin.jdbc.JdbcTableHandle;
import com.facebook.presto.plugin.jdbc.Types;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class JdbcMetadata
implements ConnectorMetadata {
    private final JdbcClient jdbcClient;
    private final boolean allowDropTable;

    @Inject
    public JdbcMetadata(JdbcConnectorId connectorId, JdbcClient jdbcClient, JdbcMetadataConfig config) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "client is null");
        Objects.requireNonNull(config, "config is null");
        this.allowDropTable = config.isAllowDropTable();
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.copyOf(this.jdbcClient.getSchemaNames());
    }

    public JdbcTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        return this.jdbcClient.getTableHandle(tableName);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        JdbcTableHandle handle = Types.checkType(table, JdbcTableHandle.class, "tableHandle");
        ImmutableList.Builder columnMetadata = ImmutableList.builder();
        for (JdbcColumnHandle column : this.jdbcClient.getColumns(handle)) {
            columnMetadata.add((Object)column.getColumnMetadata());
        }
        return new ConnectorTableMetadata(handle.getSchemaTableName(), (List)columnMetadata.build());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        return this.jdbcClient.getTableNames(schemaNameOrNull);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        JdbcTableHandle jdbcTableHandle = Types.checkType(tableHandle, JdbcTableHandle.class, "tableHandle");
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (JdbcColumnHandle column : this.jdbcClient.getColumns(jdbcTableHandle)) {
            columnHandles.put((Object)column.getColumnMetadata().getName(), (Object)column);
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix.getSchemaName())) {
            try {
                JdbcTableHandle tableHandle = this.jdbcClient.getTableHandle(tableName);
                if (tableHandle == null) continue;
                columns.put((Object)tableName, (Object)this.getTableMetadata(session, tableHandle).getColumns());
            }
            catch (TableNotFoundException tableNotFoundException) {}
        }
        return columns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        Types.checkType(tableHandle, JdbcTableHandle.class, "tableHandle");
        return Types.checkType(columnHandle, JdbcColumnHandle.class, "columnHandle").getColumnMetadata();
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        if (!this.allowDropTable) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "DROP TABLE is disabled in this catalog");
        }
        JdbcTableHandle handle = Types.checkType(tableHandle, JdbcTableHandle.class, "tableHandle");
        this.jdbcClient.dropTable(handle);
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        return this.jdbcClient.beginCreateTable(tableMetadata);
    }

    public void commitCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments) {
        JdbcOutputTableHandle handle = Types.checkType(tableHandle, JdbcOutputTableHandle.class, "tableHandle");
        this.jdbcClient.commitCreateTable(handle, fragments);
    }
}

