/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcConnectorId;
import com.facebook.presto.plugin.jdbc.JdbcOutputTableHandle;
import com.facebook.presto.plugin.jdbc.JdbcSplit;
import com.facebook.presto.plugin.jdbc.JdbcTableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import java.util.Objects;
import javax.inject.Inject;

public class JdbcHandleResolver
implements ConnectorHandleResolver {
    private final String connectorId;

    @Inject
    public JdbcHandleResolver(JdbcConnectorId clientId) {
        this.connectorId = Objects.requireNonNull(clientId, "clientId is null").toString();
    }

    public boolean canHandle(ConnectorTableHandle tableHandle) {
        return tableHandle instanceof JdbcTableHandle && ((JdbcTableHandle)tableHandle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ColumnHandle columnHandle) {
        return columnHandle instanceof JdbcColumnHandle && ((JdbcColumnHandle)columnHandle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorSplit split) {
        return split instanceof JdbcSplit && ((JdbcSplit)split).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorOutputTableHandle tableHandle) {
        return tableHandle instanceof JdbcOutputTableHandle && ((JdbcOutputTableHandle)tableHandle).getConnectorId().equals(this.connectorId);
    }

    public Class<? extends ConnectorTableHandle> getTableHandleClass() {
        return JdbcTableHandle.class;
    }

    public Class<? extends ColumnHandle> getColumnHandleClass() {
        return JdbcColumnHandle.class;
    }

    public Class<? extends ConnectorSplit> getSplitClass() {
        return JdbcSplit.class;
    }

    public Class<? extends ConnectorOutputTableHandle> getOutputTableHandleClass() {
        return JdbcOutputTableHandle.class;
    }
}

