/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.BaseJdbcConfig;
import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcConnectorId;
import com.facebook.presto.plugin.jdbc.JdbcOutputTableHandle;
import com.facebook.presto.plugin.jdbc.JdbcPartition;
import com.facebook.presto.plugin.jdbc.JdbcSplit;
import com.facebook.presto.plugin.jdbc.JdbcTableHandle;
import com.facebook.presto.plugin.jdbc.QueryBuilder;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorPartitionResult;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;

public class BaseJdbcClient
implements JdbcClient {
    private static final Logger log = Logger.get(BaseJdbcClient.class);
    private static final Map<Type, String> SQL_TYPES = ImmutableMap.builder().put((Object)BooleanType.BOOLEAN, (Object)"boolean").put((Object)BigintType.BIGINT, (Object)"bigint").put((Object)DoubleType.DOUBLE, (Object)"double precision").put((Object)VarcharType.VARCHAR, (Object)"varchar").put((Object)VarbinaryType.VARBINARY, (Object)"varbinary").put((Object)DateType.DATE, (Object)"date").put((Object)TimeType.TIME, (Object)"time").put((Object)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, (Object)"time with timezone").put((Object)TimestampType.TIMESTAMP, (Object)"timestamp").put((Object)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, (Object)"timestamp with timezone").build();
    protected final String connectorId;
    protected final Driver driver;
    protected final String connectionUrl;
    protected final Properties connectionProperties;
    protected final String identifierQuote;

    public BaseJdbcClient(JdbcConnectorId connectorId, BaseJdbcConfig config, String identifierQuote, Driver driver) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.identifierQuote = Objects.requireNonNull(identifierQuote, "identifierQuote is null");
        this.driver = Objects.requireNonNull(driver, "driver is null");
        Objects.requireNonNull(config, "config is null");
        this.connectionUrl = config.getConnectionUrl();
        this.connectionProperties = new Properties();
        if (config.getConnectionUser() != null) {
            this.connectionProperties.setProperty("user", config.getConnectionUser());
        }
        if (config.getConnectionPassword() != null) {
            this.connectionProperties.setProperty("password", config.getConnectionPassword());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Set<String> getSchemaNames() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<SchemaTableName> getTableNames(@Nullable String schema) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    public JdbcTableHandle getTableHandle(SchemaTableName schemaTableName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<JdbcColumnHandle> getColumns(JdbcTableHandle tableHandle) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ConnectorPartitionResult getPartitions(JdbcTableHandle jdbcTableHandle, TupleDomain<ColumnHandle> tupleDomain) {
        return new ConnectorPartitionResult((List)ImmutableList.of((Object)new JdbcPartition(jdbcTableHandle, tupleDomain)), tupleDomain);
    }

    @Override
    public ConnectorSplitSource getPartitionSplits(JdbcPartition jdbcPartition) {
        JdbcTableHandle jdbcTableHandle = jdbcPartition.getJdbcTableHandle();
        JdbcSplit jdbcSplit = new JdbcSplit(this.connectorId, jdbcTableHandle.getCatalogName(), jdbcTableHandle.getSchemaName(), jdbcTableHandle.getTableName(), this.connectionUrl, (Map<String, String>)Maps.fromProperties((Properties)this.connectionProperties), jdbcPartition.getTupleDomain());
        return new FixedSplitSource(this.connectorId, (Iterable)ImmutableList.of((Object)jdbcSplit));
    }

    @Override
    public Connection getConnection(JdbcSplit split) throws SQLException {
        Connection connection = this.driver.connect(split.getConnectionUrl(), BaseJdbcClient.toProperties(split.getConnectionProperties()));
        try {
            connection.setReadOnly(true);
        }
        catch (SQLException e) {
            connection.close();
            throw e;
        }
        return connection;
    }

    @Override
    public String buildSql(JdbcSplit split, List<JdbcColumnHandle> columnHandles) {
        return new QueryBuilder(this.identifierQuote).buildSql(split.getCatalogName(), split.getSchemaName(), split.getTableName(), columnHandles, split.getTupleDomain());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JdbcOutputTableHandle beginCreateTable(ConnectorTableMetadata tableMetadata) {
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schema = schemaTableName.getSchemaName();
        String table = schemaTableName.getTableName();
        if (!this.getSchemaNames().contains(schema)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Schema not found: " + schema);
        }
        try (Connection connection = this.driver.connect(this.connectionUrl, this.connectionProperties);){
            boolean uppercase = connection.getMetaData().storesUpperCaseIdentifiers();
            if (uppercase) {
                schema = schema.toUpperCase(Locale.ENGLISH);
                table = table.toUpperCase(Locale.ENGLISH);
            }
            String catalog = connection.getCatalog();
            String temporaryName = "tmp_presto_" + UUID.randomUUID().toString().replace("-", "");
            StringBuilder sql = new StringBuilder().append("CREATE TABLE ").append(this.quoted(catalog, schema, temporaryName)).append(" (");
            ImmutableList.Builder columnNames = ImmutableList.builder();
            ImmutableList.Builder columnTypes = ImmutableList.builder();
            ImmutableList.Builder columnList = ImmutableList.builder();
            for (ColumnMetadata column : tableMetadata.getColumns()) {
                String columnName = column.getName();
                if (uppercase) {
                    columnName = columnName.toUpperCase(Locale.ENGLISH);
                }
                columnNames.add((Object)columnName);
                columnTypes.add((Object)column.getType());
                columnList.add((Object)(this.quoted(columnName) + " " + this.toSqlType(column.getType())));
            }
            Joiner.on((String)", ").appendTo(sql, (Iterable)columnList.build());
            sql.append(")");
            this.execute(connection, sql.toString());
            JdbcOutputTableHandle jdbcOutputTableHandle = new JdbcOutputTableHandle(this.connectorId, catalog, schema, table, (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), tableMetadata.getOwner(), temporaryName, this.connectionUrl, (Map<String, String>)Maps.fromProperties((Properties)this.connectionProperties));
            return jdbcOutputTableHandle;
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void commitCreateTable(JdbcOutputTableHandle handle, Collection<Slice> fragments) {
        StringBuilder sql = new StringBuilder().append("ALTER TABLE ").append(this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTemporaryTableName())).append(" RENAME TO ").append(this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName()));
        try (Connection connection = this.getConnection(handle);){
            this.execute(connection, sql.toString());
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void dropTable(JdbcTableHandle handle) {
        StringBuilder sql = new StringBuilder().append("DROP TABLE ").append(this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName()));
        try (Connection connection = this.driver.connect(this.connectionUrl, this.connectionProperties);){
            this.execute(connection, sql.toString());
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public String buildInsertSql(JdbcOutputTableHandle handle) {
        String vars = Joiner.on((char)',').join(Collections.nCopies(handle.getColumnNames().size(), "?"));
        return "INSERT INTO " + this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTemporaryTableName()) + " VALUES (" + vars + ")";
    }

    @Override
    public Connection getConnection(JdbcOutputTableHandle handle) throws SQLException {
        return this.driver.connect(handle.getConnectionUrl(), BaseJdbcClient.toProperties(handle.getConnectionProperties()));
    }

    @Override
    public Statement getStatement(Connection connection) throws SQLException {
        return connection.createStatement();
    }

    protected ResultSet getTables(Connection connection, String schemaName, String tableName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        String escape = metadata.getSearchStringEscape();
        return metadata.getTables(connection.getCatalog(), BaseJdbcClient.escapeNamePattern(schemaName, escape), BaseJdbcClient.escapeNamePattern(tableName, escape), new String[]{"TABLE"});
    }

    protected SchemaTableName getSchemaTableName(ResultSet resultSet) throws SQLException {
        return new SchemaTableName(resultSet.getString("TABLE_SCHEM").toLowerCase(Locale.ENGLISH), resultSet.getString("TABLE_NAME").toLowerCase(Locale.ENGLISH));
    }

    protected void execute(Connection connection, String query) throws SQLException {
        try (Statement statement = connection.createStatement();){
            log.debug("Execute: %s", new Object[]{query});
            statement.execute(query);
        }
    }

    protected Type toPrestoType(int jdbcType) {
        switch (jdbcType) {
            case -7: 
            case 16: {
                return BooleanType.BOOLEAN;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return BigintType.BIGINT;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return DoubleType.DOUBLE;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return VarcharType.VARCHAR;
            }
            case -4: 
            case -3: 
            case -2: {
                return VarbinaryType.VARBINARY;
            }
            case 91: {
                return DateType.DATE;
            }
            case 92: {
                return TimeType.TIME;
            }
            case 93: {
                return TimestampType.TIMESTAMP;
            }
        }
        return null;
    }

    protected String toSqlType(Type type) {
        String sqlType = SQL_TYPES.get(type);
        if (sqlType != null) {
            return sqlType;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsuported column type: " + type.getTypeSignature());
    }

    protected String quoted(String name) {
        name = name.replace(this.identifierQuote, this.identifierQuote + this.identifierQuote);
        return this.identifierQuote + name + this.identifierQuote;
    }

    protected String quoted(String catalog, String schema, String table) {
        StringBuilder sb = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)catalog)) {
            sb.append(this.quoted(catalog)).append(".");
        }
        if (!Strings.isNullOrEmpty((String)schema)) {
            sb.append(this.quoted(schema)).append(".");
        }
        sb.append(this.quoted(table));
        return sb.toString();
    }

    protected static String escapeNamePattern(String name, String escape) {
        if (name == null || escape == null) {
            return name;
        }
        Preconditions.checkArgument((!escape.equals("_") ? 1 : 0) != 0, (Object)"Escape string must not be '_'");
        Preconditions.checkArgument((!escape.equals("%") ? 1 : 0) != 0, (Object)"Escape string must not be '%'");
        name = name.replace(escape, escape + escape);
        name = name.replace("_", escape + "_");
        name = name.replace("%", escape + "%");
        return name;
    }

    private static ResultSet getColumns(JdbcTableHandle tableHandle, DatabaseMetaData metadata) throws SQLException {
        String escape = metadata.getSearchStringEscape();
        return metadata.getColumns(tableHandle.getCatalogName(), BaseJdbcClient.escapeNamePattern(tableHandle.getSchemaName(), escape), BaseJdbcClient.escapeNamePattern(tableHandle.getTableName(), escape), null);
    }

    private static Properties toProperties(Map<String, String> map) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
        return properties;
    }
}

