/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.TupleDomain;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class JdbcSplit
implements ConnectorSplit {
    private final String connectorId;
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final String connectionUrl;
    private final Map<String, String> connectionProperties;
    private final TupleDomain<ColumnHandle> tupleDomain;

    @JsonCreator
    public JdbcSplit(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="catalogName") @Nullable String catalogName, @JsonProperty(value="schemaName") @Nullable String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="connectionUrl") String connectionUrl, @JsonProperty(value="connectionProperties") Map<String, String> connectionProperties, @JsonProperty(value="tupleDomain") TupleDomain<ColumnHandle> tupleDomain) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connector id is null");
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName, (Object)"table name is null");
        this.connectionUrl = (String)Preconditions.checkNotNull((Object)connectionUrl, (Object)"connectionUrl is null");
        this.connectionProperties = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(connectionProperties, (Object)"connectionProperties is null")));
        this.tupleDomain = (TupleDomain)Preconditions.checkNotNull(tupleDomain, (Object)"tupleDomain is null");
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    @Nullable
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @JsonProperty
    public Map<String, String> getConnectionProperties() {
        return this.connectionProperties;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getTupleDomain() {
        return this.tupleDomain;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of();
    }

    public Object getInfo() {
        return this;
    }
}

