/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer.utils;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;

public class MetadataUtils {
    private MetadataUtils() {
    }

    public static QualifiedObjectName createQualifiedObjectName(Optional<String> sessionCatalogName, Optional<String> sessionSchemaName, Node node, QualifiedName name, BiFunction<String, String, String> normalizer) {
        Objects.requireNonNull(sessionCatalogName, "sessionCatalogName is null");
        Objects.requireNonNull(sessionSchemaName, "sessionSchemaName is null");
        Objects.requireNonNull(name, "name is null");
        if (name.getParts().size() > 3) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, String.format("Too many dots in table name: %s", name));
        }
        List parts = Lists.reverse((List)name.getOriginalParts());
        String objectName = ((Identifier)parts.get(0)).getValue();
        String schemaName = parts.size() > 1 ? ((Identifier)parts.get(1)).getValue() : sessionSchemaName.orElseThrow(() -> new SemanticException(SemanticErrorCode.SCHEMA_NOT_SPECIFIED, node, "Schema must be specified when session schema is not set", new Object[0]));
        String catalogName = parts.size() > 2 ? ((Identifier)parts.get(2)).getValue() : sessionCatalogName.orElseThrow(() -> new SemanticException(SemanticErrorCode.CATALOG_NOT_SPECIFIED, node, "Catalog must be specified when session catalog is not set", new Object[0]));
        catalogName = catalogName.toLowerCase(Locale.ENGLISH);
        schemaName = normalizer.apply(catalogName, schemaName);
        objectName = normalizer.apply(catalogName, objectName);
        return new QualifiedObjectName(catalogName, schemaName, objectName);
    }
}

