/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.WarningHandlingLevel;
import com.facebook.presto.common.analyzer.PreparedQuery;
import com.facebook.presto.common.resourceGroups.QueryType;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.analyzer.AnalyzerOptions;
import com.facebook.presto.spi.analyzer.QueryPreparer;
import com.facebook.presto.spi.procedure.ProcedureRegistry;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.analyzer.ConstantExpressionVerifier;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.utils.AnalyzerUtil;
import com.facebook.presto.sql.analyzer.utils.MetadataUtils;
import com.facebook.presto.sql.analyzer.utils.ParameterExtractor;
import com.facebook.presto.sql.analyzer.utils.StatementUtils;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Call;
import com.facebook.presto.sql.tree.Execute;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class BuiltInQueryPreparer
implements QueryPreparer {
    private final SqlParser sqlParser;
    private final ProcedureRegistry procedureRegistry;

    @Inject
    public BuiltInQueryPreparer(SqlParser sqlParser, ProcedureRegistry procedureRegistry) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.procedureRegistry = Objects.requireNonNull(procedureRegistry, "procedureRegistry is null");
    }

    public BuiltInPreparedQuery prepareQuery(AnalyzerOptions analyzerOptions, String query, Map<String, String> preparedStatements, WarningCollector warningCollector) {
        Statement wrappedStatement = this.sqlParser.createStatement(query, AnalyzerUtil.createParsingOptions(analyzerOptions));
        if (warningCollector.hasWarnings() && analyzerOptions.getWarningHandlingLevel() == WarningHandlingLevel.AS_ERROR) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.WARNING_AS_ERROR, String.format("Warning handling level set to AS_ERROR. Warnings: %n %s", warningCollector.getWarnings().stream().map(PrestoWarning::getMessage).collect(Collectors.joining(System.lineSeparator()))));
        }
        return this.prepareQuery(analyzerOptions, wrappedStatement, preparedStatements);
    }

    public BuiltInPreparedQuery prepareQuery(AnalyzerOptions analyzerOptions, Statement wrappedStatement, Map<String, String> preparedStatements) {
        Statement innerStatement;
        Optional<QueryType> innerQueryType;
        Statement statement = wrappedStatement;
        Optional<Object> prepareSql = Optional.empty();
        if (statement instanceof Execute) {
            String preparedStatementName = ((Execute)statement).getName().getValue();
            prepareSql = Optional.ofNullable(preparedStatements.get(preparedStatementName));
            String query = (String)prepareSql.orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Prepared statement not found: " + preparedStatementName));
            statement = this.sqlParser.createStatement(query, AnalyzerUtil.createParsingOptions(analyzerOptions));
        }
        Optional<QualifiedObjectName> distributedProcedureName = Optional.empty();
        if (statement instanceof Call) {
            QualifiedName qualifiedName = ((Call)statement).getName();
            QualifiedObjectName qualifiedObjectName = MetadataUtils.createQualifiedObjectName(analyzerOptions.getSessionCatalogName(), analyzerOptions.getSessionSchemaName(), (Node)statement, qualifiedName, (catalogName, objectName) -> objectName);
            if (this.procedureRegistry.isDistributedProcedure(new ConnectorId(qualifiedObjectName.getCatalogName()), new SchemaTableName(qualifiedObjectName.getSchemaName(), qualifiedObjectName.getObjectName()))) {
                distributedProcedureName = Optional.of(qualifiedObjectName);
            }
        }
        if (statement instanceof Explain && ((Explain)statement).isAnalyze() && (!(innerQueryType = StatementUtils.getQueryType((innerStatement = ((Explain)statement).getStatement()).getClass())).isPresent() || innerQueryType.get() == QueryType.DATA_DEFINITION || innerQueryType.get() == QueryType.CONTROL)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "EXPLAIN ANALYZE doesn't support statement type: " + innerStatement.getClass().getSimpleName());
        }
        Object parameters = ImmutableList.of();
        if (wrappedStatement instanceof Execute) {
            parameters = ((Execute)wrappedStatement).getParameters();
        }
        BuiltInQueryPreparer.validateParameters(statement, (List<Expression>)parameters);
        Optional<String> formattedQuery = Optional.empty();
        if (analyzerOptions.isLogFormattedQueryEnabled()) {
            formattedQuery = Optional.of(BuiltInQueryPreparer.getFormattedQuery(statement, (List<Expression>)parameters));
        }
        return new BuiltInPreparedQuery(wrappedStatement, statement, (List<Expression>)parameters, formattedQuery, prepareSql, distributedProcedureName);
    }

    private static String getFormattedQuery(Statement statement, List<Expression> parameters) {
        String formattedQuery = SqlFormatter.formatSql((Node)statement, parameters.isEmpty() ? Optional.empty() : Optional.of(parameters));
        return String.format("-- Formatted Query:%n%s", formattedQuery);
    }

    private static void validateParameters(Statement node, List<Expression> parameterValues) {
        int parameterCount = ParameterExtractor.getParameterCount(node);
        if (parameterValues.size() != parameterCount) {
            throw new SemanticException(SemanticErrorCode.INVALID_PARAMETER_USAGE, (Node)node, "Incorrect number of parameters: expected %s but found %s", parameterCount, parameterValues.size());
        }
        for (Expression expression : parameterValues) {
            ConstantExpressionVerifier.verifyExpressionIsConstant((Set<NodeRef<Expression>>)ImmutableSet.of(), expression);
        }
    }

    public static class BuiltInPreparedQuery
    extends PreparedQuery {
        private final Statement statement;
        private final Statement wrappedStatement;
        private final List<Expression> parameters;
        private final Optional<QualifiedObjectName> distributedProcedureName;

        public BuiltInPreparedQuery(Statement wrappedStatement, Statement statement, List<Expression> parameters, Optional<String> formattedQuery, Optional<String> prepareSql, Optional<QualifiedObjectName> distributedProcedureName) {
            super(formattedQuery, prepareSql);
            this.wrappedStatement = Objects.requireNonNull(wrappedStatement, "wrappedStatement is null");
            this.statement = Objects.requireNonNull(statement, "statement is null");
            this.parameters = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameters, "parameters is null"));
            this.distributedProcedureName = Objects.requireNonNull(distributedProcedureName, "distributedProcedureName is null");
        }

        public Statement getStatement() {
            return this.statement;
        }

        public Statement getWrappedStatement() {
            return this.wrappedStatement;
        }

        public List<Expression> getParameters() {
            return this.parameters;
        }

        public Optional<QueryType> getQueryType() {
            if (this.getDistributedProcedureName().isPresent()) {
                return Optional.of(QueryType.CALL_DISTRIBUTED_PROCEDURE);
            }
            return StatementUtils.getQueryType(this.statement.getClass());
        }

        public Optional<QualifiedObjectName> getDistributedProcedureName() {
            return this.distributedProcedureName;
        }

        public boolean isTransactionControlStatement() {
            return StatementUtils.isTransactionControlStatement(this.getStatement());
        }

        public boolean isRollbackStatement() {
            return StatementUtils.isRollbackStatement(this.getStatement());
        }

        public boolean isExplainTypeValidate() {
            if (!(this.statement instanceof Explain)) {
                return false;
            }
            return ((Explain)this.statement).getOptions().stream().filter(option -> option instanceof ExplainType).map(option -> (ExplainType)option).anyMatch(explainType -> explainType.getType() == ExplainType.Type.VALIDATE);
        }
    }
}

