/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.MaterializedViewDefinition;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.analyzer.ViewDefinition;
import com.facebook.presto.sql.analyzer.TableColumnMetadata;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class MetadataHandle {
    private boolean preProcessMetadataCalls;
    private final Map<QualifiedObjectName, Future<Optional<ViewDefinition>>> viewDefinitions = new ConcurrentHashMap<QualifiedObjectName, Future<Optional<ViewDefinition>>>();
    private final Map<QualifiedObjectName, Future<Optional<MaterializedViewDefinition>>> materializedViewDefinitions = new ConcurrentHashMap<QualifiedObjectName, Future<Optional<MaterializedViewDefinition>>>();
    private final Map<QualifiedObjectName, Future<TableColumnMetadata>> tableColumnsMetadata = new ConcurrentHashMap<QualifiedObjectName, Future<TableColumnMetadata>>();

    public boolean isPreProcessMetadataCalls() {
        return this.preProcessMetadataCalls;
    }

    public void setPreProcessMetadataCalls(boolean preProcessMetadataCalls) {
        this.preProcessMetadataCalls = preProcessMetadataCalls;
    }

    public void addViewDefinition(QualifiedObjectName viewName, Future<Optional<ViewDefinition>> viewDefinition) {
        this.viewDefinitions.putIfAbsent(viewName, viewDefinition);
    }

    public void addMaterializedViewDefinition(QualifiedObjectName viewName, Future<Optional<MaterializedViewDefinition>> viewDefinition) {
        this.materializedViewDefinitions.putIfAbsent(viewName, viewDefinition);
    }

    public void addTableColumnMetadata(QualifiedObjectName tableName, Future<TableColumnMetadata> tableColumnMetadata) {
        this.tableColumnsMetadata.putIfAbsent(tableName, tableColumnMetadata);
    }

    public Optional<ViewDefinition> getViewDefinition(QualifiedObjectName viewName) {
        if (!this.viewDefinitions.containsKey(viewName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.VIEW_NOT_FOUND, String.format("View %s not found, the available view names are: %s", viewName, this.viewDefinitions.keySet()));
        }
        try {
            return this.viewDefinitions.get(viewName).get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            Throwables.throwIfUnchecked((Throwable)ex.getCause());
            throw new RuntimeException(ex.getCause());
        }
    }

    public Optional<MaterializedViewDefinition> getMaterializedViewDefinition(QualifiedObjectName viewName) {
        Preconditions.checkState((boolean)this.materializedViewDefinitions.containsKey(viewName), (Object)("View " + viewName + " not found"));
        try {
            return this.materializedViewDefinitions.get(viewName).get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            Throwables.throwIfUnchecked((Throwable)ex.getCause());
            throw new RuntimeException(ex.getCause());
        }
    }

    public TableColumnMetadata getTableColumnsMetadata(QualifiedObjectName tableName) {
        Preconditions.checkState((boolean)this.tableColumnsMetadata.containsKey(tableName), (Object)("Table " + tableName + " not found"));
        try {
            return this.tableColumnsMetadata.get(tableName).get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            Throwables.throwIfUnchecked((Throwable)ex.getCause());
            throw new RuntimeException(ex.getCause());
        }
    }
}

