/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.analyzer.AccessControlReferences;
import com.facebook.presto.spi.analyzer.QueryAnalysis;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.tree.Explain;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class BuiltInQueryAnalysis
implements QueryAnalysis {
    private final Analysis analysis;

    public BuiltInQueryAnalysis(Analysis analysis) {
        this.analysis = analysis;
    }

    public Analysis getAnalysis() {
        return this.analysis;
    }

    public String getUpdateType() {
        return this.analysis.getUpdateType();
    }

    public Optional<String> getExpandedQuery() {
        return this.analysis.getExpandedQuery();
    }

    public Map<FunctionKind, Set<String>> getInvokedFunctions() {
        return this.analysis.getInvokedFunctions();
    }

    public AccessControlReferences getAccessControlReferences() {
        return this.analysis.getAccessControlReferences();
    }

    public boolean isExplainAnalyzeQuery() {
        return this.analysis.getStatement() instanceof Explain && ((Explain)this.analysis.getStatement()).isAnalyze();
    }

    public Set<ConnectorId> extractConnectors() {
        ImmutableSet.Builder connectors = ImmutableSet.builder();
        for (TableHandle tableHandle : this.analysis.getTables()) {
            connectors.add((Object)tableHandle.getConnectorId());
        }
        if (this.analysis.getInsert().isPresent()) {
            TableHandle target = this.analysis.getInsert().get().getTarget();
            connectors.add((Object)target.getConnectorId());
        }
        return connectors.build();
    }
}

