/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.Scope;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ResolvedField {
    private final Scope scope;
    private final Field field;
    private final int hierarchyFieldIndex;
    private final int relationFieldIndex;
    private final boolean local;

    public ResolvedField(Scope scope, Field field, int hierarchyFieldIndex, int relationFieldIndex, boolean local) {
        this.scope = Objects.requireNonNull(scope, "scope is null");
        this.field = Objects.requireNonNull(field, "field is null");
        this.hierarchyFieldIndex = hierarchyFieldIndex;
        this.relationFieldIndex = relationFieldIndex;
        this.local = local;
    }

    public Type getType() {
        return this.field.getType();
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean isLocal() {
        return this.local;
    }

    public int getHierarchyFieldIndex() {
        return this.hierarchyFieldIndex;
    }

    public int getRelationFieldIndex() {
        return this.relationFieldIndex;
    }

    public Field getField() {
        return this.field;
    }
}

