/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;

public class SemanticException
extends RuntimeException {
    private final SemanticErrorCode code;
    private final Optional<NodeLocation> location;

    public SemanticException(SemanticErrorCode code, String format, Object ... args) {
        this(code, Optional.empty(), format, args);
    }

    public SemanticException(SemanticErrorCode code, Node node, String format, Object ... args) {
        this(code, node == null ? Optional.empty() : node.getLocation(), format, args);
    }

    public SemanticException(SemanticErrorCode code, Optional<NodeLocation> location, String format, Object ... args) {
        super(SemanticException.formatMessage(format, location, args));
        Objects.requireNonNull(code, "code is null");
        this.code = code;
        this.location = location;
    }

    public Optional<NodeLocation> getLocation() {
        return this.location;
    }

    public SemanticErrorCode getCode() {
        return this.code;
    }

    private static String formatMessage(String formatString, Optional<NodeLocation> location, Object[] args) {
        if (location.isPresent()) {
            NodeLocation nodeLocation = location.get();
            return String.format("line %s:%s: %s", nodeLocation.getLineNumber(), nodeLocation.getColumnNumber(), String.format(formatString, args));
        }
        return String.format(formatString, args);
    }
}

