/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo.conf;

import com.facebook.presto.accumulo.serializers.AccumuloRowSerializer;
import com.facebook.presto.accumulo.serializers.LexicoderRowSerializer;
import com.facebook.presto.accumulo.serializers.StringRowSerializer;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class AccumuloTableProperties {
    public static final String COLUMN_MAPPING = "column_mapping";
    public static final String INDEX_COLUMNS = "index_columns";
    public static final String EXTERNAL = "external";
    public static final String LOCALITY_GROUPS = "locality_groups";
    public static final String ROW_ID = "row_id";
    public static final String SERIALIZER = "serializer";
    public static final String SCAN_AUTHS = "scan_auths";
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':').trimResults();
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private static final Splitter PIPE_SPLITTER = Splitter.on((char)'|').omitEmptyStrings().trimResults();
    private final List<PropertyMetadata<?>> tableProperties;

    public AccumuloTableProperties() {
        PropertyMetadata s1 = PropertyMetadata.stringProperty((String)COLUMN_MAPPING, (String)"Comma-delimited list of column metadata: col_name:col_family:col_qualifier,[...]. Required for external tables. Not setting this property results in auto-generated column names.", null, (boolean)false);
        PropertyMetadata s2 = PropertyMetadata.stringProperty((String)INDEX_COLUMNS, (String)"A comma-delimited list of Presto columns that are indexed in this table's corresponding index table. Default is no indexed columns.", (String)"", (boolean)false);
        PropertyMetadata s3 = PropertyMetadata.booleanProperty((String)EXTERNAL, (String)"If true, Presto will only do metadata operations for the table. Else, Presto will create and drop Accumulo tables where appropriate. Default false.", (Boolean)false, (boolean)false);
        PropertyMetadata s4 = PropertyMetadata.stringProperty((String)LOCALITY_GROUPS, (String)"List of locality groups to set on the Accumulo table. Only valid on internal tables. String format is locality group name, colon, comma delimited list of Presto column names in the group. Groups are delimited by pipes. Example: group1:colA,colB,colC|group2:colD,colE,colF|etc.... Default is no locality groups.", null, (boolean)false);
        PropertyMetadata s5 = PropertyMetadata.stringProperty((String)ROW_ID, (String)"Presto column name that maps to the Accumulo row ID. Default is the first column.", null, (boolean)false);
        PropertyMetadata s6 = new PropertyMetadata(SERIALIZER, "Serializer for Accumulo data encodings. Can either be 'default', 'string', 'lexicoder', or a Java class name. Default is 'default', i.e. the value from AccumuloRowSerializer.getDefault(), i.e. 'lexicoder'.", (Type)VarcharType.VARCHAR, String.class, (Object)AccumuloRowSerializer.getDefault().getClass().getName(), false, x -> x.equals("default") ? AccumuloRowSerializer.getDefault().getClass().getName() : (x.equals("string") ? StringRowSerializer.class.getName() : (x.equals("lexicoder") ? LexicoderRowSerializer.class.getName() : (String)x)), object -> object);
        PropertyMetadata s7 = PropertyMetadata.stringProperty((String)SCAN_AUTHS, (String)"Scan-time authorizations set on the batch scanner. Default is all scan authorizations for the user", null, (boolean)false);
        this.tableProperties = ImmutableList.of((Object)s1, (Object)s2, (Object)s3, (Object)s4, (Object)s5, (Object)s6, (Object)s7);
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public static Optional<Map<String, Pair<String, String>>> getColumnMapping(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        String strMapping = (String)tableProperties.get(COLUMN_MAPPING);
        if (strMapping == null) {
            return Optional.empty();
        }
        ImmutableMap.Builder mapping = ImmutableMap.builder();
        for (String m : COMMA_SPLITTER.split((CharSequence)strMapping)) {
            String[] tokens = (String[])Iterables.toArray((Iterable)COLON_SPLITTER.split((CharSequence)m), String.class);
            Preconditions.checkState((tokens.length == 3 ? 1 : 0) != 0, (Object)String.format("Mapping of %s contains %d tokens instead of 3", m, tokens.length));
            mapping.put((Object)tokens[0], (Object)Pair.of((Object)tokens[1], (Object)tokens[2]));
        }
        return Optional.of(mapping.build());
    }

    public static Optional<List<String>> getIndexColumns(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        String indexColumns = (String)tableProperties.get(INDEX_COLUMNS);
        if (indexColumns == null) {
            return Optional.empty();
        }
        return Optional.of(Arrays.asList(StringUtils.split((String)indexColumns, (char)',')));
    }

    public static Optional<Map<String, Set<String>>> getLocalityGroups(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        String groupStr = (String)tableProperties.get(LOCALITY_GROUPS);
        if (groupStr == null) {
            return Optional.empty();
        }
        ImmutableMap.Builder groups = ImmutableMap.builder();
        for (String group : PIPE_SPLITTER.split((CharSequence)groupStr)) {
            String[] locGroups = (String[])Iterables.toArray((Iterable)COLON_SPLITTER.split((CharSequence)group), String.class);
            if (locGroups.length != 2) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Locality groups string is malformed. See documentation for proper format.");
            }
            String grpName = locGroups[0];
            ImmutableSet.Builder colSet = ImmutableSet.builder();
            for (String f : COMMA_SPLITTER.split((CharSequence)locGroups[1])) {
                colSet.add((Object)f.toLowerCase(Locale.ENGLISH));
            }
            groups.put((Object)grpName.toLowerCase(Locale.ENGLISH), (Object)colSet.build());
        }
        return Optional.of(groups.build());
    }

    public static Optional<String> getRowId(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        String rowId = (String)tableProperties.get(ROW_ID);
        return Optional.ofNullable(rowId);
    }

    public static Optional<String> getScanAuthorizations(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        String scanAuths = (String)tableProperties.get(SCAN_AUTHS);
        return Optional.ofNullable(scanAuths);
    }

    public static String getSerializerClass(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        String serializerClass = (String)tableProperties.get(SERIALIZER);
        return serializerClass;
    }

    public static boolean isExternal(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        Boolean serializerClass = (Boolean)tableProperties.get(EXTERNAL);
        return serializerClass;
    }
}

