/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo.model;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public final class AccumuloColumnHandle
implements ColumnHandle,
Comparable<AccumuloColumnHandle> {
    private final boolean indexed;
    private final Optional<String> family;
    private final Optional<String> qualifier;
    private final Type type;
    private final String comment;
    private final String name;
    private final int ordinal;

    @JsonCreator
    public AccumuloColumnHandle(@JsonProperty(value="name") String name, @JsonProperty(value="family") Optional<String> family, @JsonProperty(value="qualifier") Optional<String> qualifier, @JsonProperty(value="type") Type type, @JsonProperty(value="ordinal") int ordinal, @JsonProperty(value="comment") String comment, @JsonProperty(value="indexed") boolean indexed) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.family = Objects.requireNonNull(family, "family is null");
        this.qualifier = Objects.requireNonNull(qualifier, "qualifier is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.ordinal = Objects.requireNonNull(Integer.valueOf(ordinal), "type is null");
        Preconditions.checkArgument((ordinal >= 0 ? 1 : 0) != 0, (Object)"ordinal must be >= zero");
        this.comment = Objects.requireNonNull(comment, "comment is null");
        this.indexed = indexed;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Optional<String> getFamily() {
        return this.family;
    }

    @JsonProperty
    public Optional<String> getQualifier() {
        return this.qualifier;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public int getOrdinal() {
        return this.ordinal;
    }

    @JsonProperty
    public String getComment() {
        return this.comment;
    }

    @JsonIgnore
    public ColumnMetadata getColumnMetadata() {
        return new ColumnMetadata(this.name, this.type, this.comment, false);
    }

    @JsonProperty
    public boolean isIndexed() {
        return this.indexed;
    }

    public int hashCode() {
        return Objects.hash(this.indexed, this.name, this.family, this.qualifier, this.type, this.ordinal, this.comment);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AccumuloColumnHandle other = (AccumuloColumnHandle)obj;
        return Objects.equals(this.indexed, other.indexed) && Objects.equals(this.name, other.name) && Objects.equals(this.family, other.family) && Objects.equals(this.qualifier, other.qualifier) && Objects.equals(this.type, other.type) && Objects.equals(this.ordinal, other.ordinal) && Objects.equals(this.comment, other.comment);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("columnFamily", this.family.orElse(null)).add("columnQualifier", this.qualifier.orElse(null)).add("type", (Object)this.type).add("ordinal", this.ordinal).add("comment", (Object)this.comment).add("indexed", this.indexed).toString();
    }

    @Override
    public int compareTo(AccumuloColumnHandle obj) {
        return Integer.compare(this.getOrdinal(), obj.getOrdinal());
    }
}

