/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo.iterators;

import com.google.common.primitives.UnsignedBytes;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Combiner;

public class MaxByteArrayCombiner
extends Combiner {
    private final Comparator<byte[]> comparator = UnsignedBytes.lexicographicalComparator();

    public Value reduce(Key key, Iterator<Value> iter) {
        Value max = null;
        while (iter.hasNext()) {
            Value test = iter.next();
            if (max == null) {
                max = new Value(test.get());
                continue;
            }
            if (this.comparator.compare(test.get(), max.get()) <= 0) continue;
            max.set(test.get());
        }
        return max;
    }
}

