/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo.serializers;

import com.facebook.presto.accumulo.Types;
import com.facebook.presto.accumulo.io.AccumuloPageSink;
import com.facebook.presto.accumulo.serializers.AccumuloRowSerializer;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import io.airlift.slice.Slice;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;

public class StringRowSerializer
implements AccumuloRowSerializer {
    private final Map<String, Map<String, String>> familyQualifierColumnMap = new HashMap<String, Map<String, String>>();
    private final Map<String, Object> columnValues = new HashMap<String, Object>();
    private final Text rowId = new Text();
    private final Text family = new Text();
    private final Text qualifier = new Text();
    private final Text value = new Text();
    private boolean rowOnly;
    private String rowIdName;

    @Override
    public void setRowIdName(String name) {
        this.rowIdName = name;
    }

    @Override
    public void setRowOnly(boolean rowOnly) {
        this.rowOnly = rowOnly;
    }

    @Override
    public void setMapping(String name, String family, String qualifier) {
        this.columnValues.put(name, null);
        Map<String, String> qualifierColumnMap = this.familyQualifierColumnMap.get(family);
        if (qualifierColumnMap == null) {
            qualifierColumnMap = new HashMap<String, String>();
            this.familyQualifierColumnMap.put(family, qualifierColumnMap);
        }
        qualifierColumnMap.put(qualifier, name);
    }

    @Override
    public void reset() {
        this.columnValues.clear();
    }

    @Override
    public void deserialize(Map.Entry<Key, Value> entry) {
        if (!this.columnValues.containsKey(this.rowIdName)) {
            entry.getKey().getRow(this.rowId);
            this.columnValues.put(this.rowIdName, this.rowId.toString());
        }
        if (this.rowOnly) {
            return;
        }
        entry.getKey().getColumnFamily(this.family);
        entry.getKey().getColumnQualifier(this.qualifier);
        if (this.family.equals((Object)AccumuloPageSink.ROW_ID_COLUMN) && this.qualifier.equals((Object)AccumuloPageSink.ROW_ID_COLUMN)) {
            return;
        }
        this.value.set(entry.getValue().get());
        this.columnValues.put(this.familyQualifierColumnMap.get(this.family.toString()).get(this.qualifier.toString()), this.value.toString());
    }

    @Override
    public boolean isNull(String name) {
        return this.columnValues.get(name) == null;
    }

    @Override
    public Block getArray(String name, Type type) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "arrays are not (yet?) supported for StringRowSerializer");
    }

    @Override
    public void setArray(Text text, Type type, Block block) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "arrays are not (yet?) supported for StringRowSerializer");
    }

    @Override
    public boolean getBoolean(String name) {
        return Boolean.parseBoolean(this.getFieldValue(name));
    }

    @Override
    public void setBoolean(Text text, Boolean value) {
        text.set(value.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public byte getByte(String name) {
        return Byte.parseByte(this.getFieldValue(name));
    }

    @Override
    public void setByte(Text text, Byte value) {
        text.set(value.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public Date getDate(String name) {
        return new Date(TimeUnit.DAYS.toMillis(Long.parseLong(this.getFieldValue(name))));
    }

    @Override
    public void setDate(Text text, Date value) {
        text.set(Long.toString(TimeUnit.MILLISECONDS.toDays(value.getTime())).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public double getDouble(String name) {
        return Double.parseDouble(this.getFieldValue(name));
    }

    @Override
    public void setDouble(Text text, Double value) {
        text.set(value.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public float getFloat(String name) {
        return Float.parseFloat(this.getFieldValue(name));
    }

    @Override
    public void setFloat(Text text, Float value) {
        text.set(value.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public int getInt(String name) {
        return Integer.parseInt(this.getFieldValue(name));
    }

    @Override
    public void setInt(Text text, Integer value) {
        text.set(value.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public long getLong(String name) {
        return Long.parseLong(this.getFieldValue(name));
    }

    @Override
    public void setLong(Text text, Long value) {
        text.set(value.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public Block getMap(String name, Type type) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "maps are not (yet?) supported for StringRowSerializer");
    }

    @Override
    public void setMap(Text text, Type type, Block block) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "maps are not (yet?) supported for StringRowSerializer");
    }

    @Override
    public short getShort(String name) {
        return Short.parseShort(this.getFieldValue(name));
    }

    @Override
    public void setShort(Text text, Short value) {
        text.set(value.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public Time getTime(String name) {
        return new Time(Long.parseLong(this.getFieldValue(name)));
    }

    @Override
    public void setTime(Text text, Time value) {
        text.set(Long.toString(value.getTime()).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public Timestamp getTimestamp(String name) {
        return new Timestamp(Long.parseLong(this.getFieldValue(name)));
    }

    @Override
    public void setTimestamp(Text text, Timestamp value) {
        text.set(Long.toString(value.getTime()).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public byte[] getVarbinary(String name) {
        return this.getFieldValue(name).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public void setVarbinary(Text text, byte[] value) {
        text.set(value);
    }

    @Override
    public String getVarchar(String name) {
        return this.getFieldValue(name);
    }

    @Override
    public void setVarchar(Text text, String value) {
        text.set(value.getBytes(StandardCharsets.UTF_8));
    }

    private String getFieldValue(String name) {
        return this.columnValues.get(name).toString();
    }

    @Override
    public byte[] encode(Type type, Object value) {
        Text text = new Text();
        if (Types.isArrayType(type)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "arrays are not (yet?) supported for StringRowSerializer");
        }
        if (Types.isMapType(type)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "maps are not (yet?) supported for StringRowSerializer");
        }
        if (type.equals(BigintType.BIGINT) && value instanceof Integer) {
            this.setLong(text, ((Integer)value).longValue());
        } else if (type.equals(BigintType.BIGINT) && value instanceof Long) {
            this.setLong(text, (Long)value);
        } else if (type.equals(BooleanType.BOOLEAN)) {
            this.setBoolean(text, value.equals(Boolean.TRUE));
        } else if (type.equals(DateType.DATE)) {
            this.setDate(text, (Date)value);
        } else if (type.equals(DoubleType.DOUBLE)) {
            this.setDouble(text, (Double)value);
        } else if (type.equals(IntegerType.INTEGER) && value instanceof Integer) {
            this.setInt(text, (Integer)value);
        } else if (type.equals(IntegerType.INTEGER) && value instanceof Long) {
            this.setInt(text, ((Long)value).intValue());
        } else if (type.equals(RealType.REAL)) {
            this.setFloat(text, (Float)value);
        } else if (type.equals(SmallintType.SMALLINT)) {
            this.setShort(text, (Short)value);
        } else if (type.equals(TimeType.TIME)) {
            this.setTime(text, (Time)value);
        } else if (type.equals(TimestampType.TIMESTAMP)) {
            this.setTimestamp(text, (Timestamp)value);
        } else if (type.equals(TinyintType.TINYINT)) {
            this.setByte(text, (Byte)value);
        } else if (type.equals(VarbinaryType.VARBINARY) && value instanceof byte[]) {
            this.setVarbinary(text, (byte[])value);
        } else if (type.equals(VarbinaryType.VARBINARY) && value instanceof Slice) {
            this.setVarbinary(text, ((Slice)value).getBytes());
        } else if (type.equals(VarcharType.VARCHAR) && value instanceof String) {
            this.setVarchar(text, (String)value);
        } else if (type.equals(VarcharType.VARCHAR) && value instanceof Slice) {
            this.setVarchar(text, ((Slice)value).toStringUtf8());
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("StringLexicoder does not support encoding type %s, object class is %s", type, value.getClass()));
        }
        return text.copyBytes();
    }

    @Override
    public <T> T decode(Type type, byte[] value) {
        String strValue = new String(value);
        if (Types.isArrayType(type)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "arrays are not (yet?) supported for StringRowSerializer");
        }
        if (Types.isMapType(type)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "maps are not (yet?) supported for StringRowSerializer");
        }
        if (type.equals(BigintType.BIGINT)) {
            return (T)Long.valueOf(Long.parseLong(strValue));
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return (T)Boolean.valueOf(Boolean.parseBoolean(strValue));
        }
        if (type.equals(DateType.DATE)) {
            return (T)Long.valueOf(Long.parseLong(strValue));
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return (T)Double.valueOf(Double.parseDouble(strValue));
        }
        if (type.equals(IntegerType.INTEGER)) {
            return (T)Long.valueOf(Integer.valueOf(Integer.parseInt(strValue)).longValue());
        }
        if (type.equals(RealType.REAL)) {
            return (T)Double.valueOf(Float.valueOf(Float.parseFloat(strValue)).doubleValue());
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return (T)Long.valueOf(Short.valueOf(Short.parseShort(strValue)).longValue());
        }
        if (type.equals(TimeType.TIME)) {
            return (T)Long.valueOf(Long.parseLong(strValue));
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return (T)Long.valueOf(Long.parseLong(strValue));
        }
        if (type.equals(TinyintType.TINYINT)) {
            return (T)Long.valueOf(Byte.valueOf(Byte.parseByte(strValue)).longValue());
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return (T)value;
        }
        if (type.equals(VarcharType.VARCHAR)) {
            return (T)new String(value);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "StringLexicoder does not support decoding type " + type);
    }
}

