/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo.io;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.accumulo.AccumuloErrorCode;
import com.facebook.presto.accumulo.conf.AccumuloSessionProperties;
import com.facebook.presto.accumulo.io.AccumuloRecordCursor;
import com.facebook.presto.accumulo.model.AccumuloColumnConstraint;
import com.facebook.presto.accumulo.model.AccumuloColumnHandle;
import com.facebook.presto.accumulo.model.AccumuloSplit;
import com.facebook.presto.accumulo.serializers.AccumuloRowSerializer;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.security.Authorizations;

public class AccumuloRecordSet
implements RecordSet {
    private static final Logger LOG = Logger.get(AccumuloRecordSet.class);
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private final List<AccumuloColumnHandle> columnHandles;
    private final List<AccumuloColumnConstraint> constraints;
    private final List<Type> columnTypes;
    private final AccumuloRowSerializer serializer;
    private final BatchScanner scanner;
    private final String rowIdName;

    public AccumuloRecordSet(Connector connector, ConnectorSession session, AccumuloSplit split, String username, List<AccumuloColumnHandle> columnHandles) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(split, "split is null");
        Objects.requireNonNull(username, "username is null");
        this.constraints = Objects.requireNonNull(split.getConstraints(), "constraints is null");
        this.rowIdName = split.getRowId();
        try {
            this.serializer = split.getSerializerClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Failed to factory serializer class.  Is it on the classpath?", (Throwable)e);
        }
        this.columnHandles = Objects.requireNonNull(columnHandles, "column handles is null");
        ImmutableList.Builder types = ImmutableList.builder();
        for (AccumuloColumnHandle column : columnHandles) {
            types.add((Object)column.getType());
        }
        this.columnTypes = types.build();
        try {
            this.scanner = connector.createBatchScanner(split.getFullTableName(), AccumuloRecordSet.getScanAuthorizations(session, split, connector, username), 10);
            this.scanner.setRanges(split.getRanges());
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, String.format("Failed to create batch scanner for table %s", split.getFullTableName()), (Throwable)e);
        }
    }

    private static Authorizations getScanAuthorizations(ConnectorSession session, AccumuloSplit split, Connector connector, String username) throws AccumuloException, AccumuloSecurityException {
        String sessionScanUser = AccumuloSessionProperties.getScanUsername(session);
        if (sessionScanUser != null) {
            Authorizations scanAuths = connector.securityOperations().getUserAuthorizations(sessionScanUser);
            LOG.debug("Using session scanner auths for user %s: %s", new Object[]{sessionScanUser, scanAuths});
            return scanAuths;
        }
        Optional<String> scanAuths = split.getScanAuthorizations();
        if (scanAuths.isPresent()) {
            Authorizations auths = new Authorizations((String[])Iterables.toArray((Iterable)COMMA_SPLITTER.split((CharSequence)scanAuths.get()), String.class));
            LOG.debug("scan_auths table property set: %s", new Object[]{auths});
            return auths;
        }
        Authorizations auths = connector.securityOperations().getUserAuthorizations(username);
        LOG.debug("scan_auths table property not set, using user auths: %s", new Object[]{auths});
        return auths;
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new AccumuloRecordCursor(this.serializer, this.scanner, this.rowIdName, this.columnHandles, this.constraints);
    }
}

