/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo;

import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.accumulo.AccumuloMetadata;
import com.facebook.presto.accumulo.AccumuloMetadataFactory;
import com.facebook.presto.accumulo.AccumuloSplitManager;
import com.facebook.presto.accumulo.AccumuloTransactionHandle;
import com.facebook.presto.accumulo.conf.AccumuloSessionProperties;
import com.facebook.presto.accumulo.conf.AccumuloTableProperties;
import com.facebook.presto.accumulo.io.AccumuloPageSinkProvider;
import com.facebook.presto.accumulo.io.AccumuloRecordSetProvider;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class AccumuloConnector
implements Connector {
    private static final Logger LOG = Logger.get(AccumuloConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final AccumuloMetadataFactory metadataFactory;
    private final AccumuloSplitManager splitManager;
    private final AccumuloRecordSetProvider recordSetProvider;
    private final AccumuloPageSinkProvider pageSinkProvider;
    private final AccumuloSessionProperties sessionProperties;
    private final AccumuloTableProperties tableProperties;
    private final ConcurrentMap<ConnectorTransactionHandle, AccumuloMetadata> transactions = new ConcurrentHashMap<ConnectorTransactionHandle, AccumuloMetadata>();

    @Inject
    public AccumuloConnector(LifeCycleManager lifeCycleManager, AccumuloMetadataFactory metadataFactory, AccumuloSplitManager splitManager, AccumuloRecordSetProvider recordSetProvider, AccumuloPageSinkProvider pageSinkProvider, AccumuloSessionProperties sessionProperties, AccumuloTableProperties tableProperties) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
        this.sessionProperties = Objects.requireNonNull(sessionProperties, "sessionProperties is null");
        this.tableProperties = Objects.requireNonNull(tableProperties, "tableProperties is null");
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        ConnectorMetadata metadata = (ConnectorMetadata)this.transactions.get(transactionHandle);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transactionHandle);
        return metadata;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (IsolationLevel)isolationLevel);
        AccumuloTransactionHandle transaction = new AccumuloTransactionHandle();
        this.transactions.put(transaction, this.metadataFactory.create());
        return transaction;
    }

    public void commit(ConnectorTransactionHandle transactionHandle) {
        Preconditions.checkArgument((this.transactions.remove(transactionHandle) != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transactionHandle);
    }

    public void rollback(ConnectorTransactionHandle transactionHandle) {
        AccumuloMetadata metadata = (AccumuloMetadata)this.transactions.remove(transactionHandle);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transactionHandle);
        metadata.rollback();
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.recordSetProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties.getTableProperties();
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties.getSessionProperties();
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error shutting down connector");
        }
    }
}

