/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo.model;

import com.facebook.presto.accumulo.model.AccumuloColumnConstraint;
import com.facebook.presto.accumulo.model.WrappedRange;
import com.facebook.presto.accumulo.serializers.AccumuloRowSerializer;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.accumulo.core.data.Range;

public class AccumuloSplit
implements ConnectorSplit {
    private final String connectorId;
    private final String rowId;
    private final String schema;
    private final String table;
    private final String serializerClassName;
    private final Optional<String> scanAuthorizations;
    private final Optional<String> hostPort;
    private final List<HostAddress> addresses;
    private final List<AccumuloColumnConstraint> constraints;
    private final List<WrappedRange> ranges;

    @JsonCreator
    public AccumuloSplit(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="schema") String schema, @JsonProperty(value="table") String table, @JsonProperty(value="rowId") String rowId, @JsonProperty(value="serializerClassName") String serializerClassName, @JsonProperty(value="ranges") List<WrappedRange> ranges, @JsonProperty(value="constraints") List<AccumuloColumnConstraint> constraints, @JsonProperty(value="scanAuthorizations") Optional<String> scanAuthorizations, @JsonProperty(value="hostPort") Optional<String> hostPort) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.rowId = Objects.requireNonNull(rowId, "rowId is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.serializerClassName = Objects.requireNonNull(serializerClassName, "serializerClassName is null");
        this.constraints = ImmutableList.copyOf((Collection)Objects.requireNonNull(constraints, "constraints is null"));
        this.scanAuthorizations = Objects.requireNonNull(scanAuthorizations, "scanAuthorizations is null");
        this.hostPort = Objects.requireNonNull(hostPort, "hostPort is null");
        this.ranges = ImmutableList.copyOf((Collection)Objects.requireNonNull(ranges, "ranges is null"));
        this.addresses = hostPort.isPresent() ? ImmutableList.of((Object)HostAddress.fromString((String)hostPort.get())) : ImmutableList.of();
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public Optional<String> getHostPort() {
        return this.hostPort;
    }

    @JsonProperty
    public String getRowId() {
        return this.rowId;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonIgnore
    public String getFullTableName() {
        return (this.getSchema().equals("default") ? "" : this.getSchema() + ".") + this.getTable();
    }

    @JsonProperty
    public String getSerializerClassName() {
        return this.serializerClassName;
    }

    @JsonProperty(value="ranges")
    public List<WrappedRange> getWrappedRanges() {
        return this.ranges;
    }

    @JsonIgnore
    public List<Range> getRanges() {
        return this.ranges.stream().map(WrappedRange::getRange).collect(Collectors.toList());
    }

    @JsonProperty
    public List<AccumuloColumnConstraint> getConstraints() {
        return this.constraints;
    }

    @JsonIgnore
    public Class<? extends AccumuloRowSerializer> getSerializerClass() {
        try {
            return Class.forName(this.serializerClassName);
        }
        catch (ClassNotFoundException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Configured serializer class not found", (Throwable)e);
        }
    }

    @JsonProperty
    public Optional<String> getScanAuthorizations() {
        return this.scanAuthorizations;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("schema", (Object)this.schema).add("table", (Object)this.table).add("rowId", (Object)this.rowId).add("serializerClassName", (Object)this.serializerClassName).add("addresses", this.addresses).add("numRanges", this.ranges.size()).add("constraints", this.constraints).add("scanAuthorizations", this.scanAuthorizations).add("hostPort", this.hostPort).toString();
    }
}

