/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo;

import com.facebook.presto.accumulo.AccumuloConnector;
import com.facebook.presto.accumulo.AccumuloHandleResolver;
import com.facebook.presto.accumulo.AccumuloModule;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import java.util.Map;
import java.util.Objects;

public class AccumuloConnectorFactory
implements ConnectorFactory {
    public static final String CONNECTOR_NAME = "accumulo";

    public String getName() {
        return CONNECTOR_NAME;
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(config, "requiredConfig is null");
        Objects.requireNonNull(context, "context is null");
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new AccumuloModule(catalogName, context.getTypeManager())});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (Connector)injector.getInstance(AccumuloConnector.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new AccumuloHandleResolver();
    }
}

