/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo.metadata;

import com.facebook.presto.accumulo.AccumuloErrorCode;
import com.facebook.presto.accumulo.AccumuloModule;
import com.facebook.presto.accumulo.conf.AccumuloConfig;
import com.facebook.presto.accumulo.metadata.AccumuloTable;
import com.facebook.presto.accumulo.metadata.AccumuloView;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.ObjectMapperProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryForever;
import org.apache.zookeeper.KeeperException;

public class ZooKeeperMetadataManager {
    private static final String DEFAULT_SCHEMA = "default";
    private final CuratorFramework curator;
    private final ObjectMapper mapper;

    @Inject
    public ZooKeeperMetadataManager(AccumuloConfig config, TypeManager typeManager) {
        Objects.requireNonNull(typeManager, "typeManager is null");
        ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
        objectMapperProvider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)((Object)new AccumuloModule.TypeDeserializer(typeManager))));
        this.mapper = objectMapperProvider.get();
        String zkMetadataRoot = config.getZkMetadataRoot();
        String zookeepers = config.getZooKeepers();
        CuratorFramework checkRoot = CuratorFrameworkFactory.newClient((String)zookeepers, (RetryPolicy)new RetryForever(1000));
        checkRoot.start();
        try {
            if (checkRoot.checkExists().forPath(zkMetadataRoot) == null) {
                checkRoot.create().forPath(zkMetadataRoot);
            }
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ZOOKEEPER_ERROR, "ZK error checking metadata root", (Throwable)e);
        }
        checkRoot.close();
        this.curator = CuratorFrameworkFactory.newClient((String)(zookeepers + zkMetadataRoot), (RetryPolicy)new RetryForever(1000));
        this.curator.start();
        try {
            if (this.curator.checkExists().forPath("/default") == null) {
                this.curator.create().forPath("/default");
            }
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ZOOKEEPER_ERROR, "ZK error checking/creating default schema", (Throwable)e);
        }
    }

    public Set<String> getSchemaNames() {
        try {
            HashSet<String> schemas = new HashSet<String>();
            schemas.addAll((Collection)this.curator.getChildren().forPath("/"));
            return schemas;
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ZOOKEEPER_ERROR, "Error fetching schemas", (Throwable)e);
        }
    }

    public Set<String> getTableNames(String schema) {
        String schemaPath = ZooKeeperMetadataManager.getSchemaPath(schema);
        try {
            if (this.curator.checkExists().forPath(schemaPath) == null) {
                return ImmutableSet.of();
            }
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ZOOKEEPER_ERROR, "Error checking if schema exists", (Throwable)e);
        }
        try {
            return (Set)((List)this.curator.getChildren().forPath(schemaPath)).stream().filter(x -> this.isAccumuloTable(new SchemaTableName(schema, x))).collect(ImmutableSet.toImmutableSet());
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ZOOKEEPER_ERROR, "Error fetching schemas", (Throwable)e);
        }
    }

    public AccumuloTable getTable(SchemaTableName stName) {
        try {
            if (this.curator.checkExists().forPath(ZooKeeperMetadataManager.getTablePath(stName)) != null) {
                return this.toAccumuloTable((byte[])this.curator.getData().forPath(ZooKeeperMetadataManager.getTablePath(stName)));
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof KeeperException && ((KeeperException)e).code() == KeeperException.Code.NONODE) {
                return null;
            }
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ZOOKEEPER_ERROR, "Error fetching table", (Throwable)e);
        }
    }

    public Set<String> getViewNames(String schema) {
        String schemaPath = ZooKeeperMetadataManager.getSchemaPath(schema);
        try {
            if (this.curator.checkExists().forPath(schemaPath) == null) {
                return ImmutableSet.of();
            }
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ZOOKEEPER_ERROR, "Error checking if schema exists", (Throwable)e);
        }
        try {
            return (Set)((List)this.curator.getChildren().forPath(schemaPath)).stream().filter(x -> this.isAccumuloView(new SchemaTableName(schema, x))).collect(ImmutableSet.toImmutableSet());
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ZOOKEEPER_ERROR, "Error fetching schemas", (Throwable)e);
        }
    }

    public AccumuloView getView(SchemaTableName stName) {
        try {
            String tablePath = ZooKeeperMetadataManager.getTablePath(stName);
            if (this.curator.checkExists().forPath(tablePath) != null) {
                return this.toAccumuloView((byte[])this.curator.getData().forPath(tablePath));
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof KeeperException && ((KeeperException)e).code() == KeeperException.Code.NONODE) {
                return null;
            }
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ZOOKEEPER_ERROR, "Error fetching view", (Throwable)e);
        }
    }

    public void createTableMetadata(AccumuloTable table) {
        SchemaTableName tableName = table.getSchemaTableName();
        String tablePath = ZooKeeperMetadataManager.getTablePath(tableName);
        try {
            if (this.curator.checkExists().forPath(tablePath) != null) {
                throw new IOException(String.format("Metadata for table %s already exists", tableName));
            }
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ZOOKEEPER_ERROR, "ZK error when checking if table already exists", (Throwable)e);
        }
        try {
            this.curator.create().creatingParentsIfNeeded().forPath(tablePath, this.toJsonBytes(table));
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ZOOKEEPER_ERROR, "Error creating table znode in ZooKeeper", (Throwable)e);
        }
    }

    public void deleteTableMetadata(SchemaTableName tableName) {
        try {
            this.curator.delete().deletingChildrenIfNeeded().forPath(ZooKeeperMetadataManager.getTablePath(tableName));
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ZOOKEEPER_ERROR, "ZK error when deleting table metadata", (Throwable)e);
        }
    }

    public void createViewMetadata(AccumuloView view) {
        SchemaTableName tableName = view.getSchemaTableName();
        String viewPath = ZooKeeperMetadataManager.getTablePath(tableName);
        try {
            if (this.curator.checkExists().forPath(viewPath) != null) {
                throw new IOException(String.format("Metadata for view %s already exists", tableName));
            }
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ZOOKEEPER_ERROR, "ZK error when checking if view already exists", (Throwable)e);
        }
        try {
            this.curator.create().creatingParentsIfNeeded().forPath(viewPath, this.toJsonBytes(view));
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ZOOKEEPER_ERROR, "Error creating view znode in ZooKeeper", (Throwable)e);
        }
    }

    public void deleteViewMetadata(SchemaTableName tableName) {
        try {
            this.curator.delete().deletingChildrenIfNeeded().forPath(ZooKeeperMetadataManager.getTablePath(tableName));
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ZOOKEEPER_ERROR, "ZK error when deleting view metadata", (Throwable)e);
        }
    }

    private static String getSchemaPath(String schema) {
        return "/" + schema.toLowerCase(Locale.ENGLISH);
    }

    private static String getSchemaPath(SchemaTableName tableName) {
        return ZooKeeperMetadataManager.getSchemaPath(tableName.getSchemaName());
    }

    private static String getTablePath(SchemaTableName tableName) {
        return ZooKeeperMetadataManager.getSchemaPath(tableName) + '/' + tableName.getTableName().toLowerCase(Locale.ENGLISH);
    }

    private boolean isAccumuloTable(SchemaTableName tableName) {
        try {
            String path = ZooKeeperMetadataManager.getTablePath(tableName);
            return this.curator.checkExists().forPath(path) != null && this.isAccumuloTable((byte[])this.curator.getData().forPath(path));
        }
        catch (Exception e) {
            if (e instanceof KeeperException && ((KeeperException)e).code() == KeeperException.Code.NONODE) {
                return false;
            }
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ZOOKEEPER_ERROR, "Error checking if path %s is an AccumuloTable object", (Throwable)e);
        }
    }

    private boolean isAccumuloView(SchemaTableName tableName) {
        try {
            String path = ZooKeeperMetadataManager.getTablePath(tableName);
            return this.curator.checkExists().forPath(path) != null && this.isAccumuloView((byte[])this.curator.getData().forPath(path));
        }
        catch (Exception e) {
            if (e instanceof KeeperException && ((KeeperException)e).code() == KeeperException.Code.NONODE) {
                return false;
            }
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ZOOKEEPER_ERROR, "Error checking if path is an AccumuloView object", (Throwable)e);
        }
    }

    private boolean isAccumuloTable(byte[] data) throws IOException {
        return !this.mapper.reader().readTree(new String(data)).has("data");
    }

    private boolean isAccumuloView(byte[] data) throws IOException {
        return this.mapper.reader().readTree(new String(data)).has("data");
    }

    private AccumuloTable toAccumuloTable(byte[] data) throws IOException {
        return (AccumuloTable)this.mapper.readValue(new String(data), AccumuloTable.class);
    }

    private AccumuloView toAccumuloView(byte[] data) throws IOException {
        return (AccumuloView)this.mapper.readValue(new String(data), AccumuloView.class);
    }

    private byte[] toJsonBytes(Object obj) throws IOException {
        return this.mapper.writeValueAsBytes(obj);
    }
}

