/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo;

import com.facebook.presto.accumulo.AccumuloClient;
import com.facebook.presto.accumulo.AccumuloConnectorId;
import com.facebook.presto.accumulo.AccumuloErrorCode;
import com.facebook.presto.accumulo.metadata.AccumuloTable;
import com.facebook.presto.accumulo.metadata.AccumuloView;
import com.facebook.presto.accumulo.model.AccumuloColumnHandle;
import com.facebook.presto.accumulo.model.AccumuloTableHandle;
import com.facebook.presto.accumulo.model.AccumuloTableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ConnectorViewDefinition;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;

public class AccumuloMetadata
implements ConnectorMetadata {
    private final String connectorId;
    private final AccumuloClient client;
    private final AtomicReference<Runnable> rollbackAction = new AtomicReference();

    @Inject
    public AccumuloMetadata(AccumuloConnectorId connectorId, AccumuloClient client) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.client = Objects.requireNonNull(client, "client is null");
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        this.checkNoRollback();
        SchemaTableName tableName = tableMetadata.getTable();
        AccumuloTable table = this.client.createTable(tableMetadata);
        AccumuloTableHandle handle = new AccumuloTableHandle(this.connectorId, tableName.getSchemaName(), tableName.getTableName(), table.getRowId(), table.isExternal(), table.getSerializerClassName(), table.getScanAuthorizations());
        this.setRollback(() -> this.rollbackCreateTable(table));
        return handle;
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments) {
        this.clearRollback();
        return Optional.empty();
    }

    private void rollbackCreateTable(AccumuloTable table) {
        this.client.dropTable(table);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        this.client.createTable(tableMetadata);
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        AccumuloTableHandle handle = (AccumuloTableHandle)tableHandle;
        AccumuloTable table = this.client.getTable(handle.toSchemaTableName());
        if (table != null) {
            this.client.dropTable(table);
        }
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        if (this.client.getTable(newTableName) != null) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ACCUMULO_TABLE_EXISTS, "Table " + newTableName + " already exists");
        }
        AccumuloTableHandle handle = (AccumuloTableHandle)tableHandle;
        this.client.renameTable(handle.toSchemaTableName(), newTableName);
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, String viewData, boolean replace) {
        if (replace) {
            this.client.createOrReplaceView(viewName, viewData);
        } else {
            this.client.createView(viewName, viewData);
        }
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        this.client.dropView(viewName);
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SchemaTableName stName : this.listViews(session, prefix.getSchemaName())) {
            AccumuloView view = this.client.getView(stName);
            if (view == null) continue;
            builder.put((Object)stName, (Object)new ConnectorViewDefinition(stName, Optional.empty(), view.getData()));
        }
        return builder.build();
    }

    public List<SchemaTableName> listViews(ConnectorSession session, String schemaNameOrNull) {
        return this.listViews(schemaNameOrNull);
    }

    private List<SchemaTableName> listViews(String schemaNameOrNull) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (schemaNameOrNull == null) {
            for (String schema : this.client.getSchemaNames()) {
                for (String view : this.client.getViewNames(schema)) {
                    builder.add((Object)new SchemaTableName(schema, view));
                }
            }
        } else {
            for (String view : this.client.getViewNames(schemaNameOrNull)) {
                builder.add((Object)new SchemaTableName(schemaNameOrNull, view));
            }
        }
        return builder.build();
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        this.checkNoRollback();
        AccumuloTableHandle handle = (AccumuloTableHandle)tableHandle;
        this.setRollback(() -> AccumuloMetadata.rollbackInsert(handle));
        return handle;
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments) {
        this.clearRollback();
        return Optional.empty();
    }

    private static void rollbackInsert(ConnectorInsertTableHandle insertHandle) {
        AccumuloTableHandle handle = (AccumuloTableHandle)insertHandle;
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unable to rollback insert for table %s.%s. Some rows may have been written. Please run your insert again.", handle.getSchema(), handle.getTable()));
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        if (!this.listSchemaNames(session).contains(tableName.getSchemaName().toLowerCase(Locale.ENGLISH))) {
            return null;
        }
        if (!this.listViews(session, tableName.getSchemaName()).contains(tableName)) {
            AccumuloTable table = this.client.getTable(tableName);
            if (table == null) {
                return null;
            }
            return new AccumuloTableHandle(this.connectorId, table.getSchema(), table.getTable(), table.getRowId(), table.isExternal(), table.getSerializerClassName(), table.getScanAuthorizations());
        }
        return null;
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        AccumuloTableHandle tableHandle = (AccumuloTableHandle)table;
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new AccumuloTableLayoutHandle(tableHandle, (TupleDomain<ColumnHandle>)constraint.getSummary()));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout((ConnectorTableLayoutHandle)((AccumuloTableLayoutHandle)handle));
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        AccumuloTableHandle handle = (AccumuloTableHandle)table;
        Preconditions.checkArgument((boolean)handle.getConnectorId().equals(this.connectorId), (Object)"table is not for this connector");
        SchemaTableName tableName = new SchemaTableName(handle.getSchema(), handle.getTable());
        ConnectorTableMetadata metadata = this.getTableMetadata(tableName);
        if (metadata == null) {
            throw new TableNotFoundException(tableName);
        }
        return metadata;
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        AccumuloTableHandle handle = (AccumuloTableHandle)tableHandle;
        Preconditions.checkArgument((boolean)handle.getConnectorId().equals(this.connectorId), (Object)"tableHandle is not for this connector");
        AccumuloTable table = this.client.getTable(handle.toSchemaTableName());
        if (table == null) {
            throw new TableNotFoundException(handle.toSchemaTableName());
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (AccumuloColumnHandle column : table.getColumns()) {
            columnHandles.put((Object)column.getName(), (Object)column);
        }
        return columnHandles.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((AccumuloColumnHandle)columnHandle).getColumnMetadata();
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        AccumuloTableHandle handle = (AccumuloTableHandle)tableHandle;
        AccumuloColumnHandle columnHandle = (AccumuloColumnHandle)source;
        AccumuloTable table = this.client.getTable(handle.toSchemaTableName());
        if (table == null) {
            throw new TableNotFoundException(new SchemaTableName(handle.getSchema(), handle.getTable()));
        }
        this.client.renameColumn(table, columnHandle.getName(), target);
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.copyOf(this.client.getSchemaNames());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        Object schemaNames = schemaNameOrNull != null ? ImmutableSet.of((Object)schemaNameOrNull) : this.client.getSchemaNames();
        ImmutableList.Builder builder = ImmutableList.builder();
        Iterator iterator = schemaNames.iterator();
        while (iterator.hasNext()) {
            String schemaName = (String)iterator.next();
            for (String tableName : this.client.getTableNames(schemaName)) {
                builder.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return builder.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableName);
            if (tableMetadata == null) continue;
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.build();
    }

    private void checkNoRollback() {
        Preconditions.checkState((this.rollbackAction.get() == null ? 1 : 0) != 0, (Object)"Cannot begin a new write while in an existing one");
    }

    private void setRollback(Runnable action) {
        Preconditions.checkState((boolean)this.rollbackAction.compareAndSet(null, action), (Object)"Should not have to override existing rollback action");
    }

    private void clearRollback() {
        this.rollbackAction.set(null);
    }

    public void rollback() {
        Runnable rollbackAction = this.rollbackAction.getAndSet(null);
        if (rollbackAction != null) {
            rollbackAction.run();
        }
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        if (!this.client.getSchemaNames().contains(tableName.getSchemaName())) {
            return null;
        }
        if (!this.listViews(tableName.getSchemaName()).contains(tableName)) {
            AccumuloTable table = this.client.getTable(tableName);
            if (table == null) {
                return null;
            }
            return new ConnectorTableMetadata(tableName, table.getColumnsMetadata());
        }
        return null;
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getSchemaName() == null || prefix.getTableName() == null) {
            return this.listTables(session, prefix.getSchemaName());
        }
        SchemaTableName table = new SchemaTableName(prefix.getSchemaName(), prefix.getTableName());
        if (this.getTableHandle(session, table) != null) {
            return ImmutableList.of((Object)table);
        }
        return ImmutableList.of();
    }
}

