/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo;

import com.facebook.presto.accumulo.AccumuloClient;
import com.facebook.presto.accumulo.AccumuloConnectorId;
import com.facebook.presto.accumulo.model.AccumuloColumnConstraint;
import com.facebook.presto.accumulo.model.AccumuloColumnHandle;
import com.facebook.presto.accumulo.model.AccumuloSplit;
import com.facebook.presto.accumulo.model.AccumuloTableHandle;
import com.facebook.presto.accumulo.model.AccumuloTableLayoutHandle;
import com.facebook.presto.accumulo.model.TabletSplitMetadata;
import com.facebook.presto.accumulo.model.WrappedRange;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class AccumuloSplitManager
implements ConnectorSplitManager {
    private final String connectorId;
    private final AccumuloClient client;

    @Inject
    public AccumuloSplitManager(AccumuloConnectorId connectorId, AccumuloClient client) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.client = Objects.requireNonNull(client, "client is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableLayoutHandle layout) {
        AccumuloTableLayoutHandle layoutHandle = (AccumuloTableLayoutHandle)layout;
        AccumuloTableHandle tableHandle = layoutHandle.getTable();
        String schemaName = tableHandle.getSchema();
        String tableName = tableHandle.getTable();
        String rowIdName = tableHandle.getRowId();
        List<AccumuloColumnConstraint> constraints = AccumuloSplitManager.getColumnConstraints(rowIdName, layoutHandle.getConstraint());
        Optional<Domain> rDom = AccumuloSplitManager.getRangeDomain(rowIdName, layoutHandle.getConstraint());
        List<TabletSplitMetadata> tabletSplits = this.client.getTabletSplits(session, schemaName, tableName, rDom, constraints, tableHandle.getSerializerInstance());
        ImmutableList.Builder cSplits = ImmutableList.builder();
        for (TabletSplitMetadata splitMetadata : tabletSplits) {
            AccumuloSplit split = new AccumuloSplit(this.connectorId, schemaName, tableName, rowIdName, tableHandle.getSerializerClassName(), splitMetadata.getRanges().stream().map(WrappedRange::new).collect(Collectors.toList()), constraints, tableHandle.getScanAuthorizations(), splitMetadata.getHostPort());
            cSplits.add((Object)split);
        }
        return new FixedSplitSource((Iterable)cSplits.build());
    }

    private static Optional<Domain> getRangeDomain(String rowIdName, TupleDomain<ColumnHandle> constraint) {
        if (constraint.getColumnDomains().isPresent()) {
            for (TupleDomain.ColumnDomain cd : (List)constraint.getColumnDomains().get()) {
                AccumuloColumnHandle col = (AccumuloColumnHandle)cd.getColumn();
                if (!col.getName().equals(rowIdName)) continue;
                return Optional.of(cd.getDomain());
            }
        }
        return Optional.empty();
    }

    private static List<AccumuloColumnConstraint> getColumnConstraints(String rowIdName, TupleDomain<ColumnHandle> constraint) {
        ImmutableList.Builder constraintBuilder = ImmutableList.builder();
        for (TupleDomain.ColumnDomain columnDomain : (List)constraint.getColumnDomains().get()) {
            AccumuloColumnHandle columnHandle = (AccumuloColumnHandle)columnDomain.getColumn();
            if (columnHandle.getName().equals(rowIdName)) continue;
            constraintBuilder.add((Object)new AccumuloColumnConstraint(columnHandle.getName(), columnHandle.getFamily().get(), columnHandle.getQualifier().get(), Optional.of(columnDomain.getDomain()), columnHandle.isIndexed()));
        }
        return constraintBuilder.build();
    }
}

