/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo.serializers;

import com.facebook.presto.accumulo.Types;
import com.facebook.presto.accumulo.serializers.LexicoderRowSerializer;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.InterleavedBlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;

public interface AccumuloRowSerializer {
    public static AccumuloRowSerializer getDefault() {
        return new LexicoderRowSerializer();
    }

    public void setRowIdName(String var1);

    public void setMapping(String var1, String var2, String var3);

    public void setRowOnly(boolean var1);

    public void reset();

    public void deserialize(Map.Entry<Key, Value> var1) throws IOException;

    public boolean isNull(String var1);

    public Block getArray(String var1, Type var2);

    public void setArray(Text var1, Type var2, Block var3);

    public boolean getBoolean(String var1);

    public void setBoolean(Text var1, Boolean var2);

    public byte getByte(String var1);

    public void setByte(Text var1, Byte var2);

    public Date getDate(String var1);

    public void setDate(Text var1, Date var2);

    public double getDouble(String var1);

    public void setDouble(Text var1, Double var2);

    public float getFloat(String var1);

    public void setFloat(Text var1, Float var2);

    public int getInt(String var1);

    public void setInt(Text var1, Integer var2);

    public long getLong(String var1);

    public void setLong(Text var1, Long var2);

    public Block getMap(String var1, Type var2);

    public void setMap(Text var1, Type var2, Block var3);

    public short getShort(String var1);

    public void setShort(Text var1, Short var2);

    public Time getTime(String var1);

    public void setTime(Text var1, Time var2);

    public Timestamp getTimestamp(String var1);

    public void setTimestamp(Text var1, Timestamp var2);

    public byte[] getVarbinary(String var1);

    public void setVarbinary(Text var1, byte[] var2);

    public String getVarchar(String var1);

    public void setVarchar(Text var1, String var2);

    public byte[] encode(Type var1, Object var2);

    public <T> T decode(Type var1, byte[] var2);

    public static List<Object> getArrayFromBlock(Type elementType, Block block) {
        ImmutableList.Builder arrayBuilder = ImmutableList.builder();
        for (int i = 0; i < block.getPositionCount(); ++i) {
            arrayBuilder.add(AccumuloRowSerializer.readObject(elementType, block, i));
        }
        return arrayBuilder.build();
    }

    public static Map<Object, Object> getMapFromBlock(Type type, Block block) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(block.getPositionCount() / 2);
        Type keyType = Types.getKeyType(type);
        Type valueType = Types.getValueType(type);
        for (int i = 0; i < block.getPositionCount(); i += 2) {
            map.put(AccumuloRowSerializer.readObject(keyType, block, i), AccumuloRowSerializer.readObject(valueType, block, i + 1));
        }
        return map;
    }

    public static Block getBlockFromArray(Type elementType, List<?> array) {
        BlockBuilder builder = elementType.createBlockBuilder(new BlockBuilderStatus(), array.size());
        for (Object item : array) {
            AccumuloRowSerializer.writeObject(builder, elementType, item);
        }
        return builder.build();
    }

    public static Block getBlockFromMap(Type mapType, Map<?, ?> map) {
        Type keyType = (Type)mapType.getTypeParameters().get(0);
        Type valueType = (Type)mapType.getTypeParameters().get(1);
        InterleavedBlockBuilder builder = new InterleavedBlockBuilder((List)ImmutableList.of((Object)keyType, (Object)valueType), new BlockBuilderStatus(), map.size() * 2);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            AccumuloRowSerializer.writeObject((BlockBuilder)builder, keyType, entry.getKey());
            AccumuloRowSerializer.writeObject((BlockBuilder)builder, valueType, entry.getValue());
        }
        return builder.build();
    }

    public static void writeObject(BlockBuilder builder, Type type, Object obj) {
        if (Types.isArrayType(type)) {
            BlockBuilder arrayBldr = builder.beginBlockEntry();
            Type elementType = Types.getElementType(type);
            for (Object item : (List)obj) {
                AccumuloRowSerializer.writeObject(arrayBldr, elementType, item);
            }
            builder.closeEntry();
        } else if (Types.isMapType(type)) {
            BlockBuilder mapBlockBuilder = builder.beginBlockEntry();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                AccumuloRowSerializer.writeObject(mapBlockBuilder, Types.getKeyType(type), entry.getKey());
                AccumuloRowSerializer.writeObject(mapBlockBuilder, Types.getValueType(type), entry.getValue());
            }
            builder.closeEntry();
        } else {
            TypeUtils.writeNativeValue((Type)type, (BlockBuilder)builder, (Object)obj);
        }
    }

    public static Object readObject(Type type, Block block, int position) {
        if (Types.isArrayType(type)) {
            Type elementType = Types.getElementType(type);
            return AccumuloRowSerializer.getArrayFromBlock(elementType, (Block)block.getObject(position, Block.class));
        }
        if (Types.isMapType(type)) {
            return AccumuloRowSerializer.getMapFromBlock(type, (Block)block.getObject(position, Block.class));
        }
        if (type.getJavaType() == Slice.class) {
            Slice slice = (Slice)TypeUtils.readNativeValue((Type)type, (Block)block, (int)position);
            return type.equals(VarcharType.VARCHAR) ? slice.toStringUtf8() : (Object)slice.getBytes();
        }
        return TypeUtils.readNativeValue((Type)type, (Block)block, (int)position);
    }
}

