/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo.io;

import com.facebook.presto.accumulo.AccumuloErrorCode;
import com.facebook.presto.accumulo.Types;
import com.facebook.presto.accumulo.io.AccumuloPageSink;
import com.facebook.presto.accumulo.model.AccumuloColumnConstraint;
import com.facebook.presto.accumulo.model.AccumuloColumnHandle;
import com.facebook.presto.accumulo.serializers.AccumuloRowSerializer;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.FirstEntryInRowIterator;
import org.apache.accumulo.core.iterators.user.WholeRowIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.Text;

public class AccumuloRecordCursor
implements RecordCursor {
    private static final int WHOLE_ROW_ITERATOR_PRIORITY = Integer.MAX_VALUE;
    private final List<AccumuloColumnHandle> columnHandles;
    private final String[] fieldToColumnName;
    private final BatchScanner scanner;
    private final Iterator<Map.Entry<Key, Value>> iterator;
    private final AccumuloRowSerializer serializer;
    private long bytesRead;
    private long nanoStart;
    private long nanoEnd;

    public AccumuloRecordCursor(AccumuloRowSerializer serializer, BatchScanner scanner, String rowIdName, List<AccumuloColumnHandle> columnHandles, List<AccumuloColumnConstraint> constraints) {
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        this.scanner = Objects.requireNonNull(scanner, "scanner is null");
        this.serializer = Objects.requireNonNull(serializer, "serializer is null");
        this.serializer.setRowIdName(Objects.requireNonNull(rowIdName, "rowIdName is null"));
        Objects.requireNonNull(columnHandles, "columnHandles is null");
        Objects.requireNonNull(constraints, "constraints is null");
        if (this.retrieveOnlyRowIds(rowIdName)) {
            this.scanner.addScanIterator(new IteratorSetting(1, "firstentryiter", FirstEntryInRowIterator.class));
            this.fieldToColumnName = new String[1];
            this.fieldToColumnName[0] = rowIdName;
            this.serializer.setRowOnly(true);
        } else {
            this.serializer.setRowOnly(false);
            this.scanner.fetchColumn(AccumuloPageSink.ROW_ID_COLUMN, AccumuloPageSink.ROW_ID_COLUMN);
            Text family = new Text();
            Text qualifier = new Text();
            this.fieldToColumnName = new String[columnHandles.size()];
            for (int i = 0; i < columnHandles.size(); ++i) {
                AccumuloColumnHandle columnHandle = columnHandles.get(i);
                this.fieldToColumnName[i] = columnHandle.getName();
                if (columnHandle.getName().equals(rowIdName)) continue;
                this.serializer.setMapping(columnHandle.getName(), columnHandle.getFamily().get(), columnHandle.getQualifier().get());
                family.set(columnHandle.getFamily().get());
                qualifier.set(columnHandle.getQualifier().get());
                this.scanner.fetchColumn(family, qualifier);
            }
        }
        IteratorSetting setting = new IteratorSetting(Integer.MAX_VALUE, WholeRowIterator.class);
        scanner.addScanIterator(setting);
        this.iterator = this.scanner.iterator();
    }

    public long getTotalBytes() {
        return 0L;
    }

    public long getCompletedBytes() {
        return this.bytesRead;
    }

    public long getReadTimeNanos() {
        return this.nanoStart > 0L ? (this.nanoEnd == 0L ? System.nanoTime() : this.nanoEnd) - this.nanoStart : 0L;
    }

    public Type getType(int field) {
        Preconditions.checkArgument((field >= 0 && field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.columnHandles.get(field).getType();
    }

    public boolean advanceNextPosition() {
        if (this.nanoStart == 0L) {
            this.nanoStart = System.nanoTime();
        }
        try {
            if (this.iterator.hasNext()) {
                this.serializer.reset();
                Map.Entry<Key, Value> row = this.iterator.next();
                for (Map.Entry<Key, Value> entry : WholeRowIterator.decodeRow((Key)row.getKey(), (Value)row.getValue()).entrySet()) {
                    this.bytesRead += (long)(((Key)entry.getKey()).getSize() + ((Value)entry.getValue()).getSize());
                    this.serializer.deserialize(entry);
                }
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.IO_ERROR, "Caught IO error from serializer on read", (Throwable)e);
        }
    }

    public boolean isNull(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.serializer.isNull(this.fieldToColumnName[field]);
    }

    public boolean getBoolean(int field) {
        this.checkFieldType(field, new Type[]{BooleanType.BOOLEAN});
        return this.serializer.getBoolean(this.fieldToColumnName[field]);
    }

    public double getDouble(int field) {
        this.checkFieldType(field, new Type[]{DoubleType.DOUBLE});
        return this.serializer.getDouble(this.fieldToColumnName[field]);
    }

    public long getLong(int field) {
        this.checkFieldType(field, new Type[]{BigintType.BIGINT, DateType.DATE, IntegerType.INTEGER, RealType.REAL, SmallintType.SMALLINT, TimeType.TIME, TimestampType.TIMESTAMP, TinyintType.TINYINT});
        Type type = this.getType(field);
        if (type.equals(BigintType.BIGINT)) {
            return this.serializer.getLong(this.fieldToColumnName[field]);
        }
        if (type.equals(DateType.DATE)) {
            return TimeUnit.MILLISECONDS.toDays(this.serializer.getDate(this.fieldToColumnName[field]).getTime());
        }
        if (type.equals(IntegerType.INTEGER)) {
            return this.serializer.getInt(this.fieldToColumnName[field]);
        }
        if (type.equals(RealType.REAL)) {
            return Float.floatToIntBits(this.serializer.getFloat(this.fieldToColumnName[field]));
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return this.serializer.getShort(this.fieldToColumnName[field]);
        }
        if (type.equals(TimeType.TIME)) {
            return this.serializer.getTime(this.fieldToColumnName[field]).getTime();
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return this.serializer.getTimestamp(this.fieldToColumnName[field]).getTime();
        }
        if (type.equals(TinyintType.TINYINT)) {
            return this.serializer.getByte(this.fieldToColumnName[field]);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type " + this.getType(field));
    }

    public Object getObject(int field) {
        Type type = this.getType(field);
        Preconditions.checkArgument((Types.isArrayType(type) || Types.isMapType(type) ? 1 : 0) != 0, (String)"Expected field %s to be a type of array or map but is %s", (int)field, (Object)type);
        if (Types.isArrayType(type)) {
            return this.serializer.getArray(this.fieldToColumnName[field], type);
        }
        return this.serializer.getMap(this.fieldToColumnName[field], type);
    }

    public Slice getSlice(int field) {
        Type type = this.getType(field);
        if (type instanceof VarbinaryType) {
            return Slices.wrappedBuffer((byte[])this.serializer.getVarbinary(this.fieldToColumnName[field]));
        }
        if (type instanceof VarcharType) {
            return Slices.utf8Slice((String)this.serializer.getVarchar(this.fieldToColumnName[field]));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type " + type);
    }

    public void close() {
        this.scanner.close();
        this.nanoEnd = System.nanoTime();
    }

    private boolean retrieveOnlyRowIds(String rowIdName) {
        return this.columnHandles.isEmpty() || this.columnHandles.size() == 1 && this.columnHandles.get(0).getName().equals(rowIdName);
    }

    private void checkFieldType(int field, Type ... expected) {
        Type actual = this.getType(field);
        for (Type type : expected) {
            if (!actual.equals(type)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Expected field %s to be a type of %s but is %s", field, StringUtils.join((Object[])expected, (String)","), actual));
    }
}

