/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo.index;

import com.facebook.presto.accumulo.conf.AccumuloConfig;
import com.facebook.presto.accumulo.index.Indexer;
import com.facebook.presto.accumulo.metadata.AccumuloTable;
import com.facebook.presto.accumulo.model.AccumuloColumnConstraint;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.io.Text;

public class ColumnCardinalityCache {
    private final Authorizations auths;
    private static final Logger LOG = Logger.get(ColumnCardinalityCache.class);
    private final Connector connector;
    private final int size;
    private final Duration expireDuration;
    @GuardedBy(value="this")
    private final Map<String, TableColumnCache> tableToCache = new HashMap<String, TableColumnCache>();

    public ColumnCardinalityCache(Connector connector, AccumuloConfig config, Authorizations auths) {
        this.connector = Objects.requireNonNull(connector, "connector is null");
        this.size = Objects.requireNonNull(config, "config is null").getCardinalityCacheSize();
        this.expireDuration = config.getCardinalityCacheExpiration();
        this.auths = Objects.requireNonNull(auths, "auths is null");
    }

    public synchronized void deleteCache(String schema, String table) {
        LOG.debug("Deleting cache for %s.%s", new Object[]{schema, table});
        if (this.tableToCache.containsKey(table)) {
            this.getTableCache(schema, table).clear();
            this.tableToCache.remove(table);
        }
    }

    public Multimap<Long, AccumuloColumnConstraint> getCardinalities(String schema, String table, Multimap<AccumuloColumnConstraint, Range> idxConstraintRangePairs) throws ExecutionException, TableNotFoundException {
        TreeMultimap cardinalityToConstraints = TreeMultimap.create(Long::compare, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        for (Map.Entry entry : idxConstraintRangePairs.asMap().entrySet()) {
            long card = this.getColumnCardinality(schema, table, (AccumuloColumnConstraint)entry.getKey(), (Collection)entry.getValue());
            LOG.debug("Cardinality for column %s is %s", new Object[]{((AccumuloColumnConstraint)entry.getKey()).getName(), card});
            cardinalityToConstraints.put((Object)card, entry.getKey());
        }
        return ImmutableMultimap.copyOf((Multimap)cardinalityToConstraints);
    }

    private long getColumnCardinality(String schema, String table, AccumuloColumnConstraint columnConstraint, Collection<Range> indexRanges) throws ExecutionException, TableNotFoundException {
        return this.getTableCache(schema, table).getColumnCardinality(columnConstraint.getName(), columnConstraint.getFamily(), columnConstraint.getQualifier(), indexRanges);
    }

    private synchronized TableColumnCache getTableCache(String schema, String table) {
        String fullName = AccumuloTable.getFullTableName(schema, table);
        TableColumnCache cache = this.tableToCache.get(fullName);
        if (cache == null) {
            LOG.debug("Creating new TableColumnCache for %s.%s %s", new Object[]{schema, table, this});
            cache = new TableColumnCache(schema, table);
            this.tableToCache.put(fullName, cache);
        }
        return cache;
    }

    private class CardinalityCacheLoader
    extends CacheLoader<Range, Long> {
        private final String metricsTable;
        private final Text columnFamily;

        public CardinalityCacheLoader(String schema, String table, String family, String qualifier) {
            this.metricsTable = Indexer.getMetricsTableName(schema, table);
            this.columnFamily = new Text(Indexer.getIndexColumnFamily(family.getBytes(StandardCharsets.UTF_8), qualifier.getBytes(StandardCharsets.UTF_8)).array());
        }

        public Long load(Range key) throws Exception {
            BatchScanner scanner = ColumnCardinalityCache.this.connector.createBatchScanner(this.metricsTable, ColumnCardinalityCache.this.auths, 10);
            scanner.setRanges((Collection)ImmutableList.of((Object)key));
            scanner.fetchColumn(this.columnFamily, Indexer.CARDINALITY_CQ_AS_TEXT);
            long sum = 0L;
            for (Map.Entry entry : scanner) {
                sum += Long.parseLong(((Value)entry.getValue()).toString());
            }
            scanner.close();
            return sum;
        }

        public Map<Range, Long> loadAll(Iterable<? extends Range> keys) throws Exception {
            LOG.debug("Loading %s exact ranges from Accumulo", new Object[]{((Collection)keys).size()});
            BatchScanner scanner = ColumnCardinalityCache.this.connector.createBatchScanner(this.metricsTable, ColumnCardinalityCache.this.auths, 10);
            scanner.setRanges((Collection)keys);
            scanner.fetchColumn(this.columnFamily, Indexer.CARDINALITY_CQ_AS_TEXT);
            MapDefaultZero rangeValues = new MapDefaultZero();
            for (Map.Entry entry : scanner) {
                rangeValues.put(Range.exact((Text)((Key)entry.getKey()).getRow()), Long.parseLong(((Value)entry.getValue()).toString()));
            }
            scanner.close();
            return rangeValues;
        }

        public class MapDefaultZero
        extends HashMap<Range, Long> {
            @Override
            public Long get(Object key) {
                Long value = (Long)super.get(key);
                return value == null ? 0L : value;
            }
        }
    }

    private class TableColumnCache {
        private final Map<String, LoadingCache<Range, Long>> columnToCache = new HashMap<String, LoadingCache<Range, Long>>();
        private final String schema;
        private final String table;

        public TableColumnCache(String schema, String table) {
            this.schema = schema;
            this.table = table;
        }

        public void clear() {
            this.columnToCache.values().forEach(Cache::invalidateAll);
            this.columnToCache.clear();
        }

        public long getColumnCardinality(String column, String family, String qualifier, Collection<Range> colValues) throws ExecutionException, TableNotFoundException {
            LoadingCache<Range, Long> cache = this.columnToCache.get(column);
            if (cache == null) {
                cache = this.newCache(this.schema, this.table, family, qualifier);
                this.columnToCache.put(column, cache);
            }
            Collection exactRanges = colValues.stream().filter(this::isExact).collect(Collectors.toList());
            LOG.debug("Column values contain %s exact ranges of %s", new Object[]{exactRanges.size(), colValues.size()});
            long sum = 0L;
            for (Long value : cache.getAll((Iterable)exactRanges).values()) {
                sum += value.longValue();
            }
            if (exactRanges.size() != colValues.size()) {
                for (Range range : colValues) {
                    if (this.isExact(range)) continue;
                    long value = (Long)cache.get((Object)range);
                    cache.put((Object)range, (Object)value);
                    sum += value;
                }
            }
            LOG.debug("Cache stats : size=%s, %s", new Object[]{cache.size(), cache.stats()});
            return sum;
        }

        private boolean isExact(Range range) {
            return !range.isInfiniteStartKey() && !range.isInfiniteStopKey() && range.getStartKey().followingKey(PartialKey.ROW).equals((Object)range.getEndKey());
        }

        private LoadingCache<Range, Long> newCache(String schema, String table, String family, String qualifier) {
            LOG.debug("Created new cache for %s.%s, column %s:%s, size %s expiry %s", new Object[]{schema, table, family, qualifier, ColumnCardinalityCache.this.size, ColumnCardinalityCache.this.expireDuration});
            return CacheBuilder.newBuilder().maximumSize((long)ColumnCardinalityCache.this.size).expireAfterWrite(ColumnCardinalityCache.this.expireDuration.toMillis(), TimeUnit.MILLISECONDS).build((CacheLoader)new CardinalityCacheLoader(schema, table, family, qualifier));
        }
    }
}

