/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo.conf;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class AccumuloConfig {
    public static final String INSTANCE = "accumulo.instance";
    public static final String ZOOKEEPERS = "accumulo.zookeepers";
    public static final String USERNAME = "accumulo.username";
    public static final String PASSWORD = "accumulo.password";
    public static final String ZOOKEEPER_METADATA_ROOT = "accumulo.zookeeper.metadata.root";
    public static final String CARDINALITY_CACHE_SIZE = "accumulo.cardinality.cache.size";
    public static final String CARDINALITY_CACHE_EXPIRE_DURATION = "accumulo.cardinality.cache.expire.duration";
    private String instance;
    private String zooKeepers;
    private String username;
    private String password;
    private String zkMetadataRoot = "/presto-accumulo";
    private int cardinalityCacheSize = 100000;
    private Duration cardinalityCacheExpiration = new Duration(5.0, TimeUnit.MINUTES);

    @NotNull
    public String getInstance() {
        return this.instance;
    }

    @Config(value="accumulo.instance")
    @ConfigDescription(value="Accumulo instance name")
    public AccumuloConfig setInstance(String instance) {
        this.instance = instance;
        return this;
    }

    @NotNull
    public String getZooKeepers() {
        return this.zooKeepers;
    }

    @Config(value="accumulo.zookeepers")
    @ConfigDescription(value="ZooKeeper quorum connect string for Accumulo")
    public AccumuloConfig setZooKeepers(String zooKeepers) {
        this.zooKeepers = zooKeepers;
        return this;
    }

    @NotNull
    public String getUsername() {
        return this.username;
    }

    @Config(value="accumulo.username")
    @ConfigDescription(value="Sets the user to use when interacting with Accumulo. This user will require administrative permissions")
    public AccumuloConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    @NotNull
    public String getPassword() {
        return this.password;
    }

    @Config(value="accumulo.password")
    @ConfigDescription(value="Sets the password for the configured user")
    public AccumuloConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    @NotNull
    public String getZkMetadataRoot() {
        return this.zkMetadataRoot;
    }

    @Config(value="accumulo.zookeeper.metadata.root")
    @ConfigDescription(value="Sets the root znode for metadata storage")
    public void setZkMetadataRoot(String zkMetadataRoot) {
        this.zkMetadataRoot = zkMetadataRoot;
    }

    @NotNull
    @Min(value=1L)
    public int getCardinalityCacheSize() {
        return this.cardinalityCacheSize;
    }

    @Config(value="accumulo.cardinality.cache.size")
    @ConfigDescription(value="Sets the cardinality cache size")
    public void setCardinalityCacheSize(int cardinalityCacheSize) {
        this.cardinalityCacheSize = cardinalityCacheSize;
    }

    @NotNull
    public Duration getCardinalityCacheExpiration() {
        return this.cardinalityCacheExpiration;
    }

    @Config(value="accumulo.cardinality.cache.expire.duration")
    @ConfigDescription(value="Sets the cardinality cache expiration")
    public void setCardinalityCacheExpiration(Duration cardinalityCacheExpiration) {
        this.cardinalityCacheExpiration = cardinalityCacheExpiration;
    }
}

