/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ScrollView;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.LithoView;
import com.facebook.litho.Output;
import com.facebook.litho.StateValue;
import com.facebook.litho.annotations.MountSpec;
import com.facebook.litho.annotations.OnBind;
import com.facebook.litho.annotations.OnCreateInitialState;
import com.facebook.litho.annotations.OnMount;
import com.facebook.litho.annotations.OnUnbind;
import com.facebook.litho.annotations.OnUnmount;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropDefault;
import com.facebook.litho.annotations.State;

@MountSpec(canMountIncrementally=true)
public class VerticalScrollSpec {
    @PropDefault
    static final boolean scrollbarEnabled = true;
    @PropDefault
    static final boolean scrollbarFadingEnabled = true;

    static void onPrepare(ComponentContext context, @Prop Component<?> childComponent, Output<ComponentTree> childComponentTree) {
        childComponentTree.set((Object)ComponentTree.create((ComponentContext)context, childComponent).build());
    }

    static LithoScrollView onCreateMountContent(ComponentContext context) {
        return new LithoScrollView((Context)context);
    }

    @OnCreateInitialState
    static void onCreateInitialState(ComponentContext context, StateValue<ScrollPosition> scrollPosition, @Prop(optional=true) Integer initialScrollOffsetPixels) {
        ScrollPosition initialScrollPosition = new ScrollPosition();
        initialScrollPosition.y = initialScrollOffsetPixels == null ? 0 : initialScrollOffsetPixels;
        scrollPosition.set((Object)initialScrollPosition);
    }

    @OnMount
    static void onMount(ComponentContext context, LithoScrollView lithoScrollView, @Prop(optional=true) boolean scrollbarEnabled, @Prop(optional=true) boolean scrollbarFadingEnabled, ComponentTree childComponentTree, @State ScrollPosition scrollPosition) {
        lithoScrollView.mount(childComponentTree);
        lithoScrollView.setVerticalScrollBarEnabled(scrollbarEnabled);
        lithoScrollView.setScrollbarFadingEnabled(scrollbarFadingEnabled);
    }

    @OnBind
    protected static void onBind(ComponentContext context, final LithoScrollView lithoScrollView, final @State ScrollPosition scrollPosition, Output<ViewTreeObserver.OnPreDrawListener> onPreDrawListener, Output<ViewTreeObserver.OnScrollChangedListener> onScrollChangedListener) {
        ViewTreeObserver viewTreeObserver = lithoScrollView.getViewTreeObserver();
        ViewTreeObserver.OnPreDrawListener preDrawListener = new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                lithoScrollView.setScrollY(scrollPosition.y);
                ViewTreeObserver currentViewTreeObserver = lithoScrollView.getViewTreeObserver();
                if (currentViewTreeObserver.isAlive()) {
                    currentViewTreeObserver.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                }
                return true;
            }
        };
        viewTreeObserver.addOnPreDrawListener(preDrawListener);
        onPreDrawListener.set((Object)preDrawListener);
        ViewTreeObserver.OnScrollChangedListener scrollChangedListener = new ViewTreeObserver.OnScrollChangedListener(){

            public void onScrollChanged() {
                scrollPosition.y = lithoScrollView.getScrollY();
            }
        };
        viewTreeObserver.addOnScrollChangedListener(scrollChangedListener);
        onScrollChangedListener.set((Object)scrollChangedListener);
    }

    @OnUnbind
    protected static void onUnbind(ComponentContext context, LithoScrollView lithoScrollView, ViewTreeObserver.OnPreDrawListener onPreDrawListener, ViewTreeObserver.OnScrollChangedListener onScrollChangedListener) {
        ViewTreeObserver viewTreeObserver = lithoScrollView.getViewTreeObserver();
        viewTreeObserver.removeOnPreDrawListener(onPreDrawListener);
        viewTreeObserver.removeOnScrollChangedListener(onScrollChangedListener);
    }

    @OnUnmount
    static void onUnmount(ComponentContext context, LithoScrollView lithoScrollView) {
        lithoScrollView.unmount();
    }

    static class ScrollPosition {
        int y = 0;

        ScrollPosition() {
        }
    }

    static class LithoScrollView
    extends ScrollView {
        private final LithoView mLithoView;

        LithoScrollView(Context context) {
            super(context);
            this.mLithoView = new LithoView(context);
            this.addView((View)this.mLithoView);
        }

        protected void onScrollChanged(int l, int t, int oldl, int oldt) {
            super.onScrollChanged(l, t, oldl, oldt);
            this.mLithoView.performIncrementalMount();
        }

        private void mount(ComponentTree contentComponentTree) {
            this.mLithoView.setComponentTree(contentComponentTree);
        }

        private void unmount() {
            this.mLithoView.setComponentTree(null);
        }
    }
}

