/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.support.annotation.AttrRes;
import android.support.annotation.BoolRes;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.IntegerRes;
import android.support.annotation.Px;
import android.support.annotation.StringRes;
import android.support.v4.text.TextDirectionHeuristicCompat;
import android.support.v4.util.Pools;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.text.Layout;
import android.text.TextUtils;
import android.text.style.ClickableSpan;
import android.text.style.ImageSpan;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.EventDispatcher;
import com.facebook.litho.EventHandler;
import com.facebook.litho.Output;
import com.facebook.litho.Size;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.TextDrawable;
import com.facebook.litho.widget.TextOffsetOnTouchEvent;
import com.facebook.litho.widget.TextSpec;
import com.facebook.litho.widget.VerticalGravity;
import java.util.BitSet;

public final class Text
extends ComponentLifecycle {
    private static Text sInstance = null;
    static final Pools.SynchronizedPool<TextOffsetOnTouchEvent> sTextOffsetOnTouchEventPool = new Pools.SynchronizedPool(2);
    private static final Pools.SynchronizedPool<Builder> sBuilderPool = new Pools.SynchronizedPool(2);

    private Text() {
    }

    private static synchronized Text get() {
        if (sInstance == null) {
            sInstance = new Text();
        }
        return sInstance;
    }

    protected void onLoadStyle(ComponentContext c, Component _abstractImpl) {
        TextImpl _impl = (TextImpl)_abstractImpl;
        Output ellipsize = this.acquireOutput();
        Output shouldIncludeFontPadding = this.acquireOutput();
        Output spacingMultiplier = this.acquireOutput();
        Output minLines = this.acquireOutput();
        Output maxLines = this.acquireOutput();
        Output minEms = this.acquireOutput();
        Output maxEms = this.acquireOutput();
        Output minTextWidth = this.acquireOutput();
        Output maxTextWidth = this.acquireOutput();
        Output isSingleLine = this.acquireOutput();
        Output text = this.acquireOutput();
        Output textColorStateList = this.acquireOutput();
        Output linkColor = this.acquireOutput();
        Output highlightColor = this.acquireOutput();
        Output textSize = this.acquireOutput();
        Output textAlignment = this.acquireOutput();
        Output textStyle = this.acquireOutput();
        Output shadowRadius = this.acquireOutput();
        Output shadowDx = this.acquireOutput();
        Output shadowDy = this.acquireOutput();
        Output shadowColor = this.acquireOutput();
        Output verticalGravity = this.acquireOutput();
        Output typeface = this.acquireOutput();
        TextSpec.onLoadStyle(c, (Output<TextUtils.TruncateAt>)ellipsize, (Output<Boolean>)shouldIncludeFontPadding, (Output<Float>)spacingMultiplier, (Output<Integer>)minLines, (Output<Integer>)maxLines, (Output<Integer>)minEms, (Output<Integer>)maxEms, (Output<Integer>)minTextWidth, (Output<Integer>)maxTextWidth, (Output<Boolean>)isSingleLine, (Output<CharSequence>)text, (Output<ColorStateList>)textColorStateList, (Output<Integer>)linkColor, (Output<Integer>)highlightColor, (Output<Integer>)textSize, (Output<Layout.Alignment>)textAlignment, (Output<Integer>)textStyle, (Output<Float>)shadowRadius, (Output<Float>)shadowDx, (Output<Float>)shadowDy, (Output<Integer>)shadowColor, (Output<VerticalGravity>)verticalGravity, (Output<Typeface>)typeface);
        if (ellipsize.get() != null) {
            _impl.ellipsize = (TextUtils.TruncateAt)ellipsize.get();
        }
        this.releaseOutput(ellipsize);
        if (shouldIncludeFontPadding.get() != null) {
            _impl.shouldIncludeFontPadding = (Boolean)shouldIncludeFontPadding.get();
        }
        this.releaseOutput(shouldIncludeFontPadding);
        if (spacingMultiplier.get() != null) {
            _impl.spacingMultiplier = ((Float)spacingMultiplier.get()).floatValue();
        }
        this.releaseOutput(spacingMultiplier);
        if (minLines.get() != null) {
            _impl.minLines = (Integer)minLines.get();
        }
        this.releaseOutput(minLines);
        if (maxLines.get() != null) {
            _impl.maxLines = (Integer)maxLines.get();
        }
        this.releaseOutput(maxLines);
        if (minEms.get() != null) {
            _impl.minEms = (Integer)minEms.get();
        }
        this.releaseOutput(minEms);
        if (maxEms.get() != null) {
            _impl.maxEms = (Integer)maxEms.get();
        }
        this.releaseOutput(maxEms);
        if (minTextWidth.get() != null) {
            _impl.minTextWidth = (Integer)minTextWidth.get();
        }
        this.releaseOutput(minTextWidth);
        if (maxTextWidth.get() != null) {
            _impl.maxTextWidth = (Integer)maxTextWidth.get();
        }
        this.releaseOutput(maxTextWidth);
        if (isSingleLine.get() != null) {
            _impl.isSingleLine = (Boolean)isSingleLine.get();
        }
        this.releaseOutput(isSingleLine);
        if (text.get() != null) {
            _impl.text = (CharSequence)text.get();
        }
        this.releaseOutput(text);
        if (textColorStateList.get() != null) {
            _impl.textColorStateList = (ColorStateList)textColorStateList.get();
        }
        this.releaseOutput(textColorStateList);
        if (linkColor.get() != null) {
            _impl.linkColor = (Integer)linkColor.get();
        }
        this.releaseOutput(linkColor);
        if (highlightColor.get() != null) {
            _impl.highlightColor = (Integer)highlightColor.get();
        }
        this.releaseOutput(highlightColor);
        if (textSize.get() != null) {
            _impl.textSize = (Integer)textSize.get();
        }
        this.releaseOutput(textSize);
        if (textAlignment.get() != null) {
            _impl.textAlignment = (Layout.Alignment)textAlignment.get();
        }
        this.releaseOutput(textAlignment);
        if (textStyle.get() != null) {
            _impl.textStyle = (Integer)textStyle.get();
        }
        this.releaseOutput(textStyle);
        if (shadowRadius.get() != null) {
            _impl.shadowRadius = ((Float)shadowRadius.get()).floatValue();
        }
        this.releaseOutput(shadowRadius);
        if (shadowDx.get() != null) {
            _impl.shadowDx = ((Float)shadowDx.get()).floatValue();
        }
        this.releaseOutput(shadowDx);
        if (shadowDy.get() != null) {
            _impl.shadowDy = ((Float)shadowDy.get()).floatValue();
        }
        this.releaseOutput(shadowDy);
        if (shadowColor.get() != null) {
            _impl.shadowColor = (Integer)shadowColor.get();
        }
        this.releaseOutput(shadowColor);
        if (verticalGravity.get() != null) {
            _impl.verticalGravity = (VerticalGravity)((Object)verticalGravity.get());
        }
        this.releaseOutput(verticalGravity);
        if (typeface.get() != null) {
            _impl.typeface = (Typeface)typeface.get();
        }
        this.releaseOutput(typeface);
    }

    protected void onMeasure(ComponentContext context, ComponentLayout layout, int widthSpec, int heightSpec, Size size, Component _abstractImpl) {
        TextImpl _impl = (TextImpl)_abstractImpl;
        Output measureLayout = this.acquireOutput();
        Output measuredWidth = this.acquireOutput();
        Output measuredHeight = this.acquireOutput();
        TextSpec.onMeasure(context, layout, widthSpec, heightSpec, size, _impl.text, _impl.ellipsize, _impl.shouldIncludeFontPadding, _impl.minLines, _impl.maxLines, _impl.minEms, _impl.maxEms, _impl.minTextWidth, _impl.maxTextWidth, _impl.shadowRadius, _impl.shadowDx, _impl.shadowDy, _impl.shadowColor, _impl.isSingleLine, _impl.textColor, _impl.textColorStateList, _impl.linkColor, _impl.textSize, _impl.extraSpacing, _impl.spacingMultiplier, _impl.textStyle, _impl.typeface, _impl.textAlignment, _impl.glyphWarming, _impl.textDirection, (Output<Layout>)measureLayout, (Output<Integer>)measuredWidth, (Output<Integer>)measuredHeight);
        _impl.measureLayout = (Layout)measureLayout.get();
        this.releaseOutput(measureLayout);
        _impl.measuredWidth = (Integer)measuredWidth.get();
        this.releaseOutput(measuredWidth);
        _impl.measuredHeight = (Integer)measuredHeight.get();
        this.releaseOutput(measuredHeight);
    }

    protected boolean canMeasure() {
        return true;
    }

    protected void onBoundsDefined(ComponentContext c, ComponentLayout layout, Component _abstractImpl) {
        TextImpl _impl = (TextImpl)_abstractImpl;
        Output textLayout = this.acquireOutput();
        Output textLayoutTranslationY = this.acquireOutput();
        Output clickableSpans = this.acquireOutput();
        Output imageSpans = this.acquireOutput();
        TextSpec.onBoundsDefined(c, layout, _impl.text, _impl.ellipsize, _impl.shouldIncludeFontPadding, _impl.maxLines, _impl.minEms, _impl.maxEms, _impl.minTextWidth, _impl.maxTextWidth, _impl.shadowRadius, _impl.shadowDx, _impl.shadowDy, _impl.shadowColor, _impl.isSingleLine, _impl.textColor, _impl.textColorStateList, _impl.linkColor, _impl.textSize, _impl.extraSpacing, _impl.spacingMultiplier, _impl.verticalGravity, _impl.textStyle, _impl.typeface, _impl.textAlignment, _impl.glyphWarming, _impl.textDirection, _impl.measureLayout, _impl.measuredWidth, _impl.measuredHeight, (Output<Layout>)textLayout, (Output<Float>)textLayoutTranslationY, (Output<ClickableSpan[]>)clickableSpans, (Output<ImageSpan[]>)imageSpans);
        _impl.textLayout = (Layout)textLayout.get();
        this.releaseOutput(textLayout);
        _impl.textLayoutTranslationY = (Float)textLayoutTranslationY.get();
        this.releaseOutput(textLayoutTranslationY);
        _impl.clickableSpans = (ClickableSpan[])clickableSpans.get();
        this.releaseOutput(clickableSpans);
        _impl.imageSpans = (ImageSpan[])imageSpans.get();
        this.releaseOutput(imageSpans);
    }

    protected Object onCreateMountContent(ComponentContext c) {
        TextDrawable _result = TextSpec.onCreateMountContent(c);
        return _result;
    }

    protected void onMount(ComponentContext c, Object textDrawable, Component _abstractImpl) {
        TextImpl _impl = (TextImpl)_abstractImpl;
        TextSpec.onMount(c, (TextDrawable)((Object)textDrawable), _impl.text, _impl.textColor, _impl.highlightColor, _impl.textColorStateList, _impl.textOffsetOnTouchHandler, _impl.highlightStartOffset, _impl.highlightEndOffset, _impl.textLayout, _impl.textLayoutTranslationY, _impl.clickableSpans, _impl.imageSpans);
    }

    protected void onUnmount(ComponentContext c, Object textDrawable, Component _abstractImpl) {
        TextImpl _impl = (TextImpl)_abstractImpl;
        TextSpec.onUnmount(c, (TextDrawable)((Object)textDrawable), _impl.text);
    }

    protected void onPopulateAccessibilityNode(AccessibilityNodeInfoCompat node, Component _abstractImpl) {
        TextImpl _impl = (TextImpl)_abstractImpl;
        TextSpec.onPopulateAccessibilityNode(node, _impl.text);
    }

    public boolean implementsAccessibility() {
        return true;
    }

    protected int getExtraAccessibilityNodesCount(Component _abstractImpl) {
        TextImpl _impl = (TextImpl)_abstractImpl;
        int _result = TextSpec.getExtraAccessibilityNodesCount(_impl.accessibleClickableSpans, _impl.clickableSpans);
        return _result;
    }

    protected void onPopulateExtraAccessibilityNode(AccessibilityNodeInfoCompat node, int extraNodeIndex, int componentBoundsLeft, int componentBoundsTop, Component _abstractImpl) {
        TextImpl _impl = (TextImpl)_abstractImpl;
        TextSpec.onPopulateExtraAccessibilityNode(node, extraNodeIndex, componentBoundsLeft, componentBoundsTop, _impl.text, _impl.textLayout, _impl.clickableSpans);
    }

    public boolean implementsExtraAccessibilityNodes() {
        return true;
    }

    protected int getExtraAccessibilityNodeAt(int x, int y, Component _abstractImpl) {
        TextImpl _impl = (TextImpl)_abstractImpl;
        int _result = TextSpec.getExtraAccessibilityNodeAt(x, y, _impl.text, _impl.textLayout, _impl.clickableSpans);
        return _result;
    }

    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.DRAWABLE;
    }

    protected int poolSize() {
        return 30;
    }

    public boolean shouldUseDisplayList() {
        return true;
    }

    protected boolean isMountSizeDependent() {
        return true;
    }

    public boolean isPureRender() {
        return true;
    }

    public static EventHandler getTextOffsetOnTouchEventHandler(ComponentContext context) {
        if (context.getComponentScope() == null) {
            return null;
        }
        return ((TextImpl)context.getComponentScope()).textOffsetOnTouchEventHandler;
    }

    static void dispatchTextOffsetOnTouchEvent(EventHandler _eventHandler, CharSequence text, int textOffset) {
        TextOffsetOnTouchEvent _eventState = (TextOffsetOnTouchEvent)sTextOffsetOnTouchEventPool.acquire();
        if (_eventState == null) {
            _eventState = new TextOffsetOnTouchEvent();
        }
        _eventState.text = text;
        _eventState.textOffset = textOffset;
        EventDispatcher _lifecycle = _eventHandler.mHasEventDispatcher.getEventDispatcher();
        _lifecycle.dispatchOnEvent(_eventHandler, (Object)_eventState);
        _eventState.text = null;
        sTextOffsetOnTouchEventPool.release((Object)_eventState);
    }

    public static Builder create(ComponentContext context) {
        return Text.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Builder builder = (Builder)((Object)sBuilderPool.acquire());
        if (builder == null) {
            builder = new Builder();
        }
        builder.init(context, defStyleAttr, defStyleRes, new TextImpl());
        return builder;
    }

    public static class Builder
    extends Component.Builder<Text, Builder> {
        private static final String[] REQUIRED_PROPS_NAMES = new String[]{"text"};
        private static final int REQUIRED_PROPS_COUNT = 1;
        TextImpl mTextImpl;
        ComponentContext mContext;
        private BitSet mRequired = new BitSet(1);

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, TextImpl textImpl) {
            super.init(context, defStyleAttr, defStyleRes, (Component)textImpl);
            this.mTextImpl = textImpl;
            this.mContext = context;
            this.mRequired.clear();
        }

        public Builder text(CharSequence text) {
            this.mTextImpl.text = text;
            this.mRequired.set(0);
            return this;
        }

        public Builder textRes(@StringRes int resId) {
            this.mTextImpl.text = this.resolveStringRes(resId);
            this.mRequired.set(0);
            return this;
        }

        public Builder textRes(@StringRes int resId, Object ... formatArgs) {
            this.mTextImpl.text = this.resolveStringRes(resId, formatArgs);
            this.mRequired.set(0);
            return this;
        }

        public Builder textAttr(@AttrRes int attrResId, @StringRes int defResId) {
            this.mTextImpl.text = this.resolveStringAttr(attrResId, defResId);
            this.mRequired.set(0);
            return this;
        }

        public Builder textAttr(@AttrRes int attrResId) {
            this.mTextImpl.text = this.resolveStringAttr(attrResId, 0);
            this.mRequired.set(0);
            return this;
        }

        public Builder ellipsize(TextUtils.TruncateAt ellipsize) {
            this.mTextImpl.ellipsize = ellipsize;
            return this;
        }

        public Builder shouldIncludeFontPadding(boolean shouldIncludeFontPadding) {
            this.mTextImpl.shouldIncludeFontPadding = shouldIncludeFontPadding;
            return this;
        }

        public Builder shouldIncludeFontPaddingRes(@BoolRes int resId) {
            this.mTextImpl.shouldIncludeFontPadding = this.resolveBoolRes(resId);
            return this;
        }

        public Builder shouldIncludeFontPaddingAttr(@AttrRes int attrResId, @BoolRes int defResId) {
            this.mTextImpl.shouldIncludeFontPadding = this.resolveBoolAttr(attrResId, defResId);
            return this;
        }

        public Builder shouldIncludeFontPaddingAttr(@AttrRes int attrResId) {
            this.mTextImpl.shouldIncludeFontPadding = this.resolveBoolAttr(attrResId, 0);
            return this;
        }

        public Builder minLines(int minLines) {
            this.mTextImpl.minLines = minLines;
            return this;
        }

        public Builder minLinesRes(@IntegerRes int resId) {
            this.mTextImpl.minLines = this.resolveIntRes(resId);
            return this;
        }

        public Builder minLinesAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mTextImpl.minLines = this.resolveIntAttr(attrResId, defResId);
            return this;
        }

        public Builder minLinesAttr(@AttrRes int attrResId) {
            this.mTextImpl.minLines = this.resolveIntAttr(attrResId, 0);
            return this;
        }

        public Builder maxLines(int maxLines) {
            this.mTextImpl.maxLines = maxLines;
            return this;
        }

        public Builder maxLinesRes(@IntegerRes int resId) {
            this.mTextImpl.maxLines = this.resolveIntRes(resId);
            return this;
        }

        public Builder maxLinesAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mTextImpl.maxLines = this.resolveIntAttr(attrResId, defResId);
            return this;
        }

        public Builder maxLinesAttr(@AttrRes int attrResId) {
            this.mTextImpl.maxLines = this.resolveIntAttr(attrResId, 0);
            return this;
        }

        public Builder minEms(int minEms) {
            this.mTextImpl.minEms = minEms;
            return this;
        }

        public Builder minEmsRes(@IntegerRes int resId) {
            this.mTextImpl.minEms = this.resolveIntRes(resId);
            return this;
        }

        public Builder minEmsAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mTextImpl.minEms = this.resolveIntAttr(attrResId, defResId);
            return this;
        }

        public Builder minEmsAttr(@AttrRes int attrResId) {
            this.mTextImpl.minEms = this.resolveIntAttr(attrResId, 0);
            return this;
        }

        public Builder maxEms(int maxEms) {
            this.mTextImpl.maxEms = maxEms;
            return this;
        }

        public Builder maxEmsRes(@IntegerRes int resId) {
            this.mTextImpl.maxEms = this.resolveIntRes(resId);
            return this;
        }

        public Builder maxEmsAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mTextImpl.maxEms = this.resolveIntAttr(attrResId, defResId);
            return this;
        }

        public Builder maxEmsAttr(@AttrRes int attrResId) {
            this.mTextImpl.maxEms = this.resolveIntAttr(attrResId, 0);
            return this;
        }

        public Builder minTextWidthPx(@Px int minTextWidth) {
            this.mTextImpl.minTextWidth = minTextWidth;
            return this;
        }

        public Builder minTextWidthRes(@DimenRes int resId) {
            this.mTextImpl.minTextWidth = this.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder minTextWidthAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mTextImpl.minTextWidth = this.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder minTextWidthAttr(@AttrRes int attrResId) {
            this.mTextImpl.minTextWidth = this.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder minTextWidthDip(@Dimension(unit=0) float dip) {
            this.mTextImpl.minTextWidth = this.dipsToPixels(dip);
            return this;
        }

        public Builder maxTextWidthPx(@Px int maxTextWidth) {
            this.mTextImpl.maxTextWidth = maxTextWidth;
            return this;
        }

        public Builder maxTextWidthRes(@DimenRes int resId) {
            this.mTextImpl.maxTextWidth = this.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder maxTextWidthAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mTextImpl.maxTextWidth = this.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder maxTextWidthAttr(@AttrRes int attrResId) {
            this.mTextImpl.maxTextWidth = this.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder maxTextWidthDip(@Dimension(unit=0) float dip) {
            this.mTextImpl.maxTextWidth = this.dipsToPixels(dip);
            return this;
        }

        public Builder shadowRadiusPx(@Px float shadowRadius) {
            this.mTextImpl.shadowRadius = shadowRadius;
            return this;
        }

        public Builder shadowRadiusRes(@DimenRes int resId) {
            this.mTextImpl.shadowRadius = this.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder shadowRadiusAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mTextImpl.shadowRadius = this.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder shadowRadiusAttr(@AttrRes int attrResId) {
            this.mTextImpl.shadowRadius = this.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder shadowRadiusDip(@Dimension(unit=0) float dip) {
            this.mTextImpl.shadowRadius = this.dipsToPixels(dip);
            return this;
        }

        public Builder shadowDxPx(@Px float shadowDx) {
            this.mTextImpl.shadowDx = shadowDx;
            return this;
        }

        public Builder shadowDxRes(@DimenRes int resId) {
            this.mTextImpl.shadowDx = this.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder shadowDxAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mTextImpl.shadowDx = this.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder shadowDxAttr(@AttrRes int attrResId) {
            this.mTextImpl.shadowDx = this.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder shadowDxDip(@Dimension(unit=0) float dip) {
            this.mTextImpl.shadowDx = this.dipsToPixels(dip);
            return this;
        }

        public Builder shadowDyPx(@Px float shadowDy) {
            this.mTextImpl.shadowDy = shadowDy;
            return this;
        }

        public Builder shadowDyRes(@DimenRes int resId) {
            this.mTextImpl.shadowDy = this.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder shadowDyAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mTextImpl.shadowDy = this.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder shadowDyAttr(@AttrRes int attrResId) {
            this.mTextImpl.shadowDy = this.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder shadowDyDip(@Dimension(unit=0) float dip) {
            this.mTextImpl.shadowDy = this.dipsToPixels(dip);
            return this;
        }

        public Builder shadowColor(@ColorInt int shadowColor) {
            this.mTextImpl.shadowColor = shadowColor;
            return this;
        }

        public Builder shadowColorRes(@ColorRes int resId) {
            this.mTextImpl.shadowColor = this.resolveColorRes(resId);
            return this;
        }

        public Builder shadowColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mTextImpl.shadowColor = this.resolveColorAttr(attrResId, defResId);
            return this;
        }

        public Builder shadowColorAttr(@AttrRes int attrResId) {
            this.mTextImpl.shadowColor = this.resolveColorAttr(attrResId, 0);
            return this;
        }

        public Builder isSingleLine(boolean isSingleLine) {
            this.mTextImpl.isSingleLine = isSingleLine;
            return this;
        }

        public Builder isSingleLineRes(@BoolRes int resId) {
            this.mTextImpl.isSingleLine = this.resolveBoolRes(resId);
            return this;
        }

        public Builder isSingleLineAttr(@AttrRes int attrResId, @BoolRes int defResId) {
            this.mTextImpl.isSingleLine = this.resolveBoolAttr(attrResId, defResId);
            return this;
        }

        public Builder isSingleLineAttr(@AttrRes int attrResId) {
            this.mTextImpl.isSingleLine = this.resolveBoolAttr(attrResId, 0);
            return this;
        }

        public Builder textColor(@ColorInt int textColor) {
            this.mTextImpl.textColor = textColor;
            return this;
        }

        public Builder textColorRes(@ColorRes int resId) {
            this.mTextImpl.textColor = this.resolveColorRes(resId);
            return this;
        }

        public Builder textColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mTextImpl.textColor = this.resolveColorAttr(attrResId, defResId);
            return this;
        }

        public Builder textColorAttr(@AttrRes int attrResId) {
            this.mTextImpl.textColor = this.resolveColorAttr(attrResId, 0);
            return this;
        }

        public Builder textColorStateList(ColorStateList textColorStateList) {
            this.mTextImpl.textColorStateList = textColorStateList;
            return this;
        }

        public Builder linkColor(@ColorInt int linkColor) {
            this.mTextImpl.linkColor = linkColor;
            return this;
        }

        public Builder linkColorRes(@ColorRes int resId) {
            this.mTextImpl.linkColor = this.resolveColorRes(resId);
            return this;
        }

        public Builder linkColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mTextImpl.linkColor = this.resolveColorAttr(attrResId, defResId);
            return this;
        }

        public Builder linkColorAttr(@AttrRes int attrResId) {
            this.mTextImpl.linkColor = this.resolveColorAttr(attrResId, 0);
            return this;
        }

        public Builder textSizePx(@Px int textSize) {
            this.mTextImpl.textSize = textSize;
            return this;
        }

        public Builder textSizeRes(@DimenRes int resId) {
            this.mTextImpl.textSize = this.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder textSizeAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mTextImpl.textSize = this.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder textSizeAttr(@AttrRes int attrResId) {
            this.mTextImpl.textSize = this.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder textSizeDip(@Dimension(unit=0) float dip) {
            this.mTextImpl.textSize = this.dipsToPixels(dip);
            return this;
        }

        public Builder textSizeSp(@Dimension(unit=2) float sip) {
            this.mTextImpl.textSize = this.sipsToPixels(sip);
            return this;
        }

        public Builder extraSpacingPx(@Px float extraSpacing) {
            this.mTextImpl.extraSpacing = extraSpacing;
            return this;
        }

        public Builder extraSpacingRes(@DimenRes int resId) {
            this.mTextImpl.extraSpacing = this.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder extraSpacingAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mTextImpl.extraSpacing = this.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder extraSpacingAttr(@AttrRes int attrResId) {
            this.mTextImpl.extraSpacing = this.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder extraSpacingDip(@Dimension(unit=0) float dip) {
            this.mTextImpl.extraSpacing = this.dipsToPixels(dip);
            return this;
        }

        public Builder spacingMultiplier(float spacingMultiplier) {
            this.mTextImpl.spacingMultiplier = spacingMultiplier;
            return this;
        }

        public Builder spacingMultiplierRes(@DimenRes int resId) {
            this.mTextImpl.spacingMultiplier = this.resolveFloatRes(resId);
            return this;
        }

        public Builder spacingMultiplierAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mTextImpl.spacingMultiplier = this.resolveFloatAttr(attrResId, defResId);
            return this;
        }

        public Builder spacingMultiplierAttr(@AttrRes int attrResId) {
            this.mTextImpl.spacingMultiplier = this.resolveFloatAttr(attrResId, 0);
            return this;
        }

        public Builder textStyle(int textStyle) {
            this.mTextImpl.textStyle = textStyle;
            return this;
        }

        public Builder typeface(Typeface typeface) {
            this.mTextImpl.typeface = typeface;
            return this;
        }

        public Builder textAlignment(Layout.Alignment textAlignment) {
            this.mTextImpl.textAlignment = textAlignment;
            return this;
        }

        public Builder glyphWarming(boolean glyphWarming) {
            this.mTextImpl.glyphWarming = glyphWarming;
            return this;
        }

        public Builder textDirection(TextDirectionHeuristicCompat textDirection) {
            this.mTextImpl.textDirection = textDirection;
            return this;
        }

        public Builder verticalGravity(VerticalGravity verticalGravity) {
            this.mTextImpl.verticalGravity = verticalGravity;
            return this;
        }

        public Builder highlightColor(@ColorInt int highlightColor) {
            this.mTextImpl.highlightColor = highlightColor;
            return this;
        }

        public Builder highlightColorRes(@ColorRes int resId) {
            this.mTextImpl.highlightColor = this.resolveColorRes(resId);
            return this;
        }

        public Builder highlightColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mTextImpl.highlightColor = this.resolveColorAttr(attrResId, defResId);
            return this;
        }

        public Builder highlightColorAttr(@AttrRes int attrResId) {
            this.mTextImpl.highlightColor = this.resolveColorAttr(attrResId, 0);
            return this;
        }

        public Builder textOffsetOnTouchHandler(EventHandler textOffsetOnTouchHandler) {
            this.mTextImpl.textOffsetOnTouchHandler = textOffsetOnTouchHandler;
            return this;
        }

        public Builder highlightStartOffset(int highlightStartOffset) {
            this.mTextImpl.highlightStartOffset = highlightStartOffset;
            return this;
        }

        public Builder highlightEndOffset(int highlightEndOffset) {
            this.mTextImpl.highlightEndOffset = highlightEndOffset;
            return this;
        }

        public Builder accessibleClickableSpans(boolean accessibleClickableSpans) {
            this.mTextImpl.accessibleClickableSpans = accessibleClickableSpans;
            return this;
        }

        public Builder accessibleClickableSpansRes(@BoolRes int resId) {
            this.mTextImpl.accessibleClickableSpans = this.resolveBoolRes(resId);
            return this;
        }

        public Builder accessibleClickableSpansAttr(@AttrRes int attrResId, @BoolRes int defResId) {
            this.mTextImpl.accessibleClickableSpans = this.resolveBoolAttr(attrResId, defResId);
            return this;
        }

        public Builder accessibleClickableSpansAttr(@AttrRes int attrResId) {
            this.mTextImpl.accessibleClickableSpans = this.resolveBoolAttr(attrResId, 0);
            return this;
        }

        public Builder textOffsetOnTouchEventHandler(EventHandler textOffsetOnTouchEventHandler) {
            this.mTextImpl.textOffsetOnTouchEventHandler = textOffsetOnTouchEventHandler;
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public Component<Text> build() {
            Builder.checkArgs((int)1, (BitSet)this.mRequired, (String[])REQUIRED_PROPS_NAMES);
            TextImpl textImpl = this.mTextImpl;
            this.release();
            return textImpl;
        }

        protected void release() {
            super.release();
            this.mTextImpl = null;
            this.mContext = null;
            sBuilderPool.release((Object)this);
        }
    }

    static class TextImpl
    extends Component<Text>
    implements Cloneable {
        @Prop(resType=ResType.STRING, optional=false)
        CharSequence text;
        @Prop(resType=ResType.NONE, optional=true)
        TextUtils.TruncateAt ellipsize;
        @Prop(resType=ResType.BOOL, optional=true)
        boolean shouldIncludeFontPadding = true;
        @Prop(resType=ResType.INT, optional=true)
        int minLines = Integer.MIN_VALUE;
        @Prop(resType=ResType.INT, optional=true)
        int maxLines = Integer.MAX_VALUE;
        @Prop(resType=ResType.INT, optional=true)
        int minEms = -1;
        @Prop(resType=ResType.INT, optional=true)
        int maxEms = -1;
        @Prop(resType=ResType.DIMEN_SIZE, optional=true)
        int minTextWidth = 0;
        @Prop(resType=ResType.DIMEN_SIZE, optional=true)
        int maxTextWidth = Integer.MAX_VALUE;
        @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
        float shadowRadius;
        @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
        float shadowDx;
        @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
        float shadowDy;
        @Prop(resType=ResType.COLOR, optional=true)
        int shadowColor = -7829368;
        @Prop(resType=ResType.BOOL, optional=true)
        boolean isSingleLine;
        @Prop(resType=ResType.COLOR, optional=true)
        int textColor = 0;
        @Prop(resType=ResType.NONE, optional=true)
        ColorStateList textColorStateList = TextSpec.textColorStateList;
        @Prop(resType=ResType.COLOR, optional=true)
        int linkColor = 0;
        @Prop(resType=ResType.DIMEN_TEXT, optional=true)
        int textSize = 13;
        @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
        float extraSpacing;
        @Prop(resType=ResType.FLOAT, optional=true)
        float spacingMultiplier = 1.0f;
        @Prop(resType=ResType.NONE, optional=true)
        int textStyle = TextSpec.textStyle;
        @Prop(resType=ResType.NONE, optional=true)
        Typeface typeface = TextSpec.typeface;
        @Prop(resType=ResType.NONE, optional=true)
        Layout.Alignment textAlignment = TextSpec.textAlignment;
        @Prop(resType=ResType.NONE, optional=true)
        boolean glyphWarming = false;
        @Prop(resType=ResType.NONE, optional=true)
        TextDirectionHeuristicCompat textDirection;
        @Prop(resType=ResType.NONE, optional=true)
        VerticalGravity verticalGravity = TextSpec.verticalGravity;
        @Prop(resType=ResType.COLOR, optional=true)
        int highlightColor;
        @Prop(resType=ResType.NONE, optional=true)
        EventHandler textOffsetOnTouchHandler;
        @Prop(resType=ResType.NONE, optional=true)
        int highlightStartOffset = -1;
        @Prop(resType=ResType.NONE, optional=true)
        int highlightEndOffset = -1;
        @Prop(resType=ResType.BOOL, optional=true)
        boolean accessibleClickableSpans;
        Layout measureLayout;
        Integer measuredWidth;
        Integer measuredHeight;
        Layout textLayout;
        Float textLayoutTranslationY;
        ClickableSpan[] clickableSpans;
        ImageSpan[] imageSpans;
        EventHandler textOffsetOnTouchEventHandler;

        private TextImpl() {
            super((ComponentLifecycle)Text.get());
        }

        public String getSimpleName() {
            return "Text";
        }

        public boolean isEquivalentTo(Component<?> other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            TextImpl textImpl = (TextImpl)other;
            if (this.getId() == textImpl.getId()) {
                return true;
            }
            if (this.text != null ? !this.text.equals(textImpl.text) : textImpl.text != null) {
                return false;
            }
            if (this.ellipsize != null ? !this.ellipsize.equals((Object)textImpl.ellipsize) : textImpl.ellipsize != null) {
                return false;
            }
            if (this.shouldIncludeFontPadding != textImpl.shouldIncludeFontPadding) {
                return false;
            }
            if (this.minLines != textImpl.minLines) {
                return false;
            }
            if (this.maxLines != textImpl.maxLines) {
                return false;
            }
            if (this.minEms != textImpl.minEms) {
                return false;
            }
            if (this.maxEms != textImpl.maxEms) {
                return false;
            }
            if (this.minTextWidth != textImpl.minTextWidth) {
                return false;
            }
            if (this.maxTextWidth != textImpl.maxTextWidth) {
                return false;
            }
            if (Float.compare(this.shadowRadius, textImpl.shadowRadius) != 0) {
                return false;
            }
            if (Float.compare(this.shadowDx, textImpl.shadowDx) != 0) {
                return false;
            }
            if (Float.compare(this.shadowDy, textImpl.shadowDy) != 0) {
                return false;
            }
            if (this.shadowColor != textImpl.shadowColor) {
                return false;
            }
            if (this.isSingleLine != textImpl.isSingleLine) {
                return false;
            }
            if (this.textColor != textImpl.textColor) {
                return false;
            }
            if (this.textColorStateList != null ? !this.textColorStateList.equals(textImpl.textColorStateList) : textImpl.textColorStateList != null) {
                return false;
            }
            if (this.linkColor != textImpl.linkColor) {
                return false;
            }
            if (this.textSize != textImpl.textSize) {
                return false;
            }
            if (Float.compare(this.extraSpacing, textImpl.extraSpacing) != 0) {
                return false;
            }
            if (Float.compare(this.spacingMultiplier, textImpl.spacingMultiplier) != 0) {
                return false;
            }
            if (this.textStyle != textImpl.textStyle) {
                return false;
            }
            if (this.typeface != null ? !this.typeface.equals((Object)textImpl.typeface) : textImpl.typeface != null) {
                return false;
            }
            if (this.textAlignment != null ? !this.textAlignment.equals((Object)textImpl.textAlignment) : textImpl.textAlignment != null) {
                return false;
            }
            if (this.glyphWarming != textImpl.glyphWarming) {
                return false;
            }
            if (this.textDirection != null ? !this.textDirection.equals(textImpl.textDirection) : textImpl.textDirection != null) {
                return false;
            }
            if (this.verticalGravity != null ? !this.verticalGravity.equals((Object)textImpl.verticalGravity) : textImpl.verticalGravity != null) {
                return false;
            }
            if (this.highlightColor != textImpl.highlightColor) {
                return false;
            }
            if (this.textOffsetOnTouchHandler != null ? !this.textOffsetOnTouchHandler.equals(textImpl.textOffsetOnTouchHandler) : textImpl.textOffsetOnTouchHandler != null) {
                return false;
            }
            if (this.highlightStartOffset != textImpl.highlightStartOffset) {
                return false;
            }
            if (this.highlightEndOffset != textImpl.highlightEndOffset) {
                return false;
            }
            return this.accessibleClickableSpans == textImpl.accessibleClickableSpans;
        }

        protected void copyInterStageImpl(Component<Text> impl) {
            TextImpl textImpl = (TextImpl)impl;
            this.measureLayout = textImpl.measureLayout;
            this.measuredWidth = textImpl.measuredWidth;
            this.measuredHeight = textImpl.measuredHeight;
            this.textLayout = textImpl.textLayout;
            this.textLayoutTranslationY = textImpl.textLayoutTranslationY;
            this.clickableSpans = textImpl.clickableSpans;
            this.imageSpans = textImpl.imageSpans;
        }

        public TextImpl makeShallowCopy() {
            TextImpl component = (TextImpl)super.makeShallowCopy();
            component.measureLayout = null;
            component.measuredWidth = null;
            component.measuredHeight = null;
            component.textLayout = null;
            component.textLayoutTranslationY = null;
            component.clickableSpans = null;
            component.imageSpans = null;
            return component;
        }
    }
}

