/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.annotation.TargetApi;
import android.support.annotation.VisibleForTesting;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.LithoView;
import com.facebook.litho.widget.HasStickyHeader;
import com.facebook.litho.widget.RecyclerViewWrapper;

@TargetApi(value=14)
class StickyHeaderController
extends RecyclerView.OnScrollListener {
    static final String WRAPPER_ARGUMENT_NULL = "Cannot initialize with null RecyclerViewWrapper.";
    static final String WRAPPER_ALREADY_INITIALIZED = "RecyclerViewWrapper has already been initialized but never reset.";
    static final String WRAPPER_NOT_INITIALIZED = "RecyclerViewWrapper has not been set yet.";
    static final String LAYOUTMANAGER_NOT_INITIALIZED = "LayoutManager of RecyclerView is not initialized yet.";
    private final HasStickyHeader mHasStickyHeader;
    private RecyclerViewWrapper mRecyclerViewWrapper;
    private RecyclerView.LayoutManager mLayoutManager;
    private View lastTranslatedView;
    private int previousStickyHeaderPosition = -1;

    StickyHeaderController(HasStickyHeader hasStickyHeader) {
        this.mHasStickyHeader = hasStickyHeader;
    }

    void init(RecyclerViewWrapper recyclerViewWrapper) {
        if (recyclerViewWrapper == null) {
            throw new RuntimeException(WRAPPER_ARGUMENT_NULL);
        }
        if (this.mRecyclerViewWrapper != null) {
            throw new RuntimeException(WRAPPER_ALREADY_INITIALIZED);
        }
        this.mRecyclerViewWrapper = recyclerViewWrapper;
        this.mRecyclerViewWrapper.hideStickyHeader();
        this.mLayoutManager = recyclerViewWrapper.getRecyclerView().getLayoutManager();
        if (this.mLayoutManager == null) {
            throw new RuntimeException(LAYOUTMANAGER_NOT_INITIALIZED);
        }
        this.mRecyclerViewWrapper.getRecyclerView().addOnScrollListener((RecyclerView.OnScrollListener)this);
    }

    void reset() {
        if (this.mRecyclerViewWrapper == null) {
            throw new IllegalStateException(WRAPPER_NOT_INITIALIZED);
        }
        this.mRecyclerViewWrapper.getRecyclerView().removeOnScrollListener((RecyclerView.OnScrollListener)this);
        this.mLayoutManager = null;
        this.mRecyclerViewWrapper = null;
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        int firstVisiblePosition = this.mHasStickyHeader.findFirstVisibleItemPosition();
        if (firstVisiblePosition == -1) {
            return;
        }
        int stickyHeaderPosition = this.findStickyHeaderPosition(firstVisiblePosition);
        ComponentTree firstVisibleItemComponentTree = this.mHasStickyHeader.getComponentAt(firstVisiblePosition);
        if (this.lastTranslatedView != null && firstVisibleItemComponentTree != null && this.lastTranslatedView != firstVisibleItemComponentTree.getLithoView()) {
            this.lastTranslatedView.setTranslationY(0.0f);
            this.lastTranslatedView = null;
        }
        if (stickyHeaderPosition == -1 || firstVisibleItemComponentTree == null) {
            this.mRecyclerViewWrapper.hideStickyHeader();
            this.previousStickyHeaderPosition = -1;
            return;
        }
        if (firstVisiblePosition == stickyHeaderPosition) {
            LithoView firstVisibleView = firstVisibleItemComponentTree.getLithoView();
            if (!this.mHasStickyHeader.isValidPosition(stickyHeaderPosition + 1) || !this.mHasStickyHeader.isSticky(stickyHeaderPosition + 1)) {
                firstVisibleView.setTranslationY((float)(-firstVisibleView.getTop()));
            }
            this.lastTranslatedView = firstVisibleView;
            this.mRecyclerViewWrapper.hideStickyHeader();
            this.previousStickyHeaderPosition = -1;
        } else {
            if (this.mRecyclerViewWrapper.isStickyHeaderHidden() || stickyHeaderPosition != this.previousStickyHeaderPosition) {
                this.initStickyHeader(stickyHeaderPosition);
                this.mRecyclerViewWrapper.showStickyHeader();
            }
            int lastVisiblePosition = this.mHasStickyHeader.findLastVisibleItemPosition();
            int translationY = 0;
            for (int i = firstVisiblePosition; i <= lastVisiblePosition; ++i) {
                if (!this.mHasStickyHeader.isSticky(i)) continue;
                View nextStickyHeader = this.mLayoutManager.findViewByPosition(i);
                int offsetBetweenStickyHeaders = nextStickyHeader.getTop() - this.mRecyclerViewWrapper.getStickyHeader().getBottom() + this.mRecyclerViewWrapper.getPaddingTop();
                translationY = Math.min(offsetBetweenStickyHeaders, 0);
                break;
            }
            this.mRecyclerViewWrapper.setStickyHeaderVerticalOffset(translationY);
            this.previousStickyHeaderPosition = stickyHeaderPosition;
        }
    }

    private void initStickyHeader(int stickyHeaderPosition) {
        ComponentTree componentTree = this.mHasStickyHeader.getComponentAt(stickyHeaderPosition);
        StickyHeaderController.detachLithoViewIfNeeded(componentTree.getLithoView());
        this.mRecyclerViewWrapper.setStickyComponent(componentTree);
    }

    private static void detachLithoViewIfNeeded(LithoView view) {
        boolean isAttachedToWindow;
        if (view == null) {
            return;
        }
        boolean bl = isAttachedToWindow = view.getWindowToken() != null;
        if (isAttachedToWindow) {
            view.onStartTemporaryDetach();
        }
    }

    @VisibleForTesting(otherwise=2)
    int findStickyHeaderPosition(int currentFirstVisiblePosition) {
        for (int i = currentFirstVisiblePosition; i >= 0; --i) {
            if (!this.mHasStickyHeader.isSticky(i)) continue;
            return i;
        }
        return -1;
    }
}

