/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.support.annotation.UiThread;
import android.support.annotation.VisibleForTesting;
import android.support.v4.util.SimpleArrayMap;
import android.util.SparseArray;
import com.facebook.litho.viewcompat.ViewCreator;
import com.facebook.litho.widget.RenderInfo;

public class RenderInfoViewCreatorController {
    @VisibleForTesting
    final SparseArray<ViewCreator> mViewTypeToViewCreator = new SparseArray();
    @VisibleForTesting
    final SimpleArrayMap<ViewCreator, Integer> mViewCreatorToUsageCount = new SimpleArrayMap();
    public static final int COMPONENT_VIEW_TYPE = 0;
    private int mViewTypeCounter = 1;

    @UiThread
    public void maybeUpdateViewCreatorMappingsOnItemInsert(RenderInfo renderInfo) {
        int viewType;
        if (!renderInfo.rendersView()) {
            return;
        }
        ViewCreator viewCreator = renderInfo.getViewCreator();
        if (this.mViewCreatorToUsageCount.containsKey((Object)viewCreator)) {
            int currentUsageCount = (Integer)this.mViewCreatorToUsageCount.get((Object)viewCreator);
            this.mViewCreatorToUsageCount.put((Object)viewCreator, (Object)(currentUsageCount + 1));
            viewType = this.mViewTypeToViewCreator.keyAt(this.mViewTypeToViewCreator.indexOfValue((Object)viewCreator));
        } else {
            this.mViewCreatorToUsageCount.put((Object)viewCreator, (Object)1);
            viewType = this.mViewTypeCounter++;
            this.mViewTypeToViewCreator.put(viewType, (Object)viewCreator);
        }
        renderInfo.setViewType(viewType);
    }

    @UiThread
    private void updateViewType(RenderInfo renderInfo) {
        ViewCreator viewCreator = renderInfo.getViewCreator();
        if (!this.mViewCreatorToUsageCount.containsKey((Object)viewCreator)) {
            throw new IllegalStateException("Trying to update viewType of RenderInfo whose ViewCreator isn't being tracked.");
        }
        int viewType = this.mViewTypeToViewCreator.keyAt(this.mViewTypeToViewCreator.indexOfValue((Object)viewCreator));
        renderInfo.setViewType(viewType);
    }

    @UiThread
    public void maybeUpdateViewCreatorMappingsOnItemRemove(RenderInfo renderInfo) {
        if (!renderInfo.rendersView()) {
            return;
        }
        ViewCreator viewCreator = renderInfo.getViewCreator();
        if (!this.mViewCreatorToUsageCount.containsKey((Object)viewCreator)) {
            throw new IllegalStateException("Trying to remove ViewCreator that isn't being tracked.");
        }
        int usageCount = (Integer)this.mViewCreatorToUsageCount.get((Object)viewCreator);
        if (--usageCount == 0) {
            this.mViewCreatorToUsageCount.remove((Object)viewCreator);
            int index = this.mViewTypeToViewCreator.indexOfValue((Object)viewCreator);
            this.mViewTypeToViewCreator.removeAt(index);
        } else {
            if (usageCount < 0) {
                throw new IllegalStateException("Usage count of ViewCreator cannot be negative.");
            }
            this.mViewCreatorToUsageCount.put((Object)viewCreator, (Object)usageCount);
        }
    }

    public void maybeUpdateViewCreatorMappingsOnItemUpdate(RenderInfo previousRenderInfo, RenderInfo newRenderInfo) {
        boolean skipUpdatingViewCreatorMappings;
        boolean bl = skipUpdatingViewCreatorMappings = previousRenderInfo.rendersView() && newRenderInfo.rendersView() && previousRenderInfo.getViewCreator() == newRenderInfo.getViewCreator();
        if (skipUpdatingViewCreatorMappings) {
            this.updateViewType(newRenderInfo);
        } else {
            this.maybeUpdateViewCreatorMappingsOnItemRemove(previousRenderInfo);
            this.maybeUpdateViewCreatorMappingsOnItemInsert(newRenderInfo);
        }
    }

    public ViewCreator getViewCreator(int viewType) {
        return (ViewCreator)this.mViewTypeToViewCreator.get(viewType);
    }
}

