/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.UiThread;
import android.support.annotation.VisibleForTesting;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.EventHandler;
import com.facebook.litho.LayoutHandler;
import com.facebook.litho.LithoView;
import com.facebook.litho.MeasureComparisonUtils;
import com.facebook.litho.Size;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.utils.DisplayListUtils;
import com.facebook.litho.viewcompat.ViewCreator;
import com.facebook.litho.widget.Binder;
import com.facebook.litho.widget.ComponentRenderInfo;
import com.facebook.litho.widget.ComponentTreeHolder;
import com.facebook.litho.widget.HasStickyHeader;
import com.facebook.litho.widget.LayoutHandlerFactory;
import com.facebook.litho.widget.LayoutInfo;
import com.facebook.litho.widget.LinearLayoutInfo;
import com.facebook.litho.widget.LithoViewFactory;
import com.facebook.litho.widget.ReMeasureEvent;
import com.facebook.litho.widget.RecyclerViewWrapper;
import com.facebook.litho.widget.RenderInfo;
import com.facebook.litho.widget.RenderInfoViewCreatorController;
import com.facebook.litho.widget.StickyHeaderController;
import com.facebook.litho.widget.ViewportInfo;
import com.facebook.litho.widget.ViewportManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class RecyclerBinder
implements Binder<RecyclerView>,
LayoutInfo.RenderInfoCollection,
HasStickyHeader {
    private static final int UNINITIALIZED = -1;
    private static final Size sDummySize = new Size();
    private static final String TAG = RecyclerBinder.class.getSimpleName();
    @GuardedBy(value="this")
    private final List<ComponentTreeHolder> mComponentTreeHolders;
    private final LayoutInfo mLayoutInfo;
    private final RecyclerView.Adapter mInternalAdapter;
    private final ComponentContext mComponentContext;
    private final RangeScrollListener mRangeScrollListener = new RangeScrollListener();
    private final LayoutHandlerFactory mLayoutHandlerFactory;
    @Nullable
    private final LithoViewFactory mLithoViewFactory;
    private final ComponentTreeHolderFactory mComponentTreeHolderFactory;
    private final Handler mMainThreadHandler = new Handler(Looper.getMainLooper());
    private final List<ComponentTreeHolder> mPendingComponentTreeHolders;
    private final float mRangeRatio;
    private final AtomicBoolean mIsMeasured = new AtomicBoolean(false);
    private final AtomicBoolean mRequiresRemeasure = new AtomicBoolean(false);
    private final Runnable mRemeasureRunnable = new Runnable(){

        @Override
        public void run() {
            if (RecyclerBinder.this.mReMeasureEventEventHandler != null) {
                RecyclerBinder.this.mReMeasureEventEventHandler.dispatchEvent((Object)new ReMeasureEvent());
            }
        }
    };
    private final Runnable mNotifyDatasetChangedRunnable = new Runnable(){

        @Override
        public void run() {
            RecyclerBinder.this.mInternalAdapter.notifyDataSetChanged();
        }
    };
    private int mLastWidthSpec = -1;
    private int mLastHeightSpec = -1;
    private Size mMeasuredSize;
    private RecyclerView mMountedView;
    private int mCurrentFirstVisiblePosition = -1;
    private int mCurrentLastVisiblePosition = -1;
    private int mCurrentOffset;
    @Nullable
    private RangeCalculationResult mRange;
    private StickyHeaderController mStickyHeaderController;
    private final boolean mCanPrefetchDisplayLists;
    private final boolean mCanCacheDrawingDisplayLists;
    private EventHandler<ReMeasureEvent> mReMeasureEventEventHandler;
    private final ViewportManager mViewportManager;
    private final ViewportInfo.ViewportChanged mViewportChangedListener = new ViewportInfo.ViewportChanged(){

        @Override
        public void viewportChanged(int firstVisibleIndex, int lastVisibleIndex, int firstFullyVisibleIndex, int lastFullyVisibleIndex, boolean dataInRangeIsChanged) {
            RecyclerBinder.this.onNewVisibleRange(firstVisibleIndex, lastVisibleIndex);
        }
    };
    @VisibleForTesting
    final RenderInfoViewCreatorController mRenderInfoViewCreatorController = new RenderInfoViewCreatorController();
    static final ComponentTreeHolderFactory DEFAULT_COMPONENT_TREE_HOLDER_FACTORY = new ComponentTreeHolderFactory(){

        @Override
        public ComponentTreeHolder create(RenderInfo renderInfo, LayoutHandler layoutHandler, boolean canPrefetchDisplayLists, boolean canCacheDrawingDisplayLists) {
            return ComponentTreeHolder.acquire(renderInfo, layoutHandler, canPrefetchDisplayLists, canCacheDrawingDisplayLists);
        }
    };

    private RecyclerBinder(Builder builder) {
        this.mComponentContext = builder.componentContext;
        this.mComponentTreeHolderFactory = builder.componentTreeHolderFactory;
        this.mComponentTreeHolders = new ArrayList<ComponentTreeHolder>();
        this.mPendingComponentTreeHolders = new ArrayList<ComponentTreeHolder>();
        this.mInternalAdapter = new InternalAdapter();
        this.mRangeRatio = builder.rangeRatio;
        this.mLayoutInfo = builder.layoutInfo;
        this.mLayoutHandlerFactory = builder.layoutHandlerFactory;
        this.mLithoViewFactory = builder.lithoViewFactory;
        this.mCanPrefetchDisplayLists = builder.canPrefetchDisplayLists;
        this.mCanCacheDrawingDisplayLists = builder.canCacheDrawingDisplayLists;
        this.mViewportManager = new ViewportManager(this.mCurrentFirstVisiblePosition, this.mCurrentLastVisiblePosition, builder.layoutInfo, this.mMainThreadHandler, 0);
    }

    @UiThread
    public final void updateItemAtAsync(int position, RenderInfo renderInfo) {
        ThreadUtils.assertMainThread();
        if (!this.mIsMeasured.get()) {
            this.updateItemAt(position, renderInfo);
            return;
        }
    }

    @UiThread
    public final void insertItemAtAsync(int position, RenderInfo renderInfo) {
        ThreadUtils.assertMainThread();
        if (!this.mIsMeasured.get()) {
            this.insertItemAt(position, renderInfo);
            return;
        }
    }

    @UiThread
    public final void moveItemAsync(int fromPosition, int toPosition) {
        ThreadUtils.assertMainThread();
        if (!this.mIsMeasured.get()) {
            this.moveItem(fromPosition, toPosition);
            return;
        }
    }

    @UiThread
    public final void removeItemAtAsync(int position) {
        ThreadUtils.assertMainThread();
        if (!this.mIsMeasured.get()) {
            this.removeItemAt(position);
            return;
        }
    }

    @UiThread
    public final void appendItem(Component component) {
        this.insertItemAt(this.getItemCount(), component);
    }

    @UiThread
    public final void appendItem(RenderInfo renderInfo) {
        this.insertItemAt(this.getItemCount(), renderInfo);
    }

    @UiThread
    public final void insertItemAt(int position, Component component) {
        this.insertItemAt(position, ComponentRenderInfo.create().component(component).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public final void insertItemAt(int position, RenderInfo renderInfo) {
        boolean computeLayout;
        int childrenHeightSpec;
        int childrenWidthSpec;
        ThreadUtils.assertMainThread();
        ComponentTreeHolder holder = this.mComponentTreeHolderFactory.create(renderInfo, this.mLayoutHandlerFactory != null ? this.mLayoutHandlerFactory.createLayoutCalculationHandler(renderInfo) : null, this.mCanPrefetchDisplayLists, this.mCanCacheDrawingDisplayLists);
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            this.mComponentTreeHolders.add(position, holder);
            this.mRenderInfoViewCreatorController.maybeUpdateViewCreatorMappingsOnItemInsert(renderInfo);
            childrenWidthSpec = this.getActualChildrenWidthSpec(holder);
            childrenHeightSpec = this.getActualChildrenHeightSpec(holder);
            if (this.mIsMeasured.get() && holder.getRenderInfo().rendersComponent()) {
                if (this.mRange == null && !this.mRequiresRemeasure.get()) {
                    this.initRange(this.mMeasuredSize.width, this.mMeasuredSize.height, position, childrenWidthSpec, childrenHeightSpec, this.mLayoutInfo.getScrollDirection());
                    computeLayout = false;
                } else if (this.mRequiresRemeasure.get()) {
                    this.requestUpdate();
                    computeLayout = false;
                } else {
                    int firstVisiblePosition = Math.max(this.mCurrentFirstVisiblePosition, 0);
                    computeLayout = position >= firstVisiblePosition && position < firstVisiblePosition + this.mRange.estimatedViewportCount;
                }
            } else {
                computeLayout = false;
            }
        }
        if (computeLayout) {
            holder.computeLayoutSync(this.mComponentContext, childrenWidthSpec, childrenHeightSpec, null);
        }
        this.mInternalAdapter.notifyItemInserted(position);
        this.computeRange(this.mCurrentFirstVisiblePosition, this.mCurrentLastVisiblePosition);
        this.mViewportManager.setDataChangedIsVisible(this.mViewportManager.isInsertInVisibleRange(position, 1, this.mRange != null ? this.mRange.estimatedViewportCount : -1));
    }

    private void requestUpdate() {
        if (this.mMountedView != null) {
            this.mMainThreadHandler.removeCallbacks(this.mRemeasureRunnable);
            this.mMountedView.removeCallbacks(this.mRemeasureRunnable);
            ViewCompat.postOnAnimation((View)this.mMountedView, (Runnable)this.mRemeasureRunnable);
        } else {
            this.mMainThreadHandler.removeCallbacks(this.mRemeasureRunnable);
            this.mMainThreadHandler.post(this.mRemeasureRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public final void insertRangeAt(int position, List<RenderInfo> renderInfos) {
        ThreadUtils.assertMainThread();
        int size = renderInfos.size();
        for (int i = 0; i < size; ++i) {
            RecyclerBinder recyclerBinder = this;
            synchronized (recyclerBinder) {
                RenderInfo renderInfo = renderInfos.get(i);
                ComponentTreeHolder holder = this.mComponentTreeHolderFactory.create(renderInfo, this.mLayoutHandlerFactory != null ? this.mLayoutHandlerFactory.createLayoutCalculationHandler(renderInfo) : null, this.mCanPrefetchDisplayLists, this.mCanCacheDrawingDisplayLists);
                this.mComponentTreeHolders.add(position + i, holder);
                this.mRenderInfoViewCreatorController.maybeUpdateViewCreatorMappingsOnItemInsert(renderInfo);
                if (this.mIsMeasured.get() && holder.getRenderInfo().rendersComponent()) {
                    if (this.mRange == null && !this.mRequiresRemeasure.get()) {
                        this.initRange(this.mMeasuredSize.width, this.mMeasuredSize.height, position + i, this.getActualChildrenWidthSpec(holder), this.getActualChildrenHeightSpec(holder), this.mLayoutInfo.getScrollDirection());
                    } else if (this.mRequiresRemeasure.get()) {
                        this.requestUpdate();
                    }
                }
                continue;
            }
        }
        this.mInternalAdapter.notifyItemRangeInserted(position, renderInfos.size());
        this.computeRange(this.mCurrentFirstVisiblePosition, this.mCurrentLastVisiblePosition);
        this.mViewportManager.setDataChangedIsVisible(this.mViewportManager.isInsertInVisibleRange(position, renderInfos.size(), this.mRange != null ? this.mRange.estimatedViewportCount : -1));
    }

    @UiThread
    public final void updateItemAt(int position, Component component) {
        this.updateItemAt(position, ComponentRenderInfo.create().component(component).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public final void updateItemAt(int position, RenderInfo renderInfo) {
        int childrenHeightSpec;
        int childrenWidthSpec;
        boolean shouldComputeLayout;
        ComponentTreeHolder holder;
        ThreadUtils.assertMainThread();
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            holder = this.mComponentTreeHolders.get(position);
            shouldComputeLayout = this.mRange != null && position >= this.mCurrentFirstVisiblePosition && position < this.mCurrentFirstVisiblePosition + this.mRange.estimatedViewportCount;
            RenderInfo previousRenderInfo = holder.getRenderInfo();
            this.mRenderInfoViewCreatorController.maybeUpdateViewCreatorMappingsOnItemUpdate(previousRenderInfo, renderInfo);
            holder.setRenderInfo(renderInfo);
            if (this.mRange == null && this.mIsMeasured.get() && renderInfo.rendersComponent()) {
                this.initRange(this.mMeasuredSize.width, this.mMeasuredSize.height, position, this.getActualChildrenWidthSpec(holder), this.getActualChildrenHeightSpec(holder), this.mLayoutInfo.getScrollDirection());
            }
            childrenWidthSpec = this.getActualChildrenWidthSpec(holder);
            childrenHeightSpec = this.getActualChildrenHeightSpec(holder);
        }
        if (shouldComputeLayout) {
            holder.computeLayoutSync(this.mComponentContext, childrenWidthSpec, childrenHeightSpec, null);
        }
        this.mInternalAdapter.notifyItemChanged(position);
        this.computeRange(this.mCurrentFirstVisiblePosition, this.mCurrentLastVisiblePosition);
        this.mViewportManager.setDataChangedIsVisible(this.mViewportManager.isUpdateInVisibleRange(position, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public final void updateRangeAt(int position, List<RenderInfo> renderInfos) {
        ThreadUtils.assertMainThread();
        int size = renderInfos.size();
        for (int i = 0; i < size; ++i) {
            RecyclerBinder recyclerBinder = this;
            synchronized (recyclerBinder) {
                ComponentTreeHolder holder = this.mComponentTreeHolders.get(position + i);
                RenderInfo previousRenderInfo = holder.getRenderInfo();
                RenderInfo newRenderInfo = renderInfos.get(i);
                this.mRenderInfoViewCreatorController.maybeUpdateViewCreatorMappingsOnItemUpdate(previousRenderInfo, newRenderInfo);
                holder.setRenderInfo(newRenderInfo);
                if (this.mRange == null && this.mIsMeasured.get() && newRenderInfo.rendersComponent()) {
                    this.initRange(this.mMeasuredSize.width, this.mMeasuredSize.height, position + i, this.getActualChildrenWidthSpec(holder), this.getActualChildrenHeightSpec(holder), this.mLayoutInfo.getScrollDirection());
                }
                continue;
            }
        }
        this.mInternalAdapter.notifyItemRangeChanged(position, renderInfos.size());
        this.computeRange(this.mCurrentFirstVisiblePosition, this.mCurrentLastVisiblePosition);
        this.mViewportManager.setDataChangedIsVisible(this.mViewportManager.isUpdateInVisibleRange(position, renderInfos.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public final void moveItem(int fromPosition, int toPosition) {
        int childrenHeightSpec;
        int childrenWidthSpec;
        boolean isNewPositionInVisibleRange;
        boolean isNewPositionInRange;
        ComponentTreeHolder holder;
        ThreadUtils.assertMainThread();
        int mRangeSize = this.mRange != null ? this.mRange.estimatedViewportCount : -1;
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            holder = this.mComponentTreeHolders.remove(fromPosition);
            this.mComponentTreeHolders.add(toPosition, holder);
            isNewPositionInRange = mRangeSize > 0 && (float)toPosition >= (float)this.mCurrentFirstVisiblePosition - (float)mRangeSize * this.mRangeRatio && (float)toPosition <= (float)(this.mCurrentFirstVisiblePosition + mRangeSize) + (float)mRangeSize * this.mRangeRatio;
            isNewPositionInVisibleRange = mRangeSize > 0 && toPosition >= this.mCurrentFirstVisiblePosition && toPosition <= this.mCurrentFirstVisiblePosition + mRangeSize;
            childrenWidthSpec = this.getActualChildrenWidthSpec(holder);
            childrenHeightSpec = this.getActualChildrenHeightSpec(holder);
        }
        boolean isTreeValid = holder.isTreeValid();
        if (isTreeValid && !isNewPositionInRange) {
            holder.acquireStateHandlerAndReleaseTree();
        } else if (isNewPositionInVisibleRange && !isTreeValid) {
            holder.computeLayoutSync(this.mComponentContext, childrenWidthSpec, childrenHeightSpec, null);
        }
        this.mInternalAdapter.notifyItemMoved(fromPosition, toPosition);
        this.computeRange(this.mCurrentFirstVisiblePosition, this.mCurrentLastVisiblePosition);
        this.mViewportManager.setDataChangedIsVisible(this.mViewportManager.isMoveInVisibleRange(fromPosition, toPosition, mRangeSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public final void removeItemAt(int position) {
        ComponentTreeHolder holder;
        ThreadUtils.assertMainThread();
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            holder = this.mComponentTreeHolders.remove(position);
            this.mRenderInfoViewCreatorController.maybeUpdateViewCreatorMappingsOnItemRemove(holder.getRenderInfo());
        }
        this.mInternalAdapter.notifyItemRemoved(position);
        holder.release();
        this.computeRange(this.mCurrentFirstVisiblePosition, this.mCurrentLastVisiblePosition);
        this.mViewportManager.setDataChangedIsVisible(this.mViewportManager.isRemoveInVisibleRange(position, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public final void removeRangeAt(int position, int count) {
        ThreadUtils.assertMainThread();
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            for (int i = 0; i < count; ++i) {
                ComponentTreeHolder holder = this.mComponentTreeHolders.remove(position);
                this.mRenderInfoViewCreatorController.maybeUpdateViewCreatorMappingsOnItemRemove(holder.getRenderInfo());
                holder.release();
            }
        }
        this.mInternalAdapter.notifyItemRangeRemoved(position, count);
        this.computeRange(this.mCurrentFirstVisiblePosition, this.mCurrentLastVisiblePosition);
        this.mViewportManager.setDataChangedIsVisible(this.mViewportManager.isRemoveInVisibleRange(position, count));
    }

    @Override
    @Nullable
    public final synchronized ComponentTree getComponentAt(int position) {
        return this.mComponentTreeHolders.get(position).getComponentTree();
    }

    @Override
    public final synchronized RenderInfo getRenderInfoAt(int position) {
        return this.mComponentTreeHolders.get(position).getRenderInfo();
    }

    @Override
    public void bind(RecyclerView view) {
    }

    @Override
    public void unbind(RecyclerView view) {
    }

    @Override
    public synchronized void measure(Size outSize, int widthSpec, int heightSpec, EventHandler<ReMeasureEvent> reMeasureEventHandler) {
        int scrollDirection = this.mLayoutInfo.getScrollDirection();
        switch (scrollDirection) {
            case 0: {
                if (SizeSpec.getMode((int)widthSpec) != 0) break;
                throw new IllegalStateException("Width mode has to be EXACTLY OR AT MOST for an horizontal scrolling RecyclerView");
            }
            case 1: {
                if (SizeSpec.getMode((int)heightSpec) != 0) break;
                throw new IllegalStateException("Height mode has to be EXACTLY OR AT MOST for a vertical scrolling RecyclerView");
            }
            default: {
                throw new UnsupportedOperationException("The orientation defined by LayoutInfo should be either OrientationHelper.HORIZONTAL or OrientationHelper.VERTICAL");
            }
        }
        if (this.mLastWidthSpec != -1 && !this.mRequiresRemeasure.get()) {
            switch (scrollDirection) {
                case 1: {
                    if (!MeasureComparisonUtils.isMeasureSpecCompatible((int)this.mLastWidthSpec, (int)widthSpec, (int)this.mMeasuredSize.width)) break;
                    outSize.width = this.mMeasuredSize.width;
                    outSize.height = SizeSpec.getSize((int)heightSpec);
                    return;
                }
                default: {
                    if (!MeasureComparisonUtils.isMeasureSpecCompatible((int)this.mLastHeightSpec, (int)heightSpec, (int)this.mMeasuredSize.height)) break;
                    outSize.width = SizeSpec.getSize((int)widthSpec);
                    outSize.height = this.mMeasuredSize.height;
                    return;
                }
            }
            this.mIsMeasured.set(false);
            this.invalidateLayoutData();
        }
        this.mLastWidthSpec = widthSpec;
        this.mLastHeightSpec = heightSpec;
        boolean shouldInitRange = this.mRange == null && !this.mComponentTreeHolders.isEmpty() && this.mCurrentFirstVisiblePosition < this.mComponentTreeHolders.size();
        int positionToComputeLayout = this.findFirstComponentPosition();
        if (shouldInitRange && positionToComputeLayout >= 0) {
            this.initRange(SizeSpec.getSize((int)widthSpec), SizeSpec.getSize((int)heightSpec), positionToComputeLayout, this.getActualChildrenWidthSpec(this.mComponentTreeHolders.get(positionToComputeLayout)), this.getActualChildrenHeightSpec(this.mComponentTreeHolders.get(positionToComputeLayout)), scrollDirection);
        }
        boolean canMeasure = reMeasureEventHandler != null;
        switch (scrollDirection) {
            case 1: {
                if (!canMeasure && SizeSpec.getMode((int)widthSpec) == 0) {
                    throw new IllegalStateException("Can't use Unspecified width on a vertical scrolling Recycler if dynamic measurement is not allowed");
                }
                outSize.height = SizeSpec.getSize((int)heightSpec);
                if (SizeSpec.getMode((int)widthSpec) == 0x40000000 || !canMeasure) {
                    outSize.width = SizeSpec.getSize((int)widthSpec);
                    this.mReMeasureEventEventHandler = null;
                    this.mRequiresRemeasure.set(false);
                    break;
                }
                if (this.mRange != null && (SizeSpec.getMode((int)widthSpec) == Integer.MIN_VALUE || SizeSpec.getMode((int)widthSpec) == 0)) {
                    outSize.width = this.mRange.measuredSize;
                    this.mReMeasureEventEventHandler = null;
                    this.mRequiresRemeasure.set(false);
                    break;
                }
                outSize.width = 0;
                this.mRequiresRemeasure.set(true);
                this.mReMeasureEventEventHandler = reMeasureEventHandler;
                break;
            }
            case 0: {
                if (!canMeasure && SizeSpec.getMode((int)heightSpec) == 0) {
                    throw new IllegalStateException("Can't use Unspecified height on an horizontal scrolling Recycler if dynamic measurement is not allowed");
                }
                outSize.width = SizeSpec.getSize((int)widthSpec);
                if (SizeSpec.getMode((int)heightSpec) == 0x40000000 || !canMeasure) {
                    outSize.height = SizeSpec.getSize((int)heightSpec);
                    this.mReMeasureEventEventHandler = null;
                    this.mRequiresRemeasure.set(false);
                    break;
                }
                if (this.mRange != null && (SizeSpec.getMode((int)heightSpec) == Integer.MIN_VALUE || SizeSpec.getMode((int)heightSpec) == 0)) {
                    outSize.height = this.mRange.measuredSize;
                    this.mReMeasureEventEventHandler = null;
                    this.mRequiresRemeasure.set(false);
                    break;
                }
                outSize.height = 0;
                this.mRequiresRemeasure.set(true);
                this.mReMeasureEventEventHandler = reMeasureEventHandler;
            }
        }
        this.mMeasuredSize = new Size(outSize.width, outSize.height);
        this.mIsMeasured.set(true);
        if (this.mRange != null) {
            this.computeRange(this.mCurrentFirstVisiblePosition, this.mCurrentLastVisiblePosition);
        }
    }

    private int findFirstComponentPosition() {
        int size = this.mComponentTreeHolders.size();
        for (int i = 0; i < size; ++i) {
            if (!this.mComponentTreeHolders.get(i).getRenderInfo().rendersComponent()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getItemCount() {
        return this.mInternalAdapter.getItemCount();
    }

    @GuardedBy(value="this")
    private void invalidateLayoutData() {
        this.mRange = null;
        int size = this.mComponentTreeHolders.size();
        for (int i = 0; i < size; ++i) {
            this.mComponentTreeHolders.get(i).invalidateTree();
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.mInternalAdapter.notifyDataSetChanged();
        } else {
            this.mMainThreadHandler.removeCallbacks(this.mNotifyDatasetChangedRunnable);
            this.mMainThreadHandler.post(this.mNotifyDatasetChangedRunnable);
        }
    }

    @GuardedBy(value="this")
    private void initRange(int width, int height, int positionToComputeLayout, int childrenWidthSpec, int childrenHeightSpec, int scrollDirection) {
        if (positionToComputeLayout >= this.mComponentTreeHolders.size()) {
            return;
        }
        Size size = new Size();
        ComponentTreeHolder holder = this.mComponentTreeHolders.get(positionToComputeLayout);
        holder.computeLayoutSync(this.mComponentContext, childrenWidthSpec, childrenHeightSpec, size);
        int rangeSize = Math.max(this.mLayoutInfo.approximateRangeSize(size.width, size.height, width, height), 1);
        this.mRange = new RangeCalculationResult();
        this.mRange.measuredSize = scrollDirection == 0 ? size.height : size.width;
        this.mRange.estimatedViewportCount = rangeSize;
    }

    @Override
    public synchronized void setSize(int width, int height) {
        if (this.mLastWidthSpec == -1 || !this.isCompatibleSize(SizeSpec.makeSizeSpec((int)width, (int)0x40000000), SizeSpec.makeSizeSpec((int)height, (int)0x40000000))) {
            this.measure(sDummySize, SizeSpec.makeSizeSpec((int)width, (int)0x40000000), SizeSpec.makeSizeSpec((int)height, (int)0x40000000), this.mReMeasureEventEventHandler);
        }
    }

    @Override
    @UiThread
    public void mount(RecyclerView view) {
        ThreadUtils.assertMainThread();
        if (this.mMountedView == view) {
            return;
        }
        if (this.mMountedView != null) {
            this.unmount(this.mMountedView);
        }
        this.mMountedView = view;
        RecyclerView.LayoutManager layoutManager = this.mLayoutInfo.getLayoutManager();
        view.setLayoutManager(layoutManager);
        view.setAdapter(this.mInternalAdapter);
        view.addOnScrollListener((RecyclerView.OnScrollListener)this.mRangeScrollListener);
        view.addOnScrollListener((RecyclerView.OnScrollListener)this.mViewportManager.getScrollListener());
        this.mLayoutInfo.setRenderInfoCollection(this);
        this.mViewportManager.addViewportChangedListener(this.mViewportChangedListener);
        if (this.mCurrentFirstVisiblePosition != -1 && this.mCurrentFirstVisiblePosition >= 0) {
            if (layoutManager instanceof LinearLayoutManager) {
                ((LinearLayoutManager)layoutManager).scrollToPositionWithOffset(this.mCurrentFirstVisiblePosition, this.mCurrentOffset);
            } else {
                view.scrollToPosition(this.mCurrentFirstVisiblePosition);
            }
        }
        this.enableStickyHeader(this.mMountedView);
    }

    private void enableStickyHeader(RecyclerView recyclerView) {
        if (Build.VERSION.SDK_INT < 14) {
            Log.w((String)TAG, (String)"Sticky header is supported only on ICS (API14) and above");
            return;
        }
        if (recyclerView == null) {
            return;
        }
        RecyclerViewWrapper recyclerViewWrapper = RecyclerViewWrapper.getParentWrapper(recyclerView);
        if (recyclerViewWrapper == null) {
            return;
        }
        if (this.mStickyHeaderController == null) {
            this.mStickyHeaderController = new StickyHeaderController(this);
        }
        this.mStickyHeaderController.init(recyclerViewWrapper);
    }

    @Override
    @UiThread
    public void unmount(RecyclerView view) {
        ThreadUtils.assertMainThread();
        View firstView = view.getChildAt(0);
        this.mCurrentOffset = firstView != null ? (this.mLayoutInfo.getScrollDirection() == 0 ? this.mLayoutInfo.getLayoutManager().getDecoratedLeft(firstView) : this.mLayoutInfo.getLayoutManager().getDecoratedTop(firstView)) : 0;
        view.removeOnScrollListener((RecyclerView.OnScrollListener)this.mRangeScrollListener);
        view.removeOnScrollListener((RecyclerView.OnScrollListener)this.mViewportManager.getScrollListener());
        view.setAdapter(null);
        view.setLayoutManager(null);
        this.mViewportManager.removeViewportChangedListener(this.mViewportChangedListener);
        if (this.mMountedView != view) {
            return;
        }
        this.mMountedView = null;
        if (this.mStickyHeaderController != null) {
            this.mStickyHeaderController.reset();
        }
        this.mLayoutInfo.setRenderInfoCollection(null);
    }

    @UiThread
    public void scrollToPosition(int position) {
        if (this.mMountedView == null) {
            this.mCurrentFirstVisiblePosition = position;
            return;
        }
        this.mMountedView.scrollToPosition(position);
    }

    @UiThread
    public void scrollToPositionWithOffset(int position, int offset) {
        if (this.mMountedView == null || !(this.mMountedView.getLayoutManager() instanceof LinearLayoutManager)) {
            this.mCurrentFirstVisiblePosition = position;
            this.mCurrentOffset = offset;
            return;
        }
        ((LinearLayoutManager)this.mMountedView.getLayoutManager()).scrollToPositionWithOffset(position, offset);
    }

    @GuardedBy(value="this")
    private boolean isCompatibleSize(int widthSpec, int heightSpec) {
        int scrollDirection = this.mLayoutInfo.getScrollDirection();
        if (this.mLastWidthSpec != -1) {
            switch (scrollDirection) {
                case 0: {
                    return MeasureComparisonUtils.isMeasureSpecCompatible((int)this.mLastHeightSpec, (int)heightSpec, (int)this.mMeasuredSize.height);
                }
                case 1: {
                    return MeasureComparisonUtils.isMeasureSpecCompatible((int)this.mLastWidthSpec, (int)widthSpec, (int)this.mMeasuredSize.width);
                }
            }
        }
        return false;
    }

    @Override
    public int findFirstVisibleItemPosition() {
        return this.mLayoutInfo.findFirstVisibleItemPosition();
    }

    @Override
    public int findFirstFullyVisibleItemPosition() {
        return this.mLayoutInfo.findFirstFullyVisibleItemPosition();
    }

    @Override
    public int findLastVisibleItemPosition() {
        return this.mLayoutInfo.findLastVisibleItemPosition();
    }

    @Override
    public int findLastFullyVisibleItemPosition() {
        return this.mLayoutInfo.findLastFullyVisibleItemPosition();
    }

    @Override
    @UiThread
    @GuardedBy(value="this")
    public boolean isSticky(int position) {
        return this.mComponentTreeHolders.get(position).getRenderInfo().isSticky();
    }

    @Override
    @UiThread
    @GuardedBy(value="this")
    public boolean isValidPosition(int position) {
        return position >= 0 && position < this.mComponentTreeHolders.size();
    }

    @Override
    @UiThread
    public void setViewportChangedListener(@Nullable ViewportInfo.ViewportChanged viewportChangedListener) {
        this.mViewportManager.addViewportChangedListener(viewportChangedListener);
    }

    @VisibleForTesting
    void onNewVisibleRange(int firstVisiblePosition, int lastVisiblePosition) {
        this.mCurrentFirstVisiblePosition = firstVisiblePosition;
        this.mCurrentLastVisiblePosition = lastVisiblePosition;
        this.computeRange(firstVisiblePosition, lastVisiblePosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeRange(int firstVisible, int lastVisible) {
        int treeHoldersSize;
        int rangeEnd;
        int rangeStart;
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            if (!this.mIsMeasured.get() || this.mRange == null) {
                return;
            }
            if (firstVisible == -1 || lastVisible == -1) {
                lastVisible = 0;
                firstVisible = 0;
            }
            int rangeSize = Math.max(this.mRange.estimatedViewportCount, lastVisible - firstVisible);
            rangeStart = firstVisible - (int)((float)rangeSize * this.mRangeRatio);
            rangeEnd = firstVisible + rangeSize + (int)((float)rangeSize * this.mRangeRatio);
            treeHoldersSize = this.mComponentTreeHolders.size();
        }
        for (int i = 0; i < treeHoldersSize; ++i) {
            int childrenHeightSpec;
            int childrenWidthSpec;
            ComponentTreeHolder holder;
            RecyclerBinder recyclerBinder2 = this;
            synchronized (recyclerBinder2) {
                if (treeHoldersSize != this.mComponentTreeHolders.size()) {
                    return;
                }
                holder = this.mComponentTreeHolders.get(i);
                if (holder.getRenderInfo().rendersView()) {
                    continue;
                }
                childrenWidthSpec = this.getActualChildrenWidthSpec(holder);
                childrenHeightSpec = this.getActualChildrenHeightSpec(holder);
            }
            if (i >= rangeStart && i <= rangeEnd) {
                if (holder.isTreeValid()) continue;
                holder.computeLayoutAsync(this.mComponentContext, childrenWidthSpec, childrenHeightSpec);
                continue;
            }
            if (!holder.isTreeValid() || holder.getRenderInfo().isSticky()) continue;
            holder.acquireStateHandlerAndReleaseTree();
        }
    }

    @Nullable
    @VisibleForTesting
    RangeCalculationResult getRangeCalculationResult() {
        return this.mRange;
    }

    @GuardedBy(value="this")
    private int getActualChildrenWidthSpec(ComponentTreeHolder treeHolder) {
        if (this.mIsMeasured.get() && !this.mRequiresRemeasure.get()) {
            return this.mLayoutInfo.getChildWidthSpec(SizeSpec.makeSizeSpec((int)this.mMeasuredSize.width, (int)0x40000000), treeHolder.getRenderInfo());
        }
        return this.mLayoutInfo.getChildWidthSpec(this.mLastWidthSpec, treeHolder.getRenderInfo());
    }

    @GuardedBy(value="this")
    private int getActualChildrenHeightSpec(ComponentTreeHolder treeHolder) {
        if (this.mIsMeasured.get() && !this.mRequiresRemeasure.get()) {
            return this.mLayoutInfo.getChildHeightSpec(SizeSpec.makeSizeSpec((int)this.mMeasuredSize.height, (int)0x40000000), treeHolder.getRenderInfo());
        }
        return this.mLayoutInfo.getChildHeightSpec(this.mLastHeightSpec, treeHolder.getRenderInfo());
    }

    private class InternalAdapter
    extends RecyclerView.Adapter<BaseViewHolder> {
        private InternalAdapter() {
        }

        public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            ViewCreator viewCreator = RecyclerBinder.this.mRenderInfoViewCreatorController.getViewCreator(viewType);
            if (viewCreator != null) {
                View view = viewCreator.createView((Context)RecyclerBinder.this.mComponentContext);
                RecyclerView.LayoutParams layoutParams = RecyclerBinder.this.mLayoutInfo.getScrollDirection() == 1 ? new RecyclerView.LayoutParams(-1, -2) : new RecyclerView.LayoutParams(-2, -1);
                view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                return new BaseViewHolder(view, false);
            }
            LithoView lithoView = RecyclerBinder.this.mLithoViewFactory == null ? new LithoView(RecyclerBinder.this.mComponentContext, null) : RecyclerBinder.this.mLithoViewFactory.createLithoView(RecyclerBinder.this.mComponentContext);
            return new BaseViewHolder((View)lithoView, true);
        }

        public void onBindViewHolder(BaseViewHolder holder, int position) {
            ComponentTreeHolder componentTreeHolder = (ComponentTreeHolder)RecyclerBinder.this.mComponentTreeHolders.get(position);
            RenderInfo renderInfo = componentTreeHolder.getRenderInfo();
            if (renderInfo.rendersComponent()) {
                boolean isOrientationVertical;
                LithoView lithoView = (LithoView)holder.itemView;
                int childrenWidthSpec = RecyclerBinder.this.getActualChildrenWidthSpec(componentTreeHolder);
                int childrenHeightSpec = RecyclerBinder.this.getActualChildrenHeightSpec(componentTreeHolder);
                if (!componentTreeHolder.isTreeValid()) {
                    componentTreeHolder.computeLayoutSync(RecyclerBinder.this.mComponentContext, childrenWidthSpec, childrenHeightSpec, null);
                }
                boolean bl = isOrientationVertical = RecyclerBinder.this.mLayoutInfo.getScrollDirection() == 1;
                int width = SizeSpec.getMode((int)childrenWidthSpec) == 0x40000000 ? SizeSpec.getSize((int)childrenWidthSpec) : (isOrientationVertical ? -1 : -2);
                int height = SizeSpec.getMode((int)childrenHeightSpec) == 0x40000000 ? SizeSpec.getSize((int)childrenHeightSpec) : (isOrientationVertical ? -2 : -1);
                lithoView.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(width, height));
                lithoView.setComponentTree(componentTreeHolder.getComponentTree());
            } else {
                renderInfo.getViewBinder().bind(holder.itemView);
            }
        }

        public int getItemViewType(int position) {
            RenderInfo renderInfo = ((ComponentTreeHolder)RecyclerBinder.this.mComponentTreeHolders.get(position)).getRenderInfo();
            if (renderInfo.rendersComponent()) {
                return 0;
            }
            return renderInfo.getViewType();
        }

        public void onViewAttachedToWindow(BaseViewHolder holder) {
            int position = holder.getLayoutPosition();
            RecyclerBinder.this.mViewportManager.onViewportchangedAfterViewAdded(position);
        }

        public void onViewDetachedFromWindow(BaseViewHolder holder) {
            RecyclerBinder.this.mViewportManager.onViewportChangedAfterViewRemoval(holder.getLayoutPosition() + 1);
        }

        public int getItemCount() {
            return RecyclerBinder.this.mComponentTreeHolders.size();
        }

        public void onViewRecycled(BaseViewHolder holder) {
            if (holder.isLithoViewType) {
                LithoView lithoView = (LithoView)holder.itemView;
                lithoView.setComponentTree(null);
            }
        }
    }

    private class BaseViewHolder
    extends RecyclerView.ViewHolder {
        private final boolean isLithoViewType;

        public BaseViewHolder(View view, boolean isLithoViewType) {
            super(view);
            this.isLithoViewType = isLithoViewType;
        }
    }

    private class RangeScrollListener
    extends RecyclerView.OnScrollListener {
        private RangeScrollListener() {
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            if (RecyclerBinder.this.mCanPrefetchDisplayLists) {
                DisplayListUtils.prefetchDisplayLists((View)recyclerView);
            }
        }
    }

    private static class RangeCalculationResult {
        private int estimatedViewportCount;
        private int measuredSize;

        private RangeCalculationResult() {
        }
    }

    public static class Builder {
        private float rangeRatio = 4.0f;
        private LayoutInfo layoutInfo;
        @Nullable
        private LayoutHandlerFactory layoutHandlerFactory;
        private boolean canPrefetchDisplayLists;
        private boolean canCacheDrawingDisplayLists;
        private ComponentTreeHolderFactory componentTreeHolderFactory = DEFAULT_COMPONENT_TREE_HOLDER_FACTORY;
        private ComponentContext componentContext;
        private LithoViewFactory lithoViewFactory;

        public Builder rangeRatio(float rangeRatio) {
            this.rangeRatio = rangeRatio;
            return this;
        }

        public Builder layoutInfo(LayoutInfo layoutInfo) {
            this.layoutInfo = layoutInfo;
            return this;
        }

        public Builder layoutHandlerFactory(LayoutHandlerFactory layoutHandlerFactory) {
            this.layoutHandlerFactory = layoutHandlerFactory;
            return this;
        }

        public Builder lithoViewFactory(LithoViewFactory lithoViewFactory) {
            this.lithoViewFactory = lithoViewFactory;
            return this;
        }

        public Builder canPrefetchDisplayLists(boolean canPrefetchDisplayLists) {
            this.canPrefetchDisplayLists = canPrefetchDisplayLists;
            return this;
        }

        public Builder canCacheDrawingDisplayLists(boolean canCacheDrawingDisplayLists) {
            this.canCacheDrawingDisplayLists = canCacheDrawingDisplayLists;
            return this;
        }

        public Builder componentTreeHolderFactory(ComponentTreeHolderFactory componentTreeHolderFactory) {
            this.componentTreeHolderFactory = componentTreeHolderFactory;
            return this;
        }

        public RecyclerBinder build(ComponentContext c) {
            this.componentContext = c;
            if (this.layoutInfo == null) {
                this.layoutInfo = new LinearLayoutInfo((Context)c, 1, false);
            }
            return new RecyclerBinder(this);
        }
    }

    static interface ComponentTreeHolderFactory {
        public ComponentTreeHolder create(RenderInfo var1, LayoutHandler var2, boolean var3, boolean var4);
    }
}

