/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.IdRes;
import android.support.annotation.Px;
import android.support.v4.util.Pools;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SnapHelper;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.Diff;
import com.facebook.litho.EventDispatcher;
import com.facebook.litho.EventHandler;
import com.facebook.litho.HasEventDispatcher;
import com.facebook.litho.Output;
import com.facebook.litho.Size;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.Binder;
import com.facebook.litho.widget.PTRRefreshEvent;
import com.facebook.litho.widget.ReMeasureEvent;
import com.facebook.litho.widget.RecyclerEventsController;
import com.facebook.litho.widget.RecyclerSpec;
import com.facebook.litho.widget.RecyclerViewWrapper;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public final class Recycler
extends ComponentLifecycle {
    private static Recycler sInstance = null;
    static final Pools.SynchronizedPool<PTRRefreshEvent> sPTRRefreshEventPool = new Pools.SynchronizedPool(2);
    private static final Pools.SynchronizedPool<Builder> sBuilderPool = new Pools.SynchronizedPool(2);

    private Recycler() {
    }

    private static synchronized Recycler get() {
        if (sInstance == null) {
            sInstance = new Recycler();
        }
        return sInstance;
    }

    protected void onMeasure(ComponentContext c, ComponentLayout layout, int widthSpec, int heightSpec, Size measureOutput, Component _abstractImpl) {
        RecyclerImpl _impl = (RecyclerImpl)_abstractImpl;
        RecyclerSpec.onMeasure(c, layout, widthSpec, heightSpec, measureOutput, _impl.binder, _impl.canMeasure);
    }

    protected boolean canMeasure() {
        return true;
    }

    protected void onBoundsDefined(ComponentContext context, ComponentLayout layout, Component _abstractImpl) {
        RecyclerImpl _impl = (RecyclerImpl)_abstractImpl;
        RecyclerSpec.onBoundsDefined(context, layout, _impl.binder);
    }

    protected Object onCreateMountContent(ComponentContext c) {
        RecyclerViewWrapper _result = RecyclerSpec.onCreateMountContent(c);
        return _result;
    }

    protected void onPrepare(ComponentContext c, Component _abstractImpl) {
        RecyclerImpl _impl = (RecyclerImpl)_abstractImpl;
        Output onRefreshListener = this.acquireOutput();
        RecyclerSpec.onPrepare(c, _impl.refreshHandler, (Output<SwipeRefreshLayout.OnRefreshListener>)onRefreshListener);
        _impl.onRefreshListener = (SwipeRefreshLayout.OnRefreshListener)onRefreshListener.get();
        this.releaseOutput(onRefreshListener);
    }

    protected void onMount(ComponentContext c, Object recyclerViewWrapper, Component _abstractImpl) {
        RecyclerImpl _impl = (RecyclerImpl)_abstractImpl;
        RecyclerSpec.onMount(c, (RecyclerViewWrapper)((Object)recyclerViewWrapper), _impl.binder, _impl.hasFixedSize, _impl.clipToPadding, _impl.leftPadding, _impl.rightPadding, _impl.topPadding, _impl.bottomPadding, _impl.clipChildren, _impl.nestedScrollingEnabled, _impl.scrollBarStyle, _impl.itemDecoration, _impl.refreshProgressBarColor, _impl.horizontalFadingEdgeEnabled, _impl.verticalFadingEdgeEnabled, _impl.fadingEdgeLength, _impl.recyclerViewId);
    }

    protected void onBind(ComponentContext context, Object recyclerViewWrapper, Component _abstractImpl) {
        RecyclerImpl _impl = (RecyclerImpl)_abstractImpl;
        Output oldAnimator = this.acquireOutput();
        RecyclerSpec.onBind(context, (RecyclerViewWrapper)((Object)recyclerViewWrapper), _impl.itemAnimator, _impl.binder, _impl.recyclerEventsController, _impl.onScrollListeners, _impl.snapHelper, _impl.onRefreshListener, (Output<RecyclerView.ItemAnimator>)oldAnimator);
        _impl.oldAnimator = (RecyclerView.ItemAnimator)oldAnimator.get();
        this.releaseOutput(oldAnimator);
    }

    protected void onUnbind(ComponentContext context, Object recyclerViewWrapper, Component _abstractImpl) {
        RecyclerImpl _impl = (RecyclerImpl)_abstractImpl;
        RecyclerSpec.onUnbind(context, (RecyclerViewWrapper)((Object)recyclerViewWrapper), _impl.binder, _impl.recyclerEventsController, _impl.onScrollListeners, _impl.oldAnimator);
    }

    protected void onUnmount(ComponentContext context, Object recyclerViewWrapper, Component _abstractImpl) {
        RecyclerImpl _impl = (RecyclerImpl)_abstractImpl;
        RecyclerSpec.onUnmount(context, (RecyclerViewWrapper)((Object)recyclerViewWrapper), _impl.binder, _impl.itemDecoration, _impl.snapHelper);
    }

    protected boolean shouldUpdate(Component _prevAbstractImpl, Component _nextAbstractImpl) {
        RecyclerImpl _prevImpl = (RecyclerImpl)_prevAbstractImpl;
        RecyclerImpl _nextImpl = (RecyclerImpl)_nextAbstractImpl;
        Diff binder = this.acquireDiff(_prevImpl == null ? null : _prevImpl.binder, _nextImpl == null ? null : _nextImpl.binder);
        Diff hasFixedSize = this.acquireDiff(_prevImpl == null ? null : Boolean.valueOf(_prevImpl.hasFixedSize), _nextImpl == null ? null : Boolean.valueOf(_nextImpl.hasFixedSize));
        Diff clipToPadding = this.acquireDiff(_prevImpl == null ? null : Boolean.valueOf(_prevImpl.clipToPadding), _nextImpl == null ? null : Boolean.valueOf(_nextImpl.clipToPadding));
        Diff leftPadding = this.acquireDiff(_prevImpl == null ? null : Integer.valueOf(_prevImpl.leftPadding), _nextImpl == null ? null : Integer.valueOf(_nextImpl.leftPadding));
        Diff rightPadding = this.acquireDiff(_prevImpl == null ? null : Integer.valueOf(_prevImpl.rightPadding), _nextImpl == null ? null : Integer.valueOf(_nextImpl.rightPadding));
        Diff topPadding = this.acquireDiff(_prevImpl == null ? null : Integer.valueOf(_prevImpl.topPadding), _nextImpl == null ? null : Integer.valueOf(_nextImpl.topPadding));
        Diff bottomPadding = this.acquireDiff(_prevImpl == null ? null : Integer.valueOf(_prevImpl.bottomPadding), _nextImpl == null ? null : Integer.valueOf(_nextImpl.bottomPadding));
        Diff clipChildren = this.acquireDiff(_prevImpl == null ? null : Boolean.valueOf(_prevImpl.clipChildren), _nextImpl == null ? null : Boolean.valueOf(_nextImpl.clipChildren));
        Diff scrollBarStyle = this.acquireDiff(_prevImpl == null ? null : Integer.valueOf(_prevImpl.scrollBarStyle), _nextImpl == null ? null : Integer.valueOf(_nextImpl.scrollBarStyle));
        Diff itemDecoration = this.acquireDiff(_prevImpl == null ? null : _prevImpl.itemDecoration, _nextImpl == null ? null : _nextImpl.itemDecoration);
        Diff horizontalFadingEdgeEnabled = this.acquireDiff(_prevImpl == null ? null : Boolean.valueOf(_prevImpl.horizontalFadingEdgeEnabled), _nextImpl == null ? null : Boolean.valueOf(_nextImpl.horizontalFadingEdgeEnabled));
        Diff verticalFadingEdgeEnabled = this.acquireDiff(_prevImpl == null ? null : Boolean.valueOf(_prevImpl.verticalFadingEdgeEnabled), _nextImpl == null ? null : Boolean.valueOf(_nextImpl.verticalFadingEdgeEnabled));
        Diff fadingEdgeLength = this.acquireDiff(_prevImpl == null ? null : Integer.valueOf(_prevImpl.fadingEdgeLength), _nextImpl == null ? null : Integer.valueOf(_nextImpl.fadingEdgeLength));
        boolean _result = RecyclerSpec.shouldUpdate((Diff<Binder<RecyclerView>>)binder, (Diff<Boolean>)hasFixedSize, (Diff<Boolean>)clipToPadding, (Diff<Integer>)leftPadding, (Diff<Integer>)rightPadding, (Diff<Integer>)topPadding, (Diff<Integer>)bottomPadding, (Diff<Boolean>)clipChildren, (Diff<Integer>)scrollBarStyle, (Diff<RecyclerView.ItemDecoration>)itemDecoration, (Diff<Boolean>)horizontalFadingEdgeEnabled, (Diff<Boolean>)verticalFadingEdgeEnabled, (Diff<Integer>)fadingEdgeLength);
        this.releaseDiff(binder);
        this.releaseDiff(hasFixedSize);
        this.releaseDiff(clipToPadding);
        this.releaseDiff(leftPadding);
        this.releaseDiff(rightPadding);
        this.releaseDiff(topPadding);
        this.releaseDiff(bottomPadding);
        this.releaseDiff(clipChildren);
        this.releaseDiff(scrollBarStyle);
        this.releaseDiff(itemDecoration);
        this.releaseDiff(horizontalFadingEdgeEnabled);
        this.releaseDiff(verticalFadingEdgeEnabled);
        this.releaseDiff(fadingEdgeLength);
        return _result;
    }

    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.VIEW;
    }

    protected int poolSize() {
        return 15;
    }

    public boolean canMountIncrementally() {
        return true;
    }

    public boolean callsShouldUpdateOnMount() {
        return true;
    }

    public boolean isPureRender() {
        return true;
    }

    public static EventHandler getPTRRefreshEventHandler(ComponentContext context) {
        if (context.getComponentScope() == null) {
            return null;
        }
        return ((RecyclerImpl)context.getComponentScope()).pTRRefreshEventHandler;
    }

    static void dispatchPTRRefreshEvent(EventHandler _eventHandler) {
        PTRRefreshEvent _eventState = (PTRRefreshEvent)sPTRRefreshEventPool.acquire();
        if (_eventState == null) {
            _eventState = new PTRRefreshEvent();
        }
        EventDispatcher _lifecycle = _eventHandler.mHasEventDispatcher.getEventDispatcher();
        _lifecycle.dispatchOnEvent(_eventHandler, (Object)_eventState);
        sPTRRefreshEventPool.release((Object)_eventState);
    }

    private void onRemeasure(HasEventDispatcher _abstractImpl, ComponentContext c) {
        RecyclerImpl _impl = (RecyclerImpl)_abstractImpl;
        RecyclerSpec.onRemeasure(c);
    }

    public static EventHandler<ReMeasureEvent> onRemeasure(ComponentContext c) {
        return Recycler.newEventHandler((ComponentContext)c, (String)"onRemeasure", (int)946341036, (Object[])new Object[]{c});
    }

    public Object dispatchOnEvent(EventHandler eventHandler, Object eventState) {
        int id = eventHandler.id;
        switch (id) {
            case 946341036: {
                ReMeasureEvent _event = (ReMeasureEvent)eventState;
                this.onRemeasure(eventHandler.mHasEventDispatcher, (ComponentContext)eventHandler.params[0]);
                return null;
            }
        }
        return null;
    }

    protected static void onUpdateMeasureAsync(ComponentContext c) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        OnUpdateMeasureStateUpdate _stateUpdate = ((RecyclerImpl)_component).createOnUpdateMeasureStateUpdate();
        c.updateStateAsync((ComponentLifecycle.StateUpdate)_stateUpdate);
    }

    protected static void onUpdateMeasure(ComponentContext c) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        OnUpdateMeasureStateUpdate _stateUpdate = ((RecyclerImpl)_component).createOnUpdateMeasureStateUpdate();
        c.updateState((ComponentLifecycle.StateUpdate)_stateUpdate);
    }

    public static Builder create(ComponentContext context) {
        return Recycler.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Builder builder = (Builder)((Object)sBuilderPool.acquire());
        if (builder == null) {
            builder = new Builder();
        }
        builder.init(context, defStyleAttr, defStyleRes, new RecyclerImpl());
        return builder;
    }

    public static class Builder
    extends Component.Builder<Recycler, Builder> {
        private static final String[] REQUIRED_PROPS_NAMES = new String[]{"binder"};
        private static final int REQUIRED_PROPS_COUNT = 1;
        RecyclerImpl mRecyclerImpl;
        ComponentContext mContext;
        private BitSet mRequired = new BitSet(1);

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, RecyclerImpl recyclerImpl) {
            super.init(context, defStyleAttr, defStyleRes, (Component)recyclerImpl);
            this.mRecyclerImpl = recyclerImpl;
            this.mContext = context;
            this.mRequired.clear();
        }

        public Builder binder(Binder<RecyclerView> binder) {
            this.mRecyclerImpl.binder = binder;
            this.mRequired.set(0);
            return this;
        }

        public Builder canMeasure(boolean canMeasure) {
            this.mRecyclerImpl.canMeasure = canMeasure;
            return this;
        }

        public Builder refreshHandler(EventHandler refreshHandler) {
            this.mRecyclerImpl.refreshHandler = refreshHandler;
            return this;
        }

        public Builder hasFixedSize(boolean hasFixedSize) {
            this.mRecyclerImpl.hasFixedSize = hasFixedSize;
            return this;
        }

        public Builder clipToPadding(boolean clipToPadding) {
            this.mRecyclerImpl.clipToPadding = clipToPadding;
            return this;
        }

        public Builder leftPadding(int leftPadding) {
            this.mRecyclerImpl.leftPadding = leftPadding;
            return this;
        }

        public Builder rightPadding(int rightPadding) {
            this.mRecyclerImpl.rightPadding = rightPadding;
            return this;
        }

        public Builder topPadding(int topPadding) {
            this.mRecyclerImpl.topPadding = topPadding;
            return this;
        }

        public Builder bottomPadding(int bottomPadding) {
            this.mRecyclerImpl.bottomPadding = bottomPadding;
            return this;
        }

        public Builder clipChildren(boolean clipChildren) {
            this.mRecyclerImpl.clipChildren = clipChildren;
            return this;
        }

        public Builder nestedScrollingEnabled(boolean nestedScrollingEnabled) {
            this.mRecyclerImpl.nestedScrollingEnabled = nestedScrollingEnabled;
            return this;
        }

        public Builder scrollBarStyle(int scrollBarStyle) {
            this.mRecyclerImpl.scrollBarStyle = scrollBarStyle;
            return this;
        }

        public Builder itemDecoration(RecyclerView.ItemDecoration itemDecoration) {
            this.mRecyclerImpl.itemDecoration = itemDecoration;
            return this;
        }

        public Builder refreshProgressBarColor(@ColorInt int refreshProgressBarColor) {
            this.mRecyclerImpl.refreshProgressBarColor = refreshProgressBarColor;
            return this;
        }

        public Builder refreshProgressBarColorRes(@ColorRes int resId) {
            this.mRecyclerImpl.refreshProgressBarColor = this.resolveColorRes(resId);
            return this;
        }

        public Builder refreshProgressBarColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mRecyclerImpl.refreshProgressBarColor = this.resolveColorAttr(attrResId, defResId);
            return this;
        }

        public Builder refreshProgressBarColorAttr(@AttrRes int attrResId) {
            this.mRecyclerImpl.refreshProgressBarColor = this.resolveColorAttr(attrResId, 0);
            return this;
        }

        public Builder horizontalFadingEdgeEnabled(boolean horizontalFadingEdgeEnabled) {
            this.mRecyclerImpl.horizontalFadingEdgeEnabled = horizontalFadingEdgeEnabled;
            return this;
        }

        public Builder verticalFadingEdgeEnabled(boolean verticalFadingEdgeEnabled) {
            this.mRecyclerImpl.verticalFadingEdgeEnabled = verticalFadingEdgeEnabled;
            return this;
        }

        public Builder fadingEdgeLengthPx(@Px int fadingEdgeLength) {
            this.mRecyclerImpl.fadingEdgeLength = fadingEdgeLength;
            return this;
        }

        public Builder fadingEdgeLengthRes(@DimenRes int resId) {
            this.mRecyclerImpl.fadingEdgeLength = this.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder fadingEdgeLengthAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mRecyclerImpl.fadingEdgeLength = this.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder fadingEdgeLengthAttr(@AttrRes int attrResId) {
            this.mRecyclerImpl.fadingEdgeLength = this.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder fadingEdgeLengthDip(@Dimension(unit=0) float dip) {
            this.mRecyclerImpl.fadingEdgeLength = this.dipsToPixels(dip);
            return this;
        }

        public Builder recyclerViewId(@IdRes int recyclerViewId) {
            this.mRecyclerImpl.recyclerViewId = recyclerViewId;
            return this;
        }

        public Builder itemAnimator(RecyclerView.ItemAnimator itemAnimator) {
            this.mRecyclerImpl.itemAnimator = itemAnimator;
            return this;
        }

        public Builder recyclerEventsController(RecyclerEventsController recyclerEventsController) {
            this.mRecyclerImpl.recyclerEventsController = recyclerEventsController;
            return this;
        }

        public Builder onScrollListener(RecyclerView.OnScrollListener onScrollListener) {
            if (onScrollListener == null) {
                return this;
            }
            if (this.mRecyclerImpl.onScrollListeners == null) {
                this.mRecyclerImpl.onScrollListeners = new ArrayList<RecyclerView.OnScrollListener>();
            }
            this.mRecyclerImpl.onScrollListeners.add(onScrollListener);
            return this;
        }

        public Builder onScrollListeners(List<RecyclerView.OnScrollListener> onScrollListeners) {
            if (onScrollListeners == null) {
                return this;
            }
            if (this.mRecyclerImpl.onScrollListeners == null || this.mRecyclerImpl.onScrollListeners.isEmpty()) {
                this.mRecyclerImpl.onScrollListeners = onScrollListeners;
            } else {
                this.mRecyclerImpl.onScrollListeners.addAll(onScrollListeners);
            }
            return this;
        }

        public Builder snapHelper(SnapHelper snapHelper) {
            this.mRecyclerImpl.snapHelper = snapHelper;
            return this;
        }

        public Builder pTRRefreshEventHandler(EventHandler pTRRefreshEventHandler) {
            this.mRecyclerImpl.pTRRefreshEventHandler = pTRRefreshEventHandler;
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public Component<Recycler> build() {
            Builder.checkArgs((int)1, (BitSet)this.mRequired, (String[])REQUIRED_PROPS_NAMES);
            RecyclerImpl recyclerImpl = this.mRecyclerImpl;
            this.release();
            return recyclerImpl;
        }

        protected void release() {
            super.release();
            this.mRecyclerImpl = null;
            this.mContext = null;
            sBuilderPool.release((Object)this);
        }
    }

    private static class OnUpdateMeasureStateUpdate
    implements ComponentLifecycle.StateUpdate {
        OnUpdateMeasureStateUpdate() {
        }

        public void updateState(ComponentLifecycle.StateContainer stateContainer, Component newComponent) {
            ComponentLifecycle.StateContainer stateContainerImpl = stateContainer;
            RecyclerImpl newComponentStateUpdate = (RecyclerImpl)newComponent;
            RecyclerSpec.onUpdateMeasure();
        }
    }

    static class RecyclerImpl
    extends Component<Recycler>
    implements Cloneable {
        @Prop(resType=ResType.NONE, optional=false)
        Binder<RecyclerView> binder;
        @Prop(resType=ResType.NONE, optional=true)
        boolean canMeasure;
        @Prop(resType=ResType.NONE, optional=true)
        EventHandler refreshHandler;
        @Prop(resType=ResType.NONE, optional=true)
        boolean hasFixedSize = true;
        @Prop(resType=ResType.NONE, optional=true)
        boolean clipToPadding = true;
        @Prop(resType=ResType.NONE, optional=true)
        int leftPadding = 0;
        @Prop(resType=ResType.NONE, optional=true)
        int rightPadding = 0;
        @Prop(resType=ResType.NONE, optional=true)
        int topPadding = 0;
        @Prop(resType=ResType.NONE, optional=true)
        int bottomPadding = 0;
        @Prop(resType=ResType.NONE, optional=true)
        boolean clipChildren = true;
        @Prop(resType=ResType.NONE, optional=true)
        boolean nestedScrollingEnabled = true;
        @Prop(resType=ResType.NONE, optional=true)
        int scrollBarStyle = 0;
        @Prop(resType=ResType.NONE, optional=true)
        RecyclerView.ItemDecoration itemDecoration;
        @Prop(resType=ResType.COLOR, optional=true)
        int refreshProgressBarColor = -16777216;
        @Prop(resType=ResType.NONE, optional=true)
        boolean horizontalFadingEdgeEnabled;
        @Prop(resType=ResType.NONE, optional=true)
        boolean verticalFadingEdgeEnabled;
        @Prop(resType=ResType.DIMEN_SIZE, optional=true)
        int fadingEdgeLength;
        @Prop(resType=ResType.NONE, optional=true)
        int recyclerViewId = -1;
        @Prop(resType=ResType.NONE, optional=true)
        RecyclerView.ItemAnimator itemAnimator = RecyclerSpec.itemAnimator;
        @Prop(resType=ResType.NONE, optional=true)
        RecyclerEventsController recyclerEventsController;
        @Prop(resType=ResType.NONE, optional=true)
        List<RecyclerView.OnScrollListener> onScrollListeners;
        @Prop(resType=ResType.NONE, optional=true)
        SnapHelper snapHelper;
        SwipeRefreshLayout.OnRefreshListener onRefreshListener;
        RecyclerView.ItemAnimator oldAnimator;
        EventHandler pTRRefreshEventHandler;

        private RecyclerImpl() {
            super((ComponentLifecycle)Recycler.get());
        }

        public String getSimpleName() {
            return "Recycler";
        }

        public boolean isEquivalentTo(Component<?> other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            RecyclerImpl recyclerImpl = (RecyclerImpl)other;
            if (this.getId() == recyclerImpl.getId()) {
                return true;
            }
            if (this.binder != null ? !this.binder.equals(recyclerImpl.binder) : recyclerImpl.binder != null) {
                return false;
            }
            if (this.canMeasure != recyclerImpl.canMeasure) {
                return false;
            }
            if (this.refreshHandler != null ? !this.refreshHandler.equals(recyclerImpl.refreshHandler) : recyclerImpl.refreshHandler != null) {
                return false;
            }
            if (this.hasFixedSize != recyclerImpl.hasFixedSize) {
                return false;
            }
            if (this.clipToPadding != recyclerImpl.clipToPadding) {
                return false;
            }
            if (this.leftPadding != recyclerImpl.leftPadding) {
                return false;
            }
            if (this.rightPadding != recyclerImpl.rightPadding) {
                return false;
            }
            if (this.topPadding != recyclerImpl.topPadding) {
                return false;
            }
            if (this.bottomPadding != recyclerImpl.bottomPadding) {
                return false;
            }
            if (this.clipChildren != recyclerImpl.clipChildren) {
                return false;
            }
            if (this.nestedScrollingEnabled != recyclerImpl.nestedScrollingEnabled) {
                return false;
            }
            if (this.scrollBarStyle != recyclerImpl.scrollBarStyle) {
                return false;
            }
            if (this.itemDecoration != null ? !this.itemDecoration.equals(recyclerImpl.itemDecoration) : recyclerImpl.itemDecoration != null) {
                return false;
            }
            if (this.refreshProgressBarColor != recyclerImpl.refreshProgressBarColor) {
                return false;
            }
            if (this.horizontalFadingEdgeEnabled != recyclerImpl.horizontalFadingEdgeEnabled) {
                return false;
            }
            if (this.verticalFadingEdgeEnabled != recyclerImpl.verticalFadingEdgeEnabled) {
                return false;
            }
            if (this.fadingEdgeLength != recyclerImpl.fadingEdgeLength) {
                return false;
            }
            if (this.recyclerViewId != recyclerImpl.recyclerViewId) {
                return false;
            }
            if (this.itemAnimator != null ? !this.itemAnimator.equals(recyclerImpl.itemAnimator) : recyclerImpl.itemAnimator != null) {
                return false;
            }
            if (this.recyclerEventsController != null ? !this.recyclerEventsController.equals(recyclerImpl.recyclerEventsController) : recyclerImpl.recyclerEventsController != null) {
                return false;
            }
            if (this.onScrollListeners != null ? !this.onScrollListeners.equals(recyclerImpl.onScrollListeners) : recyclerImpl.onScrollListeners != null) {
                return false;
            }
            return !(this.snapHelper != null ? !this.snapHelper.equals(recyclerImpl.snapHelper) : recyclerImpl.snapHelper != null);
        }

        protected void copyInterStageImpl(Component<Recycler> impl) {
            RecyclerImpl recyclerImpl = (RecyclerImpl)impl;
            this.onRefreshListener = recyclerImpl.onRefreshListener;
            this.oldAnimator = recyclerImpl.oldAnimator;
        }

        private OnUpdateMeasureStateUpdate createOnUpdateMeasureStateUpdate() {
            return new OnUpdateMeasureStateUpdate();
        }

        public RecyclerImpl makeShallowCopy() {
            RecyclerImpl component = (RecyclerImpl)super.makeShallowCopy();
            component.onRefreshListener = null;
            component.oldAnimator = null;
            return component;
        }
    }
}

