/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.graphics.drawable.Drawable;
import android.support.annotation.AttrRes;
import android.support.annotation.DrawableRes;
import android.support.v4.util.Pools;
import android.widget.ImageView;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.Diff;
import com.facebook.litho.DrawableMatrix;
import com.facebook.litho.MatrixDrawable;
import com.facebook.litho.Output;
import com.facebook.litho.Size;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.ImageSpec;
import java.util.BitSet;

public final class Image
extends ComponentLifecycle {
    private static Image sInstance = null;
    private static final Pools.SynchronizedPool<Builder> sBuilderPool = new Pools.SynchronizedPool(2);

    private Image() {
    }

    private static synchronized Image get() {
        if (sInstance == null) {
            sInstance = new Image();
        }
        return sInstance;
    }

    protected void onLoadStyle(ComponentContext c, Component _abstractImpl) {
        ImageImpl _impl = (ImageImpl)_abstractImpl;
        Output drawable = this.acquireOutput();
        Output scaleType = this.acquireOutput();
        ImageSpec.onLoadStyle(c, (Output<Drawable>)drawable, (Output<ImageView.ScaleType>)scaleType);
        if (drawable.get() != null) {
            _impl.drawable = (Drawable)drawable.get();
        }
        this.releaseOutput(drawable);
        if (scaleType.get() != null) {
            _impl.scaleType = (ImageView.ScaleType)scaleType.get();
        }
        this.releaseOutput(scaleType);
    }

    protected void onMeasure(ComponentContext c, ComponentLayout layout, int widthSpec, int heightSpec, Size size, Component _abstractImpl) {
        ImageImpl _impl = (ImageImpl)_abstractImpl;
        ImageSpec.onMeasure(c, layout, widthSpec, heightSpec, size, _impl.drawable);
    }

    protected boolean canMeasure() {
        return true;
    }

    protected void onBoundsDefined(ComponentContext c, ComponentLayout layout, Component _abstractImpl) {
        ImageImpl _impl = (ImageImpl)_abstractImpl;
        Output drawableMatrix = this.acquireOutput();
        Output drawableWidth = this.acquireOutput();
        Output drawableHeight = this.acquireOutput();
        ImageSpec.onBoundsDefined(c, layout, _impl.drawable, _impl.scaleType, (Output<DrawableMatrix>)drawableMatrix, (Output<Integer>)drawableWidth, (Output<Integer>)drawableHeight);
        _impl.drawableMatrix = (DrawableMatrix)drawableMatrix.get();
        this.releaseOutput(drawableMatrix);
        _impl.drawableWidth = (Integer)drawableWidth.get();
        this.releaseOutput(drawableWidth);
        _impl.drawableHeight = (Integer)drawableHeight.get();
        this.releaseOutput(drawableHeight);
    }

    protected Object onCreateMountContent(ComponentContext c) {
        MatrixDrawable _result = ImageSpec.onCreateMountContent(c);
        return _result;
    }

    protected void onMount(ComponentContext c, Object matrixDrawable, Component _abstractImpl) {
        ImageImpl _impl = (ImageImpl)_abstractImpl;
        ImageSpec.onMount(c, (MatrixDrawable)matrixDrawable, _impl.drawable, _impl.drawableMatrix);
    }

    protected void onBind(ComponentContext c, Object mountedDrawable, Component _abstractImpl) {
        ImageImpl _impl = (ImageImpl)_abstractImpl;
        ImageSpec.onBind(c, (MatrixDrawable)mountedDrawable, _impl.drawableWidth, _impl.drawableHeight);
    }

    protected void onUnmount(ComponentContext c, Object convertDrawable, Component _abstractImpl) {
        ImageImpl _impl = (ImageImpl)_abstractImpl;
        ImageSpec.onUnmount(c, (MatrixDrawable)convertDrawable, _impl.drawable);
    }

    protected boolean shouldUpdate(Component _prevAbstractImpl, Component _nextAbstractImpl) {
        ImageImpl _prevImpl = (ImageImpl)_prevAbstractImpl;
        ImageImpl _nextImpl = (ImageImpl)_nextAbstractImpl;
        Diff scaleType = this.acquireDiff(_prevImpl == null ? null : _prevImpl.scaleType, _nextImpl == null ? null : _nextImpl.scaleType);
        Diff drawable = this.acquireDiff(_prevImpl == null ? null : _prevImpl.drawable, _nextImpl == null ? null : _nextImpl.drawable);
        boolean _result = ImageSpec.shouldUpdate((Diff<ImageView.ScaleType>)scaleType, (Diff<Drawable>)drawable);
        this.releaseDiff(scaleType);
        this.releaseDiff(drawable);
        return _result;
    }

    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.DRAWABLE;
    }

    protected int poolSize() {
        return 30;
    }

    protected boolean isMountSizeDependent() {
        return true;
    }

    public boolean callsShouldUpdateOnMount() {
        return true;
    }

    public boolean isPureRender() {
        return true;
    }

    public static Builder create(ComponentContext context) {
        return Image.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Builder builder = (Builder)((Object)sBuilderPool.acquire());
        if (builder == null) {
            builder = new Builder();
        }
        builder.init(context, defStyleAttr, defStyleRes, new ImageImpl());
        return builder;
    }

    public static class Builder
    extends Component.Builder<Image, Builder> {
        private static final String[] REQUIRED_PROPS_NAMES = new String[]{"drawable"};
        private static final int REQUIRED_PROPS_COUNT = 1;
        ImageImpl mImageImpl;
        ComponentContext mContext;
        private BitSet mRequired = new BitSet(1);

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, ImageImpl imageImpl) {
            super.init(context, defStyleAttr, defStyleRes, (Component)imageImpl);
            this.mImageImpl = imageImpl;
            this.mContext = context;
            this.mRequired.clear();
        }

        public Builder drawable(Drawable drawable) {
            this.mImageImpl.drawable = drawable;
            this.mRequired.set(0);
            return this;
        }

        public Builder drawableRes(@DrawableRes int resId) {
            this.mImageImpl.drawable = this.resolveDrawableRes(resId);
            this.mRequired.set(0);
            return this;
        }

        public Builder drawableAttr(@AttrRes int attrResId, @DrawableRes int defResId) {
            this.mImageImpl.drawable = this.resolveDrawableAttr(attrResId, defResId);
            this.mRequired.set(0);
            return this;
        }

        public Builder drawableAttr(@AttrRes int attrResId) {
            this.mImageImpl.drawable = this.resolveDrawableAttr(attrResId, 0);
            this.mRequired.set(0);
            return this;
        }

        public Builder scaleType(ImageView.ScaleType scaleType) {
            this.mImageImpl.scaleType = scaleType;
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public Component<Image> build() {
            Builder.checkArgs((int)1, (BitSet)this.mRequired, (String[])REQUIRED_PROPS_NAMES);
            ImageImpl imageImpl = this.mImageImpl;
            this.release();
            return imageImpl;
        }

        protected void release() {
            super.release();
            this.mImageImpl = null;
            this.mContext = null;
            sBuilderPool.release((Object)this);
        }
    }

    static class ImageImpl
    extends Component<Image>
    implements Cloneable {
        @Prop(resType=ResType.DRAWABLE, optional=false)
        Drawable drawable;
        @Prop(resType=ResType.NONE, optional=true)
        ImageView.ScaleType scaleType;
        DrawableMatrix drawableMatrix;
        Integer drawableWidth;
        Integer drawableHeight;

        private ImageImpl() {
            super((ComponentLifecycle)Image.get());
        }

        public String getSimpleName() {
            return "Image";
        }

        public boolean isEquivalentTo(Component<?> other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ImageImpl imageImpl = (ImageImpl)other;
            if (this.getId() == imageImpl.getId()) {
                return true;
            }
            if (this.drawable != null ? !this.drawable.equals(imageImpl.drawable) : imageImpl.drawable != null) {
                return false;
            }
            return !(this.scaleType != null ? !this.scaleType.equals((Object)imageImpl.scaleType) : imageImpl.scaleType != null);
        }

        protected void copyInterStageImpl(Component<Image> impl) {
            ImageImpl imageImpl = (ImageImpl)impl;
            this.drawableMatrix = imageImpl.drawableMatrix;
            this.drawableWidth = imageImpl.drawableWidth;
            this.drawableHeight = imageImpl.drawableHeight;
        }

        public ImageImpl makeShallowCopy() {
            ImageImpl component = (ImageImpl)super.makeShallowCopy();
            component.drawableMatrix = null;
            component.drawableWidth = null;
            component.drawableHeight = null;
            return component;
        }
    }
}

