/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.util.Pools;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.HorizontalScrollView;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.LithoView;
import com.facebook.litho.Output;
import com.facebook.litho.R;
import com.facebook.litho.Size;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.StateValue;
import com.facebook.litho.annotations.FromMeasure;
import com.facebook.litho.annotations.MountSpec;
import com.facebook.litho.annotations.OnBoundsDefined;
import com.facebook.litho.annotations.OnCreateInitialState;
import com.facebook.litho.annotations.OnMount;
import com.facebook.litho.annotations.OnUnmount;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropDefault;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.annotations.State;

@MountSpec
class HorizontalScrollSpec {
    @PropDefault
    static final boolean scrollbarEnabled = true;
    private static final Pools.SynchronizedPool<Size> sSizePool = new Pools.SynchronizedPool(2);

    HorizontalScrollSpec() {
    }

    static void onLoadStyle(ComponentContext c, Output<Boolean> scrollbarEnabled) {
        TypedArray a = c.obtainStyledAttributes(R.styleable.HorizontalScroll, 0);
        int size = a.getIndexCount();
        for (int i = 0; i < size; ++i) {
            int attr = a.getIndex(i);
            if (attr != R.styleable.HorizontalScroll_android_scrollbars) continue;
            scrollbarEnabled.set((Object)(a.getInt(attr, 0) != 0 ? 1 : 0));
        }
        a.recycle();
    }

    static void onPrepare(ComponentContext context, @Prop Component<?> contentProps, Output<ComponentTree> contentComponent) {
        contentComponent.set((Object)ComponentTree.create((ComponentContext)context, contentProps).incrementalMount(false).build());
    }

    static void onMeasure(ComponentContext context, ComponentLayout layout, int widthSpec, int heightSpec, Size size, ComponentTree contentComponent, Output<Integer> measuredComponentWidth, Output<Integer> measuredComponentHeight) {
        Size contentSize = HorizontalScrollSpec.acquireSize();
        contentComponent.setSizeSpec(SizeSpec.makeSizeSpec((int)0, (int)0), heightSpec, contentSize);
        int measuredWidth = contentSize.width;
        int measuredHeight = contentSize.height;
        HorizontalScrollSpec.releaseSize(contentSize);
        contentSize = null;
        measuredComponentWidth.set((Object)measuredWidth);
        measuredComponentHeight.set((Object)measuredHeight);
        size.width = SizeSpec.getMode((int)widthSpec) == 0 ? measuredWidth : SizeSpec.getSize((int)widthSpec);
        size.height = measuredHeight;
    }

    @OnBoundsDefined
    static void onBoundsDefined(ComponentContext context, ComponentLayout layout, ComponentTree contentComponent, @FromMeasure Integer measuredComponentWidth, @FromMeasure Integer measuredComponentHeight, Output<Integer> componentWidth, Output<Integer> componentHeight) {
        if (measuredComponentWidth != null && measuredComponentHeight != null) {
            componentWidth.set((Object)measuredComponentWidth);
            componentHeight.set((Object)measuredComponentHeight);
        } else {
            Size contentSize = HorizontalScrollSpec.acquireSize();
            contentComponent.setSizeSpec(SizeSpec.makeSizeSpec((int)0, (int)0), SizeSpec.makeSizeSpec((int)layout.getHeight(), (int)0x40000000), contentSize);
            int measuredWidth = contentSize.width;
            int measuredHeight = contentSize.height;
            HorizontalScrollSpec.releaseSize(contentSize);
            contentSize = null;
            componentWidth.set((Object)measuredWidth);
            componentHeight.set((Object)measuredHeight);
        }
    }

    static HorizontalScrollLithoView onCreateMountContent(ComponentContext c) {
        return new HorizontalScrollLithoView((Context)c);
    }

    @OnMount
    static void onMount(ComponentContext context, final HorizontalScrollLithoView horizontalScrollLithoView, @Prop(optional=true, resType=ResType.BOOL) boolean scrollbarEnabled, final @State ScrollPosition lastScrollPosition, ComponentTree contentComponent, int componentWidth, int componentHeight) {
        horizontalScrollLithoView.setHorizontalScrollBarEnabled(scrollbarEnabled);
        horizontalScrollLithoView.mount(contentComponent, componentWidth, componentHeight);
        ViewTreeObserver viewTreeObserver = horizontalScrollLithoView.getViewTreeObserver();
        viewTreeObserver.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                horizontalScrollLithoView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                horizontalScrollLithoView.setScrollX(lastScrollPosition.x);
                return true;
            }
        });
        viewTreeObserver.addOnScrollChangedListener(new ViewTreeObserver.OnScrollChangedListener(){

            public void onScrollChanged() {
                lastScrollPosition.x = horizontalScrollLithoView.getScrollX();
            }
        });
    }

    @OnUnmount
    static void onUnmount(ComponentContext context, HorizontalScrollLithoView mountedView) {
        mountedView.unmount();
    }

    @OnCreateInitialState
    static void onCreateInitialState(ComponentContext c, StateValue<ScrollPosition> lastScrollPosition) {
        lastScrollPosition.set((Object)new ScrollPosition());
    }

    private static Size acquireSize() {
        Size size = (Size)sSizePool.acquire();
        if (size == null) {
            size = new Size();
        }
        return size;
    }

    private static void releaseSize(Size size) {
        sSizePool.release((Object)size);
    }

    static class ScrollPosition {
        int x = 0;

        ScrollPosition() {
        }
    }

    static class HorizontalScrollLithoView
    extends HorizontalScrollView {
        private final LithoView mLithoView;
        private int mComponentWidth;
        private int mComponentHeight;

        public HorizontalScrollLithoView(Context context) {
            super(context);
            this.mLithoView = new LithoView(context);
            this.addView((View)this.mLithoView);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.mLithoView.measure(View.MeasureSpec.makeMeasureSpec((int)this.mComponentWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.mComponentHeight, (int)0x40000000));
            this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
        }

        void mount(ComponentTree component, int width, int height) {
            this.mLithoView.setComponentTree(component);
            this.mComponentWidth = width;
            this.mComponentHeight = height;
        }

        void unmount() {
            this.mLithoView.setComponentTree(null);
            this.mComponentWidth = 0;
            this.mComponentHeight = 0;
        }
    }
}

