/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.support.v4.util.Pools;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.LayoutHandler;
import com.facebook.litho.Size;
import com.facebook.litho.StateHandler;
import com.facebook.litho.widget.RenderInfo;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ComponentTreeHolder {
    private static final Pools.SynchronizedPool<ComponentTreeHolder> sComponentTreeHoldersPool = new Pools.SynchronizedPool(8);
    @GuardedBy(value="this")
    private ComponentTree mComponentTree;
    @GuardedBy(value="this")
    private StateHandler mStateHandler;
    @GuardedBy(value="this")
    private RenderInfo mRenderInfo;
    private boolean mIsTreeValid;
    private LayoutHandler mLayoutHandler;
    private boolean mCanPrefetchDisplayLists;
    private boolean mCanCacheDrawingDisplayLists;

    public static ComponentTreeHolder acquire(RenderInfo renderInfo, LayoutHandler layoutHandler, boolean canPrefetchDisplayLists, boolean canCacheDrawingDisplayLists) {
        ComponentTreeHolder componentTreeHolder = (ComponentTreeHolder)sComponentTreeHoldersPool.acquire();
        if (componentTreeHolder == null) {
            componentTreeHolder = new ComponentTreeHolder();
        }
        componentTreeHolder.mRenderInfo = renderInfo;
        componentTreeHolder.mLayoutHandler = layoutHandler;
        componentTreeHolder.mCanPrefetchDisplayLists = canPrefetchDisplayLists;
        componentTreeHolder.mCanCacheDrawingDisplayLists = canCacheDrawingDisplayLists;
        return componentTreeHolder;
    }

    public synchronized void acquireStateHandlerAndReleaseTree() {
        this.acquireStateHandler();
        this.releaseTree();
    }

    synchronized void invalidateTree() {
        this.mIsTreeValid = false;
    }

    synchronized void clearStateHandler() {
        this.mStateHandler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeLayoutSync(ComponentContext context, int widthSpec, int heightSpec, Size size) {
        Component component;
        ComponentTree componentTree;
        ComponentTreeHolder componentTreeHolder = this;
        synchronized (componentTreeHolder) {
            if (this.mRenderInfo.rendersView()) {
                return;
            }
            this.ensureComponentTree(context);
            componentTree = this.mComponentTree;
            component = this.mRenderInfo.getComponent();
        }
        componentTree.setRootAndSizeSpec(component, widthSpec, heightSpec, size);
        componentTreeHolder = this;
        synchronized (componentTreeHolder) {
            if (componentTree == this.mComponentTree && component == this.mRenderInfo.getComponent()) {
                this.mIsTreeValid = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeLayoutAsync(ComponentContext context, int widthSpec, int heightSpec) {
        Component component;
        ComponentTree componentTree;
        ComponentTreeHolder componentTreeHolder = this;
        synchronized (componentTreeHolder) {
            if (this.mRenderInfo.rendersView()) {
                return;
            }
            this.ensureComponentTree(context);
            componentTree = this.mComponentTree;
            component = this.mRenderInfo.getComponent();
        }
        componentTree.setRootAndSizeSpecAsync(component, widthSpec, heightSpec);
        componentTreeHolder = this;
        synchronized (componentTreeHolder) {
            if (this.mComponentTree == componentTree && component == this.mRenderInfo.getComponent()) {
                this.mIsTreeValid = true;
            }
        }
    }

    public synchronized RenderInfo getRenderInfo() {
        return this.mRenderInfo;
    }

    public synchronized boolean isTreeValid() {
        return this.mIsTreeValid;
    }

    public synchronized ComponentTree getComponentTree() {
        return this.mComponentTree;
    }

    public synchronized void setRenderInfo(RenderInfo renderInfo) {
        this.invalidateTree();
        this.mRenderInfo = renderInfo;
    }

    public synchronized void release() {
        this.releaseTree();
        this.clearStateHandler();
        this.mRenderInfo = null;
        this.mLayoutHandler = null;
        this.mCanPrefetchDisplayLists = false;
        this.mCanCacheDrawingDisplayLists = false;
        sComponentTreeHoldersPool.release((Object)this);
    }

    @GuardedBy(value="this")
    private void ensureComponentTree(ComponentContext context) {
        if (this.mComponentTree == null) {
            Object clipChildrenAttr = this.mRenderInfo.getCustomAttribute("clip_children");
            boolean clipChildren = clipChildrenAttr == null ? true : (Boolean)clipChildrenAttr;
            this.mComponentTree = ComponentTree.create((ComponentContext)context, (Component)this.mRenderInfo.getComponent()).layoutThreadHandler(this.mLayoutHandler).stateHandler(this.mStateHandler).canPrefetchDisplayLists(this.mCanPrefetchDisplayLists).canCacheDrawingDisplayLists(this.mCanCacheDrawingDisplayLists).shouldClipChildren(clipChildren).build();
        }
    }

    @GuardedBy(value="this")
    private void releaseTree() {
        if (this.mComponentTree != null) {
            this.mComponentTree.release();
            this.mComponentTree = null;
        }
        this.mIsTreeValid = false;
    }

    @GuardedBy(value="this")
    private void acquireStateHandler() {
        if (this.mComponentTree == null) {
            return;
        }
        this.mStateHandler = this.mComponentTree.getStateHandler();
    }
}

