/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;

class CardClipDrawable
extends Drawable {
    private final Paint mCornerPaint;
    private final Path mCornerPath = new Path();
    static final int NONE = 0;
    static final int TOP_LEFT = 1;
    static final int TOP_RIGHT = 2;
    static final int BOTTOM_LEFT = 4;
    static final int BOTTOM_RIGHT = 8;
    private int mDisableClipCorners = 0;
    private float mCornerRadius;
    private boolean mDirty = true;

    CardClipDrawable() {
        this.mCornerPaint = new Paint(5);
    }

    public void setAlpha(int alpha) {
        this.mCornerPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mCornerPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    void setDisableClip(int edge) {
        if ((this.mDisableClipCorners & edge) != 0) {
            return;
        }
        this.mDisableClipCorners |= edge;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        int saved;
        if (this.mDirty) {
            this.buildClippingCorners();
            this.mDirty = false;
        }
        Rect bounds = this.getBounds();
        if ((this.mDisableClipCorners & 1) == 0) {
            saved = canvas.save();
            canvas.translate((float)bounds.left, (float)bounds.top);
            canvas.drawPath(this.mCornerPath, this.mCornerPaint);
            canvas.restoreToCount(saved);
        }
        if ((this.mDisableClipCorners & 8) == 0) {
            saved = canvas.save();
            canvas.translate((float)bounds.right, (float)bounds.bottom);
            canvas.rotate(180.0f);
            canvas.drawPath(this.mCornerPath, this.mCornerPaint);
            canvas.restoreToCount(saved);
        }
        if ((this.mDisableClipCorners & 4) == 0) {
            saved = canvas.save();
            canvas.translate((float)bounds.left, (float)bounds.bottom);
            canvas.rotate(270.0f);
            canvas.drawPath(this.mCornerPath, this.mCornerPaint);
            canvas.restoreToCount(saved);
        }
        if ((this.mDisableClipCorners & 2) == 0) {
            saved = canvas.save();
            canvas.translate((float)bounds.right, (float)bounds.top);
            canvas.rotate(90.0f);
            canvas.drawPath(this.mCornerPath, this.mCornerPaint);
            canvas.restoreToCount(saved);
        }
    }

    void setClippingColor(int clippingColor) {
        if (this.mCornerPaint.getColor() == clippingColor) {
            return;
        }
        this.mCornerPaint.setColor(clippingColor);
        this.invalidateSelf();
    }

    void setCornerRadius(float radius) {
        if (this.mCornerRadius == (radius = (float)((int)(radius + 0.5f)))) {
            return;
        }
        this.mCornerRadius = radius;
        this.mDirty = true;
        this.invalidateSelf();
    }

    private void buildClippingCorners() {
        this.mCornerPath.reset();
        RectF oval = new RectF(0.0f, 0.0f, this.mCornerRadius * 2.0f, this.mCornerRadius * 2.0f);
        this.mCornerPath.setFillType(Path.FillType.EVEN_ODD);
        this.mCornerPath.moveTo(0.0f, 0.0f);
        this.mCornerPath.lineTo(0.0f, this.mCornerRadius);
        this.mCornerPath.arcTo(oval, 180.0f, 90.0f, true);
        this.mCornerPath.lineTo(0.0f, 0.0f);
        this.mCornerPath.close();
    }
}

