/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.Px;
import android.support.v4.util.Pools;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.CardClipDrawable;
import com.facebook.litho.widget.CardClipSpec;

public final class CardClip
extends ComponentLifecycle {
    private static CardClip sInstance = null;
    private static final Pools.SynchronizedPool<Builder> sBuilderPool = new Pools.SynchronizedPool(2);

    private CardClip() {
    }

    private static synchronized CardClip get() {
        if (sInstance == null) {
            sInstance = new CardClip();
        }
        return sInstance;
    }

    protected Object onCreateMountContent(ComponentContext c) {
        CardClipDrawable _result = CardClipSpec.onCreateMountContent(c);
        return _result;
    }

    protected void onMount(ComponentContext c, Object cardClipDrawable, Component _abstractImpl) {
        CardClipImpl _impl = (CardClipImpl)_abstractImpl;
        CardClipSpec.onMount(c, (CardClipDrawable)((Object)cardClipDrawable), _impl.clippingColor, _impl.cornerRadius, _impl.disableClipTopLeft, _impl.disableClipTopRight, _impl.disableClipBottomLeft, _impl.disableClipBottomRight);
    }

    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.DRAWABLE;
    }

    protected int poolSize() {
        return 15;
    }

    public boolean isPureRender() {
        return true;
    }

    public static Builder create(ComponentContext context) {
        return CardClip.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Builder builder = (Builder)((Object)sBuilderPool.acquire());
        if (builder == null) {
            builder = new Builder();
        }
        builder.init(context, defStyleAttr, defStyleRes, new CardClipImpl());
        return builder;
    }

    public static class Builder
    extends Component.Builder<CardClip, Builder> {
        CardClipImpl mCardClipImpl;
        ComponentContext mContext;

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, CardClipImpl cardClipImpl) {
            super.init(context, defStyleAttr, defStyleRes, (Component)cardClipImpl);
            this.mCardClipImpl = cardClipImpl;
            this.mContext = context;
        }

        public Builder clippingColor(@ColorInt int clippingColor) {
            this.mCardClipImpl.clippingColor = clippingColor;
            return this;
        }

        public Builder clippingColorRes(@ColorRes int resId) {
            this.mCardClipImpl.clippingColor = this.resolveColorRes(resId);
            return this;
        }

        public Builder clippingColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mCardClipImpl.clippingColor = this.resolveColorAttr(attrResId, defResId);
            return this;
        }

        public Builder clippingColorAttr(@AttrRes int attrResId) {
            this.mCardClipImpl.clippingColor = this.resolveColorAttr(attrResId, 0);
            return this;
        }

        public Builder cornerRadiusPx(@Px float cornerRadius) {
            this.mCardClipImpl.cornerRadius = cornerRadius;
            return this;
        }

        public Builder cornerRadiusRes(@DimenRes int resId) {
            this.mCardClipImpl.cornerRadius = this.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder cornerRadiusAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mCardClipImpl.cornerRadius = this.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder cornerRadiusAttr(@AttrRes int attrResId) {
            this.mCardClipImpl.cornerRadius = this.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder cornerRadiusDip(@Dimension(unit=0) float dip) {
            this.mCardClipImpl.cornerRadius = this.dipsToPixels(dip);
            return this;
        }

        public Builder disableClipTopLeft(boolean disableClipTopLeft) {
            this.mCardClipImpl.disableClipTopLeft = disableClipTopLeft;
            return this;
        }

        public Builder disableClipTopRight(boolean disableClipTopRight) {
            this.mCardClipImpl.disableClipTopRight = disableClipTopRight;
            return this;
        }

        public Builder disableClipBottomLeft(boolean disableClipBottomLeft) {
            this.mCardClipImpl.disableClipBottomLeft = disableClipBottomLeft;
            return this;
        }

        public Builder disableClipBottomRight(boolean disableClipBottomRight) {
            this.mCardClipImpl.disableClipBottomRight = disableClipBottomRight;
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public Component<CardClip> build() {
            CardClipImpl cardClipImpl = this.mCardClipImpl;
            this.release();
            return cardClipImpl;
        }

        protected void release() {
            super.release();
            this.mCardClipImpl = null;
            this.mContext = null;
            sBuilderPool.release((Object)this);
        }
    }

    static class CardClipImpl
    extends Component<CardClip>
    implements Cloneable {
        @Prop(resType=ResType.COLOR, optional=true)
        int clippingColor;
        @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
        float cornerRadius;
        @Prop(resType=ResType.NONE, optional=true)
        boolean disableClipTopLeft;
        @Prop(resType=ResType.NONE, optional=true)
        boolean disableClipTopRight;
        @Prop(resType=ResType.NONE, optional=true)
        boolean disableClipBottomLeft;
        @Prop(resType=ResType.NONE, optional=true)
        boolean disableClipBottomRight;

        private CardClipImpl() {
            super((ComponentLifecycle)CardClip.get());
        }

        public String getSimpleName() {
            return "CardClip";
        }

        public boolean isEquivalentTo(Component<?> other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CardClipImpl cardClipImpl = (CardClipImpl)other;
            if (this.getId() == cardClipImpl.getId()) {
                return true;
            }
            if (this.clippingColor != cardClipImpl.clippingColor) {
                return false;
            }
            if (Float.compare(this.cornerRadius, cardClipImpl.cornerRadius) != 0) {
                return false;
            }
            if (this.disableClipTopLeft != cardClipImpl.disableClipTopLeft) {
                return false;
            }
            if (this.disableClipTopRight != cardClipImpl.disableClipTopRight) {
                return false;
            }
            if (this.disableClipBottomLeft != cardClipImpl.disableClipBottomLeft) {
                return false;
            }
            return this.disableClipBottomRight == cardClipImpl.disableClipBottomRight;
        }
    }
}

