/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.Px;
import android.support.v4.util.Pools;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.CardSpec;
import java.util.BitSet;

public final class Card
extends ComponentLifecycle {
    private static Card sInstance = null;
    private static final Pools.SynchronizedPool<Builder> sBuilderPool = new Pools.SynchronizedPool(2);

    private Card() {
    }

    private static synchronized Card get() {
        if (sInstance == null) {
            sInstance = new Card();
        }
        return sInstance;
    }

    protected ComponentLayout onCreateLayout(ComponentContext c, Component _abstractImpl) {
        CardImpl _impl = (CardImpl)_abstractImpl;
        ComponentLayout _result = CardSpec.onCreateLayout(c, _impl.content, _impl.cardBackgroundColor, _impl.clippingColor, _impl.shadowStartColor, _impl.shadowEndColor, _impl.cornerRadius, _impl.elevation);
        return _result;
    }

    public boolean isPureRender() {
        return true;
    }

    public static Builder create(ComponentContext context) {
        return Card.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Builder builder = (Builder)((Object)sBuilderPool.acquire());
        if (builder == null) {
            builder = new Builder();
        }
        builder.init(context, defStyleAttr, defStyleRes, new CardImpl());
        return builder;
    }

    public static class Builder
    extends Component.Builder<Card, Builder> {
        private static final String[] REQUIRED_PROPS_NAMES = new String[]{"content"};
        private static final int REQUIRED_PROPS_COUNT = 1;
        CardImpl mCardImpl;
        ComponentContext mContext;
        private BitSet mRequired = new BitSet(1);

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, CardImpl cardImpl) {
            super.init(context, defStyleAttr, defStyleRes, (Component)cardImpl);
            this.mCardImpl = cardImpl;
            this.mContext = context;
            this.mRequired.clear();
        }

        public Builder content(Component<?> content) {
            this.mCardImpl.content = content;
            this.mRequired.set(0);
            return this;
        }

        public Builder content(Component.Builder<?, ?> contentBuilder) {
            this.mCardImpl.content = contentBuilder.build();
            this.mRequired.set(0);
            return this;
        }

        public Builder cardBackgroundColor(@ColorInt int cardBackgroundColor) {
            this.mCardImpl.cardBackgroundColor = cardBackgroundColor;
            return this;
        }

        public Builder cardBackgroundColorRes(@ColorRes int resId) {
            this.mCardImpl.cardBackgroundColor = this.resolveColorRes(resId);
            return this;
        }

        public Builder cardBackgroundColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mCardImpl.cardBackgroundColor = this.resolveColorAttr(attrResId, defResId);
            return this;
        }

        public Builder cardBackgroundColorAttr(@AttrRes int attrResId) {
            this.mCardImpl.cardBackgroundColor = this.resolveColorAttr(attrResId, 0);
            return this;
        }

        public Builder clippingColor(@ColorInt int clippingColor) {
            this.mCardImpl.clippingColor = clippingColor;
            return this;
        }

        public Builder clippingColorRes(@ColorRes int resId) {
            this.mCardImpl.clippingColor = this.resolveColorRes(resId);
            return this;
        }

        public Builder clippingColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mCardImpl.clippingColor = this.resolveColorAttr(attrResId, defResId);
            return this;
        }

        public Builder clippingColorAttr(@AttrRes int attrResId) {
            this.mCardImpl.clippingColor = this.resolveColorAttr(attrResId, 0);
            return this;
        }

        public Builder shadowStartColor(@ColorInt int shadowStartColor) {
            this.mCardImpl.shadowStartColor = shadowStartColor;
            return this;
        }

        public Builder shadowStartColorRes(@ColorRes int resId) {
            this.mCardImpl.shadowStartColor = this.resolveColorRes(resId);
            return this;
        }

        public Builder shadowStartColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mCardImpl.shadowStartColor = this.resolveColorAttr(attrResId, defResId);
            return this;
        }

        public Builder shadowStartColorAttr(@AttrRes int attrResId) {
            this.mCardImpl.shadowStartColor = this.resolveColorAttr(attrResId, 0);
            return this;
        }

        public Builder shadowEndColor(@ColorInt int shadowEndColor) {
            this.mCardImpl.shadowEndColor = shadowEndColor;
            return this;
        }

        public Builder shadowEndColorRes(@ColorRes int resId) {
            this.mCardImpl.shadowEndColor = this.resolveColorRes(resId);
            return this;
        }

        public Builder shadowEndColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mCardImpl.shadowEndColor = this.resolveColorAttr(attrResId, defResId);
            return this;
        }

        public Builder shadowEndColorAttr(@AttrRes int attrResId) {
            this.mCardImpl.shadowEndColor = this.resolveColorAttr(attrResId, 0);
            return this;
        }

        public Builder cornerRadiusPx(@Px float cornerRadius) {
            this.mCardImpl.cornerRadius = cornerRadius;
            return this;
        }

        public Builder cornerRadiusRes(@DimenRes int resId) {
            this.mCardImpl.cornerRadius = this.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder cornerRadiusAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mCardImpl.cornerRadius = this.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder cornerRadiusAttr(@AttrRes int attrResId) {
            this.mCardImpl.cornerRadius = this.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder cornerRadiusDip(@Dimension(unit=0) float dip) {
            this.mCardImpl.cornerRadius = this.dipsToPixels(dip);
            return this;
        }

        public Builder elevationPx(@Px float elevation) {
            this.mCardImpl.elevation = elevation;
            return this;
        }

        public Builder elevationRes(@DimenRes int resId) {
            this.mCardImpl.elevation = this.resolveDimenSizeRes(resId);
            return this;
        }

        public Builder elevationAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mCardImpl.elevation = this.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        public Builder elevationAttr(@AttrRes int attrResId) {
            this.mCardImpl.elevation = this.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder elevationDip(@Dimension(unit=0) float dip) {
            this.mCardImpl.elevation = this.dipsToPixels(dip);
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public Component<Card> build() {
            Builder.checkArgs((int)1, (BitSet)this.mRequired, (String[])REQUIRED_PROPS_NAMES);
            CardImpl cardImpl = this.mCardImpl;
            this.release();
            return cardImpl;
        }

        protected void release() {
            super.release();
            this.mCardImpl = null;
            this.mContext = null;
            sBuilderPool.release((Object)this);
        }
    }

    static class CardImpl
    extends Component<Card>
    implements Cloneable {
        @Prop(resType=ResType.NONE, optional=false)
        Component<?> content;
        @Prop(resType=ResType.COLOR, optional=true)
        int cardBackgroundColor = -1;
        @Prop(resType=ResType.COLOR, optional=true)
        int clippingColor = -1;
        @Prop(resType=ResType.COLOR, optional=true)
        int shadowStartColor = 0x37000000;
        @Prop(resType=ResType.COLOR, optional=true)
        int shadowEndColor = 0x3000000;
        @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
        float cornerRadius = -1.0f;
        @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
        float elevation = -1.0f;

        private CardImpl() {
            super((ComponentLifecycle)Card.get());
        }

        public String getSimpleName() {
            return "Card";
        }

        public boolean isEquivalentTo(Component<?> other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CardImpl cardImpl = (CardImpl)other;
            if (this.getId() == cardImpl.getId()) {
                return true;
            }
            if (this.content != null ? !this.content.equals(cardImpl.content) : cardImpl.content != null) {
                return false;
            }
            if (this.cardBackgroundColor != cardImpl.cardBackgroundColor) {
                return false;
            }
            if (this.clippingColor != cardImpl.clippingColor) {
                return false;
            }
            if (this.shadowStartColor != cardImpl.shadowStartColor) {
                return false;
            }
            if (this.shadowEndColor != cardImpl.shadowEndColor) {
                return false;
            }
            if (Float.compare(this.cornerRadius, cardImpl.cornerRadius) != 0) {
                return false;
            }
            return Float.compare(this.elevation, cardImpl.elevation) == 0;
        }

        public CardImpl makeShallowCopy() {
            CardImpl component = (CardImpl)super.makeShallowCopy();
            component.content = component.content != null ? component.content.makeShallowCopy() : null;
            return component;
        }
    }
}

