/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.support.v4.util.Pools;
import com.facebook.litho.viewcompat.ViewBinder;
import com.facebook.litho.viewcompat.ViewCreator;
import com.facebook.litho.widget.RenderInfo;

public class ViewRenderInfo
extends RenderInfo {
    private static final Pools.Pool<Builder> sBuilderPool = new Pools.SynchronizedPool(2);
    private final ViewBinder mViewBinder;
    private final ViewCreator mViewCreator;
    private int mViewType;

    public static Builder create() {
        Builder builder = (Builder)sBuilderPool.acquire();
        if (builder == null) {
            builder = new Builder();
        }
        return builder;
    }

    private ViewRenderInfo(Builder builder) {
        super(builder);
        this.mViewBinder = builder.viewBinder;
        this.mViewCreator = builder.viewCreator;
    }

    @Override
    public boolean rendersView() {
        return true;
    }

    @Override
    public ViewBinder getViewBinder() {
        return this.mViewBinder;
    }

    @Override
    public ViewCreator getViewCreator() {
        return this.mViewCreator;
    }

    @Override
    public void setViewType(int viewType) {
        this.mViewType = viewType;
    }

    @Override
    public int getViewType() {
        return this.mViewType;
    }

    @Override
    public String getName() {
        return "View (viewType=" + this.mViewType + ")";
    }

    public static class Builder
    extends RenderInfo.Builder<Builder> {
        private ViewBinder viewBinder;
        private ViewCreator viewCreator;

        public Builder viewCreator(ViewCreator viewCreator) {
            this.viewCreator = viewCreator;
            return this;
        }

        public Builder viewBinder(ViewBinder viewBinder) {
            this.viewBinder = viewBinder;
            return this;
        }

        public ViewRenderInfo build() {
            if (this.viewCreator == null || this.viewBinder == null) {
                throw new IllegalStateException("Both viewCreator and viewBinder must be provided.");
            }
            ViewRenderInfo viewRenderInfo = new ViewRenderInfo(this);
            this.release();
            return viewRenderInfo;
        }

        @Override
        void release() {
            super.release();
            this.viewBinder = null;
            this.viewCreator = null;
            sBuilderPool.release((Object)this);
        }
    }
}

