/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.support.v4.util.Pools;
import android.view.ViewTreeObserver;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.Output;
import com.facebook.litho.StateValue;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.annotations.State;
import com.facebook.litho.widget.VerticalScrollSpec;
import java.util.BitSet;

public final class VerticalScroll
extends ComponentLifecycle {
    private static VerticalScroll sInstance = null;
    private static final Pools.SynchronizedPool<Builder> sBuilderPool = new Pools.SynchronizedPool(2);

    private VerticalScroll() {
    }

    private static synchronized VerticalScroll get() {
        if (sInstance == null) {
            sInstance = new VerticalScroll();
        }
        return sInstance;
    }

    protected void onPrepare(ComponentContext context, Component _abstractImpl) {
        VerticalScrollImpl _impl = (VerticalScrollImpl)_abstractImpl;
        Output childComponentTree = this.acquireOutput();
        VerticalScrollSpec.onPrepare(context, _impl.childComponent, (Output<ComponentTree>)childComponentTree);
        _impl.childComponentTree = (ComponentTree)childComponentTree.get();
        this.releaseOutput(childComponentTree);
    }

    protected Object onCreateMountContent(ComponentContext context) {
        VerticalScrollSpec.LithoScrollView _result = VerticalScrollSpec.onCreateMountContent(context);
        return _result;
    }

    protected void createInitialState(ComponentContext context, Component _abstractImpl) {
        VerticalScrollImpl _impl = (VerticalScrollImpl)_abstractImpl;
        StateValue scrollPosition = new StateValue();
        VerticalScrollSpec.onCreateInitialState(context, (StateValue<VerticalScrollSpec.ScrollPosition>)scrollPosition, _impl.initialScrollOffsetPixels);
        _impl.mStateContainerImpl.scrollPosition = (VerticalScrollSpec.ScrollPosition)scrollPosition.get();
    }

    protected void onMount(ComponentContext context, Object lithoScrollView, Component _abstractImpl) {
        VerticalScrollImpl _impl = (VerticalScrollImpl)_abstractImpl;
        VerticalScrollSpec.onMount(context, (VerticalScrollSpec.LithoScrollView)((Object)lithoScrollView), _impl.scrollbarEnabled, _impl.scrollbarFadingEnabled, _impl.childComponentTree, _impl.mStateContainerImpl.scrollPosition);
    }

    protected void onBind(ComponentContext context, Object lithoScrollView, Component _abstractImpl) {
        VerticalScrollImpl _impl = (VerticalScrollImpl)_abstractImpl;
        Output onPreDrawListener = this.acquireOutput();
        Output onScrollChangedListener = this.acquireOutput();
        VerticalScrollSpec.onBind(context, (VerticalScrollSpec.LithoScrollView)((Object)lithoScrollView), _impl.mStateContainerImpl.scrollPosition, (Output<ViewTreeObserver.OnPreDrawListener>)onPreDrawListener, (Output<ViewTreeObserver.OnScrollChangedListener>)onScrollChangedListener);
        _impl.onPreDrawListener = (ViewTreeObserver.OnPreDrawListener)onPreDrawListener.get();
        this.releaseOutput(onPreDrawListener);
        _impl.onScrollChangedListener = (ViewTreeObserver.OnScrollChangedListener)onScrollChangedListener.get();
        this.releaseOutput(onScrollChangedListener);
    }

    protected void onUnbind(ComponentContext context, Object lithoScrollView, Component _abstractImpl) {
        VerticalScrollImpl _impl = (VerticalScrollImpl)_abstractImpl;
        VerticalScrollSpec.onUnbind(context, (VerticalScrollSpec.LithoScrollView)((Object)lithoScrollView), _impl.onPreDrawListener, _impl.onScrollChangedListener);
    }

    protected void onUnmount(ComponentContext context, Object lithoScrollView, Component _abstractImpl) {
        VerticalScrollImpl _impl = (VerticalScrollImpl)_abstractImpl;
        VerticalScrollSpec.onUnmount(context, (VerticalScrollSpec.LithoScrollView)((Object)lithoScrollView));
    }

    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.VIEW;
    }

    protected int poolSize() {
        return 15;
    }

    public boolean canMountIncrementally() {
        return true;
    }

    protected boolean hasState() {
        return true;
    }

    protected void transferState(ComponentContext context, ComponentLifecycle.StateContainer prevStateContainer, Component component) {
        VerticalScrollStateContainerImpl prevStateContainerImpl = (VerticalScrollStateContainerImpl)prevStateContainer;
        VerticalScrollImpl componentImpl = (VerticalScrollImpl)component;
        componentImpl.mStateContainerImpl.scrollPosition = prevStateContainerImpl.scrollPosition;
    }

    public static Builder create(ComponentContext context) {
        return VerticalScroll.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Builder builder = (Builder)((Object)sBuilderPool.acquire());
        if (builder == null) {
            builder = new Builder();
        }
        builder.init(context, defStyleAttr, defStyleRes, new VerticalScrollImpl());
        return builder;
    }

    public static class Builder
    extends Component.Builder<VerticalScroll, Builder> {
        private static final String[] REQUIRED_PROPS_NAMES = new String[]{"childComponent"};
        private static final int REQUIRED_PROPS_COUNT = 1;
        VerticalScrollImpl mVerticalScrollImpl;
        ComponentContext mContext;
        private BitSet mRequired = new BitSet(1);

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, VerticalScrollImpl verticalScrollImpl) {
            super.init(context, defStyleAttr, defStyleRes, (Component)verticalScrollImpl);
            this.mVerticalScrollImpl = verticalScrollImpl;
            this.mContext = context;
            this.mRequired.clear();
        }

        public Builder childComponent(Component<?> childComponent) {
            this.mVerticalScrollImpl.childComponent = childComponent;
            this.mRequired.set(0);
            return this;
        }

        public Builder childComponent(Component.Builder<?, ?> childComponentBuilder) {
            this.mVerticalScrollImpl.childComponent = childComponentBuilder.build();
            this.mRequired.set(0);
            return this;
        }

        public Builder initialScrollOffsetPixels(Integer initialScrollOffsetPixels) {
            this.mVerticalScrollImpl.initialScrollOffsetPixels = initialScrollOffsetPixels;
            return this;
        }

        public Builder scrollbarEnabled(boolean scrollbarEnabled) {
            this.mVerticalScrollImpl.scrollbarEnabled = scrollbarEnabled;
            return this;
        }

        public Builder scrollbarFadingEnabled(boolean scrollbarFadingEnabled) {
            this.mVerticalScrollImpl.scrollbarFadingEnabled = scrollbarFadingEnabled;
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public Component<VerticalScroll> build() {
            Builder.checkArgs((int)1, (BitSet)this.mRequired, (String[])REQUIRED_PROPS_NAMES);
            VerticalScrollImpl verticalScrollImpl = this.mVerticalScrollImpl;
            this.release();
            return verticalScrollImpl;
        }

        protected void release() {
            super.release();
            this.mVerticalScrollImpl = null;
            this.mContext = null;
            sBuilderPool.release((Object)this);
        }
    }

    static class VerticalScrollImpl
    extends Component<VerticalScroll>
    implements Cloneable {
        VerticalScrollStateContainerImpl mStateContainerImpl = new VerticalScrollStateContainerImpl();
        @Prop(resType=ResType.NONE, optional=false)
        Component<?> childComponent;
        @Prop(resType=ResType.NONE, optional=true)
        Integer initialScrollOffsetPixels;
        @Prop(resType=ResType.NONE, optional=true)
        boolean scrollbarEnabled = true;
        @Prop(resType=ResType.NONE, optional=true)
        boolean scrollbarFadingEnabled = true;
        ComponentTree childComponentTree;
        ViewTreeObserver.OnPreDrawListener onPreDrawListener;
        ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;

        private VerticalScrollImpl() {
            super((ComponentLifecycle)VerticalScroll.get());
        }

        protected ComponentLifecycle.StateContainer getStateContainer() {
            return this.mStateContainerImpl;
        }

        public String getSimpleName() {
            return "VerticalScroll";
        }

        public boolean isEquivalentTo(Component<?> other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            VerticalScrollImpl verticalScrollImpl = (VerticalScrollImpl)other;
            if (this.getId() == verticalScrollImpl.getId()) {
                return true;
            }
            if (this.childComponent != null ? !this.childComponent.equals(verticalScrollImpl.childComponent) : verticalScrollImpl.childComponent != null) {
                return false;
            }
            if (this.initialScrollOffsetPixels != null ? !this.initialScrollOffsetPixels.equals(verticalScrollImpl.initialScrollOffsetPixels) : verticalScrollImpl.initialScrollOffsetPixels != null) {
                return false;
            }
            if (this.scrollbarEnabled != verticalScrollImpl.scrollbarEnabled) {
                return false;
            }
            if (this.scrollbarFadingEnabled != verticalScrollImpl.scrollbarFadingEnabled) {
                return false;
            }
            return !(this.mStateContainerImpl.scrollPosition != null ? !this.mStateContainerImpl.scrollPosition.equals(verticalScrollImpl.mStateContainerImpl.scrollPosition) : verticalScrollImpl.mStateContainerImpl.scrollPosition != null);
        }

        protected void copyInterStageImpl(Component<VerticalScroll> impl) {
            VerticalScrollImpl verticalScrollImpl = (VerticalScrollImpl)impl;
            this.childComponentTree = verticalScrollImpl.childComponentTree;
            this.onPreDrawListener = verticalScrollImpl.onPreDrawListener;
            this.onScrollChangedListener = verticalScrollImpl.onScrollChangedListener;
        }

        public VerticalScrollImpl makeShallowCopy() {
            VerticalScrollImpl component = (VerticalScrollImpl)super.makeShallowCopy();
            component.childComponent = component.childComponent != null ? component.childComponent.makeShallowCopy() : null;
            component.childComponentTree = null;
            component.onPreDrawListener = null;
            component.onScrollChangedListener = null;
            component.mStateContainerImpl = new VerticalScrollStateContainerImpl();
            return component;
        }
    }

    private static class VerticalScrollStateContainerImpl
    implements ComponentLifecycle.StateContainer {
        @State
        VerticalScrollSpec.ScrollPosition scrollPosition;

        private VerticalScrollStateContainerImpl() {
        }
    }
}

