/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.annotation.TargetApi;
import android.graphics.Typeface;
import android.os.Build;
import android.util.LongSparseArray;
import android.util.SparseArray;
import java.lang.reflect.Field;

public class SynchronizedTypefaceHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setupSynchronizedTypeface() {
        if (Build.VERSION.SDK_INT < 16) {
            return;
        }
        try {
            Object lock;
            Field typefaceCacheField = Typeface.class.getDeclaredField("sTypefaceCache");
            typefaceCacheField.setAccessible(true);
            Object object = lock = new Object();
            synchronized (object) {
                if (Build.VERSION.SDK_INT >= 21) {
                    LongSparseArray oldCache = (LongSparseArray)typefaceCacheField.get(null);
                    SynchronizedLongSparseArray newCache = new SynchronizedLongSparseArray(lock, oldCache.size());
                    typefaceCacheField.set(null, (Object)newCache);
                    int size = oldCache.size();
                    for (int i = 0; i < size; ++i) {
                        newCache.append(oldCache.keyAt(i), (Object)new SynchronizedTypefaceSparseArray((SparseArray<Typeface>)((SparseArray)oldCache.valueAt(i))));
                    }
                } else {
                    SparseArray oldCache = (SparseArray)typefaceCacheField.get(null);
                    SynchronizedSparseArray newCache = new SynchronizedSparseArray(lock, oldCache.size());
                    typefaceCacheField.set(null, (Object)newCache);
                    int size = oldCache.size();
                    for (int i = 0; i < size; ++i) {
                        newCache.append(oldCache.keyAt(i), (Object)new SynchronizedTypefaceSparseArray((SparseArray<Typeface>)((SparseArray)oldCache.valueAt(i))));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class SynchronizedTypefaceSparseArray
    extends SparseArray<Typeface> {
        private final Object mLock = new Object();
        private final SparseArray<Typeface> mDelegateSparseArray;

        SynchronizedTypefaceSparseArray(SparseArray<Typeface> delegateSparseArray) {
            this.mDelegateSparseArray = delegateSparseArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Typeface get(int key) {
            Object object = this.mLock;
            synchronized (object) {
                return (Typeface)this.mDelegateSparseArray.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(int key, Typeface value) {
            Object object = this.mLock;
            synchronized (object) {
                this.mDelegateSparseArray.put(key, (Object)value);
            }
        }
    }

    @TargetApi(value=16)
    static class SynchronizedSparseArray
    extends SparseArray<SparseArray<Typeface>> {
        private final Object mLock;

        SynchronizedSparseArray(Object lock, int initialCapacity) {
            super(initialCapacity);
            this.mLock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SparseArray<Typeface> get(int key) {
            Object object = this.mLock;
            synchronized (object) {
                SparseArray sparseArray = (SparseArray)super.get(key);
                if (sparseArray == null || sparseArray instanceof SynchronizedTypefaceSparseArray) {
                    return sparseArray;
                }
                SynchronizedTypefaceSparseArray synchronizedSparseArray = new SynchronizedTypefaceSparseArray((SparseArray<Typeface>)sparseArray);
                this.put(key, synchronizedSparseArray);
                return synchronizedSparseArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(int key, SparseArray<Typeface> value) {
            Object object = this.mLock;
            synchronized (object) {
                super.put(key, value);
            }
        }
    }

    @TargetApi(value=21)
    static class SynchronizedLongSparseArray
    extends LongSparseArray<SparseArray<Typeface>> {
        private final Object mLock;

        SynchronizedLongSparseArray(Object lock, int initialCapacity) {
            super(initialCapacity);
            this.mLock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SparseArray<Typeface> get(long key) {
            Object object = this.mLock;
            synchronized (object) {
                SparseArray sparseArray = (SparseArray)super.get(key);
                if (sparseArray == null || sparseArray instanceof SynchronizedTypefaceSparseArray) {
                    return sparseArray;
                }
                SynchronizedTypefaceSparseArray synchronizedSparseArray = new SynchronizedTypefaceSparseArray((SparseArray<Typeface>)sparseArray);
                this.put(key, synchronizedSparseArray);
                return synchronizedSparseArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(long key, SparseArray<Typeface> value) {
            Object object = this.mLock;
            synchronized (object) {
                super.put(key, value);
            }
        }
    }
}

