/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.support.annotation.IdRes;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SnapHelper;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.Diff;
import com.facebook.litho.EventHandler;
import com.facebook.litho.Output;
import com.facebook.litho.Size;
import com.facebook.litho.annotations.MountSpec;
import com.facebook.litho.annotations.OnBind;
import com.facebook.litho.annotations.OnBoundsDefined;
import com.facebook.litho.annotations.OnEvent;
import com.facebook.litho.annotations.OnMount;
import com.facebook.litho.annotations.OnUnbind;
import com.facebook.litho.annotations.OnUnmount;
import com.facebook.litho.annotations.OnUpdateState;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropDefault;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.Binder;
import com.facebook.litho.widget.PTRRefreshEvent;
import com.facebook.litho.widget.ReMeasureEvent;
import com.facebook.litho.widget.Recycler;
import com.facebook.litho.widget.RecyclerEventsController;
import com.facebook.litho.widget.RecyclerViewWrapper;
import java.util.List;

@MountSpec(canMountIncrementally=true, isPureRender=true, events={PTRRefreshEvent.class})
class RecyclerSpec {
    @PropDefault
    static final int scrollBarStyle = 0;
    @PropDefault
    static final boolean hasFixedSize = true;
    @PropDefault
    static final boolean nestedScrollingEnabled = true;
    @PropDefault
    static final RecyclerView.ItemAnimator itemAnimator = new NoUpdateItemAnimator();
    @PropDefault
    static final int recyclerViewId = -1;
    @PropDefault
    static final int refreshProgressBarColor = -16777216;
    @PropDefault
    static final boolean clipToPadding = true;
    @PropDefault
    static final boolean clipChildren = true;
    @PropDefault
    static final int leftPadding = 0;
    @PropDefault
    static final int rightPadding = 0;
    @PropDefault
    static final int topPadding = 0;
    @PropDefault
    static final int bottomPadding = 0;

    RecyclerSpec() {
    }

    static void onMeasure(ComponentContext c, ComponentLayout layout, int widthSpec, int heightSpec, Size measureOutput, @Prop Binder<RecyclerView> binder, @Prop(optional=true) boolean canMeasure) {
        binder.measure(measureOutput, widthSpec, heightSpec, canMeasure ? Recycler.onRemeasure(c) : null);
    }

    @OnBoundsDefined
    static void onBoundsDefined(ComponentContext context, ComponentLayout layout, @Prop Binder<RecyclerView> binder) {
        binder.setSize(layout.getWidth(), layout.getHeight());
    }

    static RecyclerViewWrapper onCreateMountContent(ComponentContext c) {
        return new RecyclerViewWrapper((Context)c, new RecyclerView((Context)c));
    }

    static void onPrepare(ComponentContext c, final @Prop(optional=true) EventHandler refreshHandler, Output<SwipeRefreshLayout.OnRefreshListener> onRefreshListener) {
        if (refreshHandler != null) {
            onRefreshListener.set((Object)new SwipeRefreshLayout.OnRefreshListener(){

                public void onRefresh() {
                    Recycler.dispatchPTRRefreshEvent(refreshHandler);
                }
            });
        }
    }

    @OnMount
    static void onMount(ComponentContext c, RecyclerViewWrapper recyclerViewWrapper, @Prop Binder<RecyclerView> binder, @Prop(optional=true) boolean hasFixedSize, @Prop(optional=true) boolean clipToPadding, @Prop(optional=true) int leftPadding, @Prop(optional=true) int rightPadding, @Prop(optional=true) int topPadding, @Prop(optional=true) int bottomPadding, @Prop(optional=true) boolean clipChildren, @Prop(optional=true) boolean nestedScrollingEnabled, @Prop(optional=true) int scrollBarStyle, @Prop(optional=true) RecyclerView.ItemDecoration itemDecoration, @Prop(optional=true, resType=ResType.COLOR) int refreshProgressBarColor, @Prop(optional=true) boolean horizontalFadingEdgeEnabled, @Prop(optional=true) boolean verticalFadingEdgeEnabled, @Prop(optional=true, resType=ResType.DIMEN_SIZE) int fadingEdgeLength, @Prop(optional=true) @IdRes int recyclerViewId) {
        RecyclerView recyclerView = recyclerViewWrapper.getRecyclerView();
        if (recyclerView == null) {
            throw new IllegalStateException("RecyclerView not found, it should not be removed from SwipeRefreshLayout");
        }
        recyclerViewWrapper.setColorSchemeColors(new int[]{refreshProgressBarColor});
        recyclerView.setHasFixedSize(hasFixedSize);
        recyclerView.setClipToPadding(clipToPadding);
        recyclerViewWrapper.setClipToPadding(clipToPadding);
        recyclerView.setPadding(leftPadding, topPadding, rightPadding, bottomPadding);
        recyclerView.setClipChildren(clipChildren);
        recyclerViewWrapper.setClipChildren(clipChildren);
        recyclerView.setNestedScrollingEnabled(nestedScrollingEnabled);
        recyclerViewWrapper.setNestedScrollingEnabled(nestedScrollingEnabled);
        recyclerView.setScrollBarStyle(scrollBarStyle);
        recyclerView.setHorizontalFadingEdgeEnabled(horizontalFadingEdgeEnabled);
        recyclerView.setVerticalFadingEdgeEnabled(verticalFadingEdgeEnabled);
        recyclerView.setFadingEdgeLength(fadingEdgeLength);
        recyclerView.setId(recyclerViewId);
        if (itemDecoration != null) {
            recyclerView.addItemDecoration(itemDecoration);
        }
        binder.mount(recyclerView);
    }

    @OnBind
    protected static void onBind(ComponentContext context, RecyclerViewWrapper recyclerViewWrapper, @Prop(optional=true) RecyclerView.ItemAnimator itemAnimator, @Prop Binder<RecyclerView> binder, @Prop(optional=true) RecyclerEventsController recyclerEventsController, @Prop(optional=true, varArg="onScrollListener") List<RecyclerView.OnScrollListener> onScrollListeners, @Prop(optional=true) SnapHelper snapHelper, SwipeRefreshLayout.OnRefreshListener onRefreshListener, Output<RecyclerView.ItemAnimator> oldAnimator) {
        recyclerViewWrapper.setEnabled(onRefreshListener != null);
        recyclerViewWrapper.setOnRefreshListener(onRefreshListener);
        RecyclerView recyclerView = recyclerViewWrapper.getRecyclerView();
        if (recyclerView == null) {
            throw new IllegalStateException("RecyclerView not found, it should not be removed from SwipeRefreshLayout before unmounting");
        }
        oldAnimator.set((Object)recyclerView.getItemAnimator());
        if (itemAnimator != RecyclerSpec.itemAnimator) {
            recyclerView.setItemAnimator(itemAnimator);
        } else {
            recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new NoUpdateItemAnimator());
        }
        if (onScrollListeners != null) {
            for (RecyclerView.OnScrollListener onScrollListener : onScrollListeners) {
                recyclerView.addOnScrollListener(onScrollListener);
            }
        }
        if (snapHelper != null) {
            snapHelper.attachToRecyclerView(recyclerView);
        }
        binder.bind(recyclerView);
        if (recyclerEventsController != null) {
            recyclerEventsController.setRecyclerViewWrapper(recyclerViewWrapper);
        }
        if (recyclerViewWrapper.hasBeenDetachedFromWindow()) {
            recyclerView.requestLayout();
            recyclerViewWrapper.setHasBeenDetachedFromWindow(false);
        }
    }

    @OnUnbind
    static void onUnbind(ComponentContext context, RecyclerViewWrapper recyclerViewWrapper, @Prop Binder<RecyclerView> binder, @Prop(optional=true) RecyclerEventsController recyclerEventsController, @Prop(optional=true, varArg="onScrollListener") List<RecyclerView.OnScrollListener> onScrollListeners, RecyclerView.ItemAnimator oldAnimator) {
        RecyclerView recyclerView = recyclerViewWrapper.getRecyclerView();
        if (recyclerView == null) {
            throw new IllegalStateException("RecyclerView not found, it should not be removed from SwipeRefreshLayout before unmounting");
        }
        recyclerView.setItemAnimator(oldAnimator);
        binder.unbind(recyclerView);
        if (recyclerEventsController != null) {
            recyclerEventsController.setRecyclerViewWrapper(null);
        }
        if (onScrollListeners != null) {
            for (RecyclerView.OnScrollListener onScrollListener : onScrollListeners) {
                recyclerView.removeOnScrollListener(onScrollListener);
            }
        }
        recyclerViewWrapper.setOnRefreshListener(null);
    }

    @OnUnmount
    static void onUnmount(ComponentContext context, RecyclerViewWrapper recyclerViewWrapper, @Prop Binder<RecyclerView> binder, @Prop(optional=true) RecyclerView.ItemDecoration itemDecoration, @Prop(optional=true) SnapHelper snapHelper) {
        RecyclerView recyclerView = recyclerViewWrapper.getRecyclerView();
        if (recyclerView == null) {
            throw new IllegalStateException("RecyclerView not found, it should not be removed from SwipeRefreshLayout before unmounting");
        }
        recyclerView.setId(-1);
        if (itemDecoration != null) {
            recyclerView.removeItemDecoration(itemDecoration);
        }
        binder.unmount(recyclerView);
        if (snapHelper != null) {
            snapHelper.attachToRecyclerView(null);
        }
    }

    protected static boolean shouldUpdate(@Prop Diff<Binder<RecyclerView>> binder, @Prop(optional=true) Diff<Boolean> hasFixedSize, @Prop(optional=true) Diff<Boolean> clipToPadding, @Prop(optional=true) Diff<Integer> leftPadding, @Prop(optional=true) Diff<Integer> rightPadding, @Prop(optional=true) Diff<Integer> topPadding, @Prop(optional=true) Diff<Integer> bottomPadding, @Prop(optional=true) Diff<Boolean> clipChildren, @Prop(optional=true) Diff<Integer> scrollBarStyle, @Prop(optional=true) Diff<RecyclerView.ItemDecoration> itemDecoration, @Prop(optional=true) Diff<Boolean> horizontalFadingEdgeEnabled, @Prop(optional=true) Diff<Boolean> verticalFadingEdgeEnabled, @Prop(optional=true, resType=ResType.DIMEN_SIZE) Diff<Integer> fadingEdgeLength) {
        if (binder.getPrevious() != binder.getNext()) {
            return true;
        }
        if (!((Boolean)hasFixedSize.getPrevious()).equals(hasFixedSize.getNext())) {
            return true;
        }
        if (!((Boolean)clipToPadding.getPrevious()).equals(clipToPadding.getNext())) {
            return true;
        }
        if (!((Integer)leftPadding.getPrevious()).equals(leftPadding.getNext())) {
            return true;
        }
        if (!((Integer)rightPadding.getPrevious()).equals(rightPadding.getNext())) {
            return true;
        }
        if (!((Integer)topPadding.getPrevious()).equals(topPadding.getNext())) {
            return true;
        }
        if (!((Integer)bottomPadding.getPrevious()).equals(bottomPadding.getNext())) {
            return true;
        }
        if (!((Boolean)clipChildren.getPrevious()).equals(clipChildren.getNext())) {
            return true;
        }
        if (!((Integer)scrollBarStyle.getPrevious()).equals(scrollBarStyle.getNext())) {
            return true;
        }
        if (!((Boolean)horizontalFadingEdgeEnabled.getPrevious()).equals(horizontalFadingEdgeEnabled.getNext())) {
            return true;
        }
        if (!((Boolean)verticalFadingEdgeEnabled.getPrevious()).equals(verticalFadingEdgeEnabled.getNext())) {
            return true;
        }
        if (!((Integer)fadingEdgeLength.getPrevious()).equals(fadingEdgeLength.getNext())) {
            return true;
        }
        RecyclerView.ItemDecoration previous = (RecyclerView.ItemDecoration)itemDecoration.getPrevious();
        RecyclerView.ItemDecoration next = (RecyclerView.ItemDecoration)itemDecoration.getNext();
        boolean itemDecorationIsEqual = previous == null ? next == null : previous.equals(next);
        return !itemDecorationIsEqual;
    }

    @OnEvent(value=ReMeasureEvent.class)
    protected static void onRemeasure(ComponentContext c) {
        Recycler.onUpdateMeasure(c);
    }

    @OnUpdateState
    protected static void onUpdateMeasure() {
    }

    public static class NoUpdateItemAnimator
    extends DefaultItemAnimator {
        public NoUpdateItemAnimator() {
            this.setSupportsChangeAnimations(false);
        }
    }
}

