/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.widget.ProgressBar;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.Output;
import com.facebook.litho.R;
import com.facebook.litho.Size;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.annotations.MountSpec;
import com.facebook.litho.annotations.OnMount;
import com.facebook.litho.annotations.OnUnmount;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropDefault;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.utils.MeasureUtils;

@MountSpec(isPureRender=true)
class ProgressSpec {
    static final int DEFAULT_SIZE = 50;
    @PropDefault
    static final int color = 0;

    ProgressSpec() {
    }

    static void onLoadStyle(ComponentContext c, Output<Drawable> indeterminateDrawable) {
        indeterminateDrawable.set((Object)ProgressSpec.getStyledIndeterminateDrawable(c, 0));
    }

    static void onPrepare(ComponentContext c, @Prop(optional=true, resType=ResType.DRAWABLE) Drawable indeterminateDrawable, Output<Drawable> resolvedIndeterminateDrawable) {
        if (indeterminateDrawable != null) {
            resolvedIndeterminateDrawable.set((Object)indeterminateDrawable);
        } else {
            resolvedIndeterminateDrawable.set((Object)ProgressSpec.getStyledIndeterminateDrawable(c, 0x1010077));
        }
    }

    static void onMeasure(ComponentContext c, ComponentLayout layout, int widthSpec, int heightSpec, Size size) {
        if (SizeSpec.getMode((int)widthSpec) == 0 && SizeSpec.getMode((int)heightSpec) == 0) {
            size.width = 50;
            size.height = 50;
        } else {
            MeasureUtils.measureWithEqualDimens((int)widthSpec, (int)heightSpec, (Size)size);
        }
    }

    @OnMount
    static void onMount(ComponentContext c, ProgressBar progressBar, @Prop(optional=true, resType=ResType.COLOR) int color, Drawable resolvedIndeterminateDrawable) {
        if (resolvedIndeterminateDrawable != null) {
            progressBar.setIndeterminateDrawable(resolvedIndeterminateDrawable);
        }
        if (color != 0 && progressBar.getIndeterminateDrawable() != null) {
            progressBar.getIndeterminateDrawable().mutate().setColorFilter(color, PorterDuff.Mode.MULTIPLY);
        }
    }

    @OnUnmount
    static void onUnmount(ComponentContext c, ProgressBar progressBar, @Prop(optional=true, resType=ResType.COLOR) int color, Drawable resolvedIndeterminateDrawable) {
        if (color != 0 && progressBar.getIndeterminateDrawable() != null) {
            progressBar.getIndeterminateDrawable().mutate().clearColorFilter();
        }
        progressBar.setIndeterminateDrawable(null);
    }

    static ProgressBar onCreateMountContent(ComponentContext c) {
        return new ProgressView((Context)c);
    }

    static Drawable getStyledIndeterminateDrawable(ComponentContext c, int defStyle) {
        Drawable indeterminateDrawable = null;
        TypedArray styledAttributes = c.obtainStyledAttributes(R.styleable.Progress, defStyle);
        int size = styledAttributes.getIndexCount();
        for (int i = 0; i < size; ++i) {
            int attr2 = styledAttributes.getIndex(i);
            if (attr2 != R.styleable.Progress_android_indeterminateDrawable) continue;
            indeterminateDrawable = c.getResources().getDrawable(styledAttributes.getResourceId(attr2, 0));
        }
        styledAttributes.recycle();
        return indeterminateDrawable;
    }

    private static class ProgressView
    extends ProgressBar {
        private ProgressView(Context context) {
            super(context);
        }

        public void setIndeterminateDrawable(Drawable d) {
            if (d != null) {
                d.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
            super.setIndeterminateDrawable(d);
        }
    }
}

