/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.widget.LayoutInfo;
import com.facebook.litho.widget.RenderInfo;

public class LinearLayoutInfo
implements LayoutInfo {
    private static final int MAX_SANE_RANGE = 10;
    private static final int MIN_SANE_RANGE = 2;
    private final LinearLayoutManager mLinearLayoutManager;

    public LinearLayoutInfo(LinearLayoutManager linearLayoutManager) {
        this.mLinearLayoutManager = linearLayoutManager;
    }

    public LinearLayoutInfo(Context context, int orientation, boolean reverseLayout) {
        this.mLinearLayoutManager = orientation == 0 ? new LinearLayoutManagerNoPredictiveAnim(context, orientation, reverseLayout) : new LinearLayoutManager(context, orientation, reverseLayout);
        this.mLinearLayoutManager.setMeasurementCacheEnabled(false);
    }

    @Override
    public int getScrollDirection() {
        return this.mLinearLayoutManager.getOrientation();
    }

    @Override
    public int findFirstVisibleItemPosition() {
        return this.mLinearLayoutManager.findFirstVisibleItemPosition();
    }

    @Override
    public int findLastVisibleItemPosition() {
        return this.mLinearLayoutManager.findLastVisibleItemPosition();
    }

    @Override
    public int findFirstFullyVisibleItemPosition() {
        return this.mLinearLayoutManager.findFirstCompletelyVisibleItemPosition();
    }

    @Override
    public int findLastFullyVisibleItemPosition() {
        return this.mLinearLayoutManager.findLastCompletelyVisibleItemPosition();
    }

    @Override
    public int getItemCount() {
        return this.mLinearLayoutManager.getItemCount();
    }

    @Override
    public RecyclerView.LayoutManager getLayoutManager() {
        return this.mLinearLayoutManager;
    }

    @Override
    public void setRenderInfoCollection(LayoutInfo.RenderInfoCollection renderInfoCollection) {
    }

    @Override
    public int approximateRangeSize(int firstMeasuredItemWidth, int firstMeasuredItemHeight, int recyclerMeasuredWidth, int recyclerMeasuredHeight) {
        int approximateRange;
        switch (this.mLinearLayoutManager.getOrientation()) {
            case 0: {
                approximateRange = (int)Math.ceil((float)recyclerMeasuredWidth / (float)firstMeasuredItemWidth);
                break;
            }
            default: {
                approximateRange = (int)Math.ceil((float)recyclerMeasuredHeight / (float)firstMeasuredItemHeight);
            }
        }
        if (approximateRange < 2) {
            approximateRange = 2;
        } else if (approximateRange > 10) {
            approximateRange = 10;
        }
        return approximateRange;
    }

    @Override
    public int getChildHeightSpec(int heightSpec, RenderInfo renderInfo) {
        switch (this.mLinearLayoutManager.getOrientation()) {
            case 0: {
                return heightSpec;
            }
        }
        return SizeSpec.makeSizeSpec((int)0, (int)0);
    }

    @Override
    public int getChildWidthSpec(int widthSpec, RenderInfo renderInfo) {
        switch (this.mLinearLayoutManager.getOrientation()) {
            case 0: {
                return SizeSpec.makeSizeSpec((int)0, (int)0);
            }
        }
        return widthSpec;
    }

    private static class LinearLayoutManagerNoPredictiveAnim
    extends LinearLayoutManager {
        public LinearLayoutManagerNoPredictiveAnim(Context context, int orientation, boolean reverseLayout) {
            super(context, orientation, reverseLayout);
        }

        public boolean supportsPredictiveItemAnimations() {
            return false;
        }
    }
}

