/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.graphics.Canvas;
import android.graphics.Picture;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.VisibleForTesting;
import android.text.Layout;
import com.facebook.fbui.textlayoutbuilder.util.LayoutMeasureUtil;
import java.lang.ref.WeakReference;

public class GlyphWarmer {
    private static final String TAG = GlyphWarmer.class.getName();
    private static final int WARMER_THREAD_PRIORITY = 14;
    private static GlyphWarmer sInstance;
    private final WarmerHandler mHandler;

    public static synchronized GlyphWarmer getInstance() {
        if (sInstance == null) {
            sInstance = new GlyphWarmer();
        }
        return sInstance;
    }

    private GlyphWarmer() {
        HandlerThread handlerThread = new HandlerThread(TAG, 14);
        handlerThread.start();
        this.mHandler = new WarmerHandler(handlerThread.getLooper());
    }

    @VisibleForTesting
    Looper getWarmerLooper() {
        return this.mHandler.getLooper();
    }

    public void warmLayout(Layout layout) {
        this.mHandler.obtainMessage(0, new WeakReference<Layout>(layout)).sendToTarget();
    }

    private static final class WarmerHandler
    extends Handler {
        public static final int WARM_LAYOUT = 0;
        private final Picture mPicture;

        private WarmerHandler(Looper looper) {
            super(looper);
            Picture picture;
            try {
                picture = new Picture();
            }
            catch (RuntimeException e) {
                picture = null;
            }
            this.mPicture = picture;
        }

        public void handleMessage(Message msg) {
            if (this.mPicture == null) {
                return;
            }
            try {
                Layout layout = (Layout)((WeakReference)msg.obj).get();
                if (layout == null) {
                    return;
                }
                Canvas canvas = this.mPicture.beginRecording(layout.getWidth(), LayoutMeasureUtil.getHeight((Layout)layout));
                layout.draw(canvas);
                this.mPicture.endRecording();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

