/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.os.Build;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Layout;
import android.text.TextUtils;
import android.text.TextWatcher;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.EventHandler;
import com.facebook.litho.Output;
import com.facebook.litho.R;
import com.facebook.litho.Size;
import com.facebook.litho.annotations.MountSpec;
import com.facebook.litho.annotations.OnBind;
import com.facebook.litho.annotations.OnMount;
import com.facebook.litho.annotations.OnUnbind;
import com.facebook.litho.annotations.OnUnmount;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropDefault;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.utils.MeasureUtils;
import com.facebook.litho.widget.EditText;
import com.facebook.litho.widget.TextChangedEvent;

@MountSpec(isPureRender=true, events={TextChangedEvent.class})
class EditTextSpec {
    private static final Layout.Alignment[] ALIGNMENT = Layout.Alignment.values();
    private static final TextUtils.TruncateAt[] TRUNCATE_AT = TextUtils.TruncateAt.values();
    private static final Typeface DEFAULT_TYPEFACE = Typeface.DEFAULT;
    private static final int DEFAULT_COLOR = 0;
    private static final int[][] DEFAULT_TEXT_COLOR_STATE_LIST_STATES = new int[][]{{0}};
    private static final int[] DEFAULT_TEXT_COLOR_STATE_LIST_COLORS = new int[]{-16777216};
    private static final int DEFAULT_HINT_COLOR = 0;
    private static final int[][] DEFAULT_HINT_COLOR_STATE_LIST_STATES = new int[][]{{0}};
    private static final int[] DEFAULT_HINT_COLOR_STATE_LIST_COLORS = new int[]{-3355444};
    private static final int DEFAULT_GRAVITY = 8388627;
    @PropDefault
    protected static final int minLines = Integer.MIN_VALUE;
    @PropDefault
    protected static final int maxLines = Integer.MAX_VALUE;
    @PropDefault
    protected static final int maxLength = Integer.MAX_VALUE;
    @PropDefault
    protected static final int shadowColor = -7829368;
    @PropDefault
    protected static final int textColor = 0;
    @PropDefault
    protected static final ColorStateList textColorStateList = new ColorStateList(DEFAULT_TEXT_COLOR_STATE_LIST_STATES, DEFAULT_TEXT_COLOR_STATE_LIST_COLORS);
    @PropDefault
    protected static final int hintColor = 0;
    @PropDefault
    protected static final ColorStateList hintColorStateList = new ColorStateList(DEFAULT_HINT_COLOR_STATE_LIST_STATES, DEFAULT_HINT_COLOR_STATE_LIST_COLORS);
    @PropDefault
    protected static final int linkColor = 0;
    @PropDefault
    protected static final int textSize = 13;
    @PropDefault
    protected static final int textStyle = DEFAULT_TYPEFACE.getStyle();
    @PropDefault
    protected static final Typeface typeface = DEFAULT_TYPEFACE;
    @PropDefault
    protected static final float spacingMultiplier = 1.0f;
    @PropDefault
    protected static final Layout.Alignment textAlignment = Layout.Alignment.ALIGN_NORMAL;
    @PropDefault
    protected static final int gravity = 8388627;
    @PropDefault
    protected static final boolean editable = true;
    @PropDefault
    protected static final int selection = -1;
    @PropDefault
    protected static final int inputType = 131073;
    @PropDefault
    protected static final int rawInputType = 0;
    @PropDefault
    protected static final int imeOptions = 0;

    EditTextSpec() {
    }

    static void onLoadStyle(ComponentContext c, Output<TextUtils.TruncateAt> ellipsize, Output<Float> spacingMultiplier, Output<Integer> minLines, Output<Integer> maxLines, Output<Boolean> isSingleLine, Output<CharSequence> text, Output<ColorStateList> textColorStateList, Output<Integer> linkColor, Output<Integer> highlightColor, Output<Integer> textSize, Output<Layout.Alignment> textAlignment, Output<Integer> textStyle, Output<Float> shadowRadius, Output<Float> shadowDx, Output<Float> shadowDy, Output<Integer> shadowColor, Output<Integer> gravity, Output<Integer> inputType, Output<Integer> imeOptions) {
        TypedArray a = c.obtainStyledAttributes(R.styleable.Text, 0);
        int size = a.getIndexCount();
        for (int i = 0; i < size; ++i) {
            int attr = a.getIndex(i);
            if (attr == R.styleable.Text_android_text) {
                text.set((Object)a.getString(attr));
                continue;
            }
            if (attr == R.styleable.Text_android_textColor) {
                textColorStateList.set((Object)a.getColorStateList(attr));
                continue;
            }
            if (attr == R.styleable.Text_android_textSize) {
                textSize.set((Object)a.getDimensionPixelSize(attr, 0));
                continue;
            }
            if (attr == R.styleable.Text_android_ellipsize) {
                int index = a.getInteger(attr, 0);
                if (index <= 0) continue;
                ellipsize.set((Object)TRUNCATE_AT[index - 1]);
                continue;
            }
            if (Build.VERSION.SDK_INT >= 17 && attr == R.styleable.Text_android_textAlignment) {
                textAlignment.set((Object)ALIGNMENT[a.getInteger(attr, 0)]);
                continue;
            }
            if (attr == R.styleable.Text_android_minLines) {
                minLines.set((Object)a.getInteger(attr, -1));
                continue;
            }
            if (attr == R.styleable.Text_android_maxLines) {
                maxLines.set((Object)a.getInteger(attr, -1));
                continue;
            }
            if (attr == R.styleable.Text_android_singleLine) {
                isSingleLine.set((Object)a.getBoolean(attr, false));
                continue;
            }
            if (attr == R.styleable.Text_android_textColorLink) {
                linkColor.set((Object)a.getColor(attr, 0));
                continue;
            }
            if (attr == R.styleable.Text_android_textColorHighlight) {
                highlightColor.set((Object)a.getColor(attr, 0));
                continue;
            }
            if (attr == R.styleable.Text_android_textStyle) {
                textStyle.set((Object)a.getInteger(attr, 0));
                continue;
            }
            if (attr == R.styleable.Text_android_lineSpacingMultiplier) {
                spacingMultiplier.set((Object)Float.valueOf(a.getFloat(attr, 0.0f)));
                continue;
            }
            if (attr == R.styleable.Text_android_shadowDx) {
                shadowDx.set((Object)Float.valueOf(a.getFloat(attr, 0.0f)));
                continue;
            }
            if (attr == R.styleable.Text_android_shadowDy) {
                shadowDy.set((Object)Float.valueOf(a.getFloat(attr, 0.0f)));
                continue;
            }
            if (attr == R.styleable.Text_android_shadowRadius) {
                shadowRadius.set((Object)Float.valueOf(a.getFloat(attr, 0.0f)));
                continue;
            }
            if (attr == R.styleable.Text_android_shadowColor) {
                shadowColor.set((Object)a.getColor(attr, 0));
                continue;
            }
            if (attr == R.styleable.Text_android_gravity) {
                gravity.set((Object)a.getInteger(attr, 0));
                continue;
            }
            if (attr == R.styleable.Text_android_inputType) {
                inputType.set((Object)a.getInteger(attr, 0));
                continue;
            }
            if (attr != R.styleable.Text_android_imeOptions) continue;
            imeOptions.set((Object)a.getInteger(attr, 0));
        }
        a.recycle();
    }

    static void onMeasure(ComponentContext c, ComponentLayout layout, int widthSpec, int heightSpec, Size size, @Prop(optional=true, resType=ResType.STRING) CharSequence text, @Prop(optional=true, resType=ResType.STRING) CharSequence hint, @Prop(optional=true) TextUtils.TruncateAt ellipsize, @Prop(optional=true, resType=ResType.INT) int minLines, @Prop(optional=true, resType=ResType.INT) int maxLines, @Prop(optional=true, resType=ResType.INT) int maxLength, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowRadius, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDx, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDy, @Prop(optional=true, resType=ResType.COLOR) int shadowColor, @Prop(optional=true, resType=ResType.BOOL) boolean isSingleLine, @Prop(optional=true, resType=ResType.COLOR) int textColor, @Prop(optional=true) ColorStateList textColorStateList, @Prop(optional=true, resType=ResType.COLOR) int hintColor, @Prop(optional=true) ColorStateList hintColorStateList, @Prop(optional=true, resType=ResType.COLOR) int linkColor, @Prop(optional=true, resType=ResType.COLOR) int highlightColor, @Prop(optional=true, resType=ResType.DIMEN_TEXT) int textSize, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float extraSpacing, @Prop(optional=true, resType=ResType.FLOAT) float spacingMultiplier, @Prop(optional=true) int textStyle, @Prop(optional=true) Typeface typeface, @Prop(optional=true) Layout.Alignment textAlignment, @Prop(optional=true) int gravity, @Prop(optional=true) boolean editable, @Prop(optional=true) int selection, @Prop(optional=true) int inputType, @Prop(optional=true) int rawInputType, @Prop(optional=true) int imeOptions) {
        android.widget.EditText editText = new android.widget.EditText((Context)c);
        EditTextSpec.initEditText(editText, text, hint, ellipsize, minLines, maxLines, maxLength, shadowRadius, shadowDx, shadowDy, shadowColor, isSingleLine, textColor, textColorStateList, hintColor, hintColorStateList, linkColor, highlightColor, textSize, extraSpacing, spacingMultiplier, textStyle, typeface, textAlignment, gravity, editable, selection, inputType, rawInputType, imeOptions);
        editText.measure(MeasureUtils.getViewMeasureSpec((int)widthSpec), MeasureUtils.getViewMeasureSpec((int)heightSpec));
        size.width = editText.getMeasuredWidth();
        size.height = editText.getMeasuredHeight();
    }

    protected static EditTextTextTextChangedEventHandler onCreateMountContent(ComponentContext c) {
        return new EditTextTextTextChangedEventHandler((Context)c);
    }

    @OnMount
    static void onMount(ComponentContext c, EditTextTextTextChangedEventHandler editText, @Prop(optional=true, resType=ResType.STRING) CharSequence text, @Prop(optional=true, resType=ResType.STRING) CharSequence hint, @Prop(optional=true) TextUtils.TruncateAt ellipsize, @Prop(optional=true, resType=ResType.INT) int minLines, @Prop(optional=true, resType=ResType.INT) int maxLines, @Prop(optional=true, resType=ResType.INT) int maxLength, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowRadius, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDx, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDy, @Prop(optional=true, resType=ResType.COLOR) int shadowColor, @Prop(optional=true, resType=ResType.BOOL) boolean isSingleLine, @Prop(optional=true, resType=ResType.COLOR) int textColor, @Prop(optional=true) ColorStateList textColorStateList, @Prop(optional=true, resType=ResType.COLOR) int hintColor, @Prop(optional=true) ColorStateList hintColorStateList, @Prop(optional=true, resType=ResType.COLOR) int linkColor, @Prop(optional=true, resType=ResType.COLOR) int highlightColor, @Prop(optional=true, resType=ResType.DIMEN_TEXT) int textSize, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float extraSpacing, @Prop(optional=true, resType=ResType.FLOAT) float spacingMultiplier, @Prop(optional=true) int textStyle, @Prop(optional=true) Typeface typeface, @Prop(optional=true) Layout.Alignment textAlignment, @Prop(optional=true) int gravity, @Prop(optional=true) boolean editable, @Prop(optional=true) int selection, @Prop(optional=true) int inputType, @Prop(optional=true) int rawInputType, @Prop(optional=true) int imeOptions) {
        EditTextSpec.initEditText(editText, text, hint, ellipsize, minLines, maxLines, maxLength, shadowRadius, shadowDx, shadowDy, shadowColor, isSingleLine, textColor, textColorStateList, hintColor, hintColorStateList, linkColor, highlightColor, textSize, extraSpacing, spacingMultiplier, textStyle, typeface, textAlignment, gravity, editable, selection, inputType, rawInputType, imeOptions);
    }

    @OnBind
    static void onBind(ComponentContext c, EditTextTextTextChangedEventHandler editText) {
        editText.setEventHandler(EditText.getTextChangedEventHandler(c));
        editText.attachWatcher();
    }

    @OnUnbind
    static void onUnbind(ComponentContext c, EditTextTextTextChangedEventHandler editText) {
        editText.setEventHandler(null);
        editText.detachWatcher();
    }

    @OnUnmount
    static void onUnmount(ComponentContext c, EditTextTextTextChangedEventHandler editText) {
    }

    private static void initEditText(android.widget.EditText editText, CharSequence text, CharSequence hint, TextUtils.TruncateAt ellipsize, int minLines, int maxLines, int maxLength, float shadowRadius, float shadowDx, float shadowDy, int shadowColor, boolean isSingleLine, int textColor, ColorStateList textColorStateList, int hintColor, ColorStateList hintColorStateList, int linkColor, int highlightColor, int textSize, float extraSpacing, float spacingMultiplier, int textStyle, Typeface typeface, Layout.Alignment textAlignment, int gravity, boolean editable, int selection, int inputType, int rawInputType, int imeOptions) {
        editText.setSingleLine(isSingleLine);
        inputType = isSingleLine ? (inputType &= 0xFFFDFFFF) : (inputType |= 0x20000);
        if (rawInputType != 0) {
            editText.setRawInputType(rawInputType);
        } else if (inputType != editText.getInputType()) {
            editText.setInputType(inputType);
        }
        editText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxLength)});
        if (!(text instanceof String) || !text.equals(editText.getText().toString())) {
            editText.setText(text);
        }
        editText.setHint(hint);
        editText.setEllipsize(ellipsize);
        editText.setMinLines(minLines);
        editText.setMaxLines(maxLines);
        editText.setShadowLayer(shadowRadius, shadowDx, shadowDy, shadowColor);
        editText.setLinkTextColor(linkColor);
        editText.setHighlightColor(highlightColor);
        editText.setTextSize(0, (float)textSize);
        editText.setLineSpacing(extraSpacing, spacingMultiplier);
        editText.setTypeface(typeface, textStyle);
        editText.setGravity(gravity);
        editText.setImeOptions(imeOptions);
        editText.setFocusable(editable);
        editText.setFocusableInTouchMode(editable);
        editText.setClickable(editable);
        editText.setLongClickable(editable);
        editText.setCursorVisible(editable);
        if (selection > -1) {
            editText.setSelection(selection);
        }
        if (textColor != 0) {
            editText.setTextColor(textColor);
        } else {
            editText.setTextColor(textColorStateList);
        }
        if (hintColor != 0) {
            editText.setHintTextColor(hintColor);
        } else {
            editText.setHintTextColor(hintColorStateList);
        }
        switch (textAlignment) {
            case ALIGN_NORMAL: {
                if (Build.VERSION.SDK_INT >= 17) {
                    editText.setTextAlignment(2);
                    break;
                }
                editText.setGravity(gravity | 3);
                break;
            }
            case ALIGN_OPPOSITE: {
                if (Build.VERSION.SDK_INT >= 17) {
                    editText.setTextAlignment(3);
                    break;
                }
                editText.setGravity(gravity | 5);
                break;
            }
            case ALIGN_CENTER: {
                if (Build.VERSION.SDK_INT >= 17) {
                    editText.setTextAlignment(4);
                    break;
                }
                editText.setGravity(gravity | 1);
            }
        }
    }

    static class EditTextTextTextChangedEventHandler
    extends android.widget.EditText {
        private final TextWatcher mTextWatcher = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (EditTextTextTextChangedEventHandler.this.mEventHandler != null) {
                    EditText.dispatchTextChangedEvent(EditTextTextTextChangedEventHandler.this.mEventHandler, s.toString());
                }
            }
        };
        private EventHandler mEventHandler;

        EditTextTextTextChangedEventHandler(Context context) {
            super(context);
        }

        void attachWatcher() {
            this.addTextChangedListener(this.mTextWatcher);
        }

        void detachWatcher() {
            this.removeTextChangedListener(this.mTextWatcher);
        }

        public void setEventHandler(EventHandler eventHandler) {
            this.mEventHandler = eventHandler;
        }
    }
}

