/*
 * Copyright 2014-present Facebook, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.facebook.litho.annotations;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * Annotation for a method on a component's spec that indicates that the method is used to calculate
 * a value that is cached by the component, and may be access in methods using {@link CachedValue}.
 */
@Retention(RetentionPolicy.RUNTIME)
public @interface OnCalculateCachedValue {

  /** @return the name of the {@link CachedValue} that is being calculated. */
  String name();
}
